/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_HeadMarkerModule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.TokenStartComparator;
import org.corpus_tools.salt.util.internal.DataSourceAccessor;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="HeadMarkerModuleManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class HeadMarkerModuleManipulator
extends PepperManipulatorImpl {
    public HeadMarkerModuleManipulator() {
        this.setName("HeadMarker");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This manipulator attaches spans to tokens with incoming pointing relations coming from outside the span");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        HeadMarkerModuleMapper mapper = new HeadMarkerModuleMapper();
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return true;
    }

    private static boolean edgeTypeMatch(SRelation rel, String type, String anno, String ignore) {
        boolean found = false;
        if (!"".equals(type) && !rel.getType().equals(type)) {
            return false;
        }
        if (!"".equals(anno)) {
            Set annos = rel.getAnnotations();
            for (SAnnotation a : annos) {
                if (!a.getName().equals(anno)) continue;
                if (a.getValue_STEXT().equals(ignore)) {
                    return false;
                }
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public static List<SToken> getSortedSTokenByText(SDocumentGraph documentGraph, List<SToken> sTokens2sort) {
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method please set the document graph first.");
        }
        ArrayList<SToken> retVal = null;
        if (sTokens2sort != null) {
            TokenStartComparator comparator = new TokenStartComparator();
            comparator.setDocumentGraph(documentGraph);
            retVal = new ArrayList<SToken>();
            retVal.addAll(sTokens2sort);
            Collections.sort(retVal, comparator);
        }
        return retVal;
    }

    public static void addRel(SSpan span, SToken token, SDocumentGraph graph, String headRelType, SLayer headRelLayer, boolean useDominanceRelations) {
        Object newRel = useDominanceRelations ? SaltFactory.createSDominanceRelation() : SaltFactory.createSPointingRelation();
        newRel.setSource((Node)span);
        newRel.setTarget((Node)token);
        newRel.setType(headRelType);
        if (headRelLayer != null) {
            newRel.addLayer((Layer)headRelLayer);
        }
        graph.addRelation((Relation)newRel);
    }

    public static class HeadMarkerModuleMapper
    extends PepperMapperImpl
    implements GraphTraverseHandler {
        public DOCUMENT_STATUS mapSCorpus() {
            return DOCUMENT_STATUS.COMPLETED;
        }

        public DOCUMENT_STATUS mapSDocument() {
            String spanLayer = this.getProperties().getProperties().getProperty("HeadMarker.spanLayer", "");
            String spanAnnotation = this.getProperties().getProperties().getProperty("HeadMarker.spanAnnotation", "");
            String edgeType = this.getProperties().getProperties().getProperty("HeadMarker.edgeType", "dep");
            String edgeAnnotation = this.getProperties().getProperties().getProperty("HeadMarker.edgeAnnotation", "func");
            String ignoreEdgeAnnotation = this.getProperties().getProperties().getProperty("HeadMarker.ignoreEdgeAnnotation", "punct");
            String headRelType = this.getProperties().getProperties().getProperty("HeadMarker.headRelType", "head");
            String headRelLayerName = this.getProperties().getProperties().getProperty("HeadMarker.headRelLayerName", "head");
            boolean useDominanceRelations = Boolean.valueOf(this.getProperties().getProperties().getProperty("HeadMarker.useDominanceRelations"));
            boolean ignoreRoots = Boolean.valueOf(this.getProperties().getProperties().getProperty("HeadMarker.ignoreRoot"));
            SLayer headRelLayer = null;
            if (headRelLayerName != "") {
                headRelLayer = SaltFactory.createSLayer();
                headRelLayer.setName(headRelLayerName);
            }
            TokenStartComparator comparator = new TokenStartComparator();
            comparator.setDocumentGraph(this.getDocument().getDocumentGraph());
            List spans = this.getDocument().getDocumentGraph().getSpans();
            block0: for (SSpan span : spans) {
                boolean found;
                if (spanAnnotation != "") {
                    Set annos = span.getAnnotations();
                    found = false;
                    for (SAnnotation anno : annos) {
                        if (!anno.getName().equals(spanAnnotation)) continue;
                        found = true;
                    }
                    if (!found) {
                        throw new PepperModuleDataException((PepperMapper)this, "no anno");
                    }
                }
                if (spanLayer != "") {
                    Set layers = span.getLayers();
                    found = false;
                    for (SLayer layer : layers) {
                        if (!layer.getName().equals(spanLayer)) continue;
                        found = true;
                    }
                    if (!found) continue;
                }
                List tokens = DataSourceAccessor.getOverlappedSTokens((SDocumentGraph)this.getDocument().getDocumentGraph(), (SNode)span, (SALT_TYPE[])new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
                List<SToken> sortedTokens = HeadMarkerModuleManipulator.getSortedSTokenByText(this.getDocument().getDocumentGraph(), tokens);
                SToken startToken = sortedTokens.get(0);
                SToken endToken = sortedTokens.get(sortedTokens.size() - 1);
                boolean found2 = false;
                for (SNode sNode : sortedTokens) {
                    if (found2) {
                        found2 = false;
                        continue block0;
                    }
                    List rels = sNode.getInRelations();
                    ArrayList<SPointingRelation> pRels = new ArrayList<SPointingRelation>();
                    for (SRelation sRelation : rels) {
                        if (!(sRelation instanceof SPointingRelation) || !HeadMarkerModuleManipulator.edgeTypeMatch(sRelation, edgeType, edgeAnnotation, "")) continue;
                        pRels.add((SPointingRelation)sRelation);
                    }
                    if (pRels.size() == 0 && !ignoreRoots) {
                        HeadMarkerModuleManipulator.addRel(span, (SToken)sNode, this.getDocument().getDocumentGraph(), headRelType, headRelLayer, useDominanceRelations);
                        continue block0;
                    }
                    for (SPointingRelation sPointingRelation : pRels) {
                        SNode source = (SNode)sPointingRelation.getSource();
                        if (!(source instanceof SToken)) continue;
                        if (comparator.compare((SToken)source, endToken) > 0) {
                            if (HeadMarkerModuleManipulator.edgeTypeMatch((SRelation)sPointingRelation, edgeType, edgeAnnotation, ignoreEdgeAnnotation)) {
                                found2 = true;
                            }
                        } else if (comparator.compare((SToken)source, startToken) < 0 && HeadMarkerModuleManipulator.edgeTypeMatch((SRelation)sPointingRelation, edgeType, edgeAnnotation, ignoreEdgeAnnotation)) {
                            found2 = true;
                        }
                        if (!found2) continue;
                        HeadMarkerModuleManipulator.addRel(span, (SToken)sNode, this.getDocument().getDocumentGraph(), headRelType, headRelLayer, useDominanceRelations);
                    }
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
            return !(currNode instanceof STextualDS);
        }
    }
}

