/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.Collection;
import java.util.Map;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Maps;

public final class DefaultToString {
    private static final String TUPPLE_START = "(";
    private static final String TUPPLE_END = ")";

    public static String toStringOf(Representation representation, Object o) {
        if (Arrays.isArray(o)) {
            return Arrays.format(representation, o);
        }
        if (o instanceof Collection) {
            return IterableUtil.smartFormat(representation, (Collection)o);
        }
        if (o instanceof Map) {
            return Maps.format(representation, (Map)o);
        }
        if (o instanceof Tuple) {
            return DefaultToString.toStringOf((Tuple)o, representation);
        }
        if (o instanceof MapEntry) {
            return DefaultToString.toStringOf((MapEntry)o, representation);
        }
        return o == null ? null : o.toString();
    }

    public static String toStringOf(Tuple tuple, Representation representation) {
        return IterableUtil.singleLineFormat(representation, tuple.toList(), TUPPLE_START, TUPPLE_END);
    }

    public static String toStringOf(MapEntry<?, ?> mapEntry, Representation representation) {
        return String.format("MapEntry[key=%s, value=%s]", representation.toStringOf(mapEntry.key), representation.toStringOf(mapEntry.value));
    }

    private DefaultToString() {
    }
}

