/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf.tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.corpus_tools.peppermodules.graf.GrAFImporter;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IGraph;
import org.xces.graf.io.dom.ResourceHeader;
import org.xml.sax.SAXException;

public class RootTest {
    public static void main(String[] args) throws GrafException, SAXException, IOException {
        String corpusPath = System.getProperty("user.home").toString() + "/corpora/MASC-3.0.0/";
        File headerFile = new File(corpusPath, "resource-header.xml");
        ResourceHeader rscHeader = new ResourceHeader(headerFile);
        List<String> docHeaderPaths = GrAFImporter.recursiveListDir(corpusPath, "hdr");
        for (String docHeaderPath : docHeaderPaths) {
            IGraph graph = GrafReader.getAnnoGraph(rscHeader, docHeaderPath);
            if (graph.getRoot() != null) {
                System.out.println("document " + docHeaderPath + " has this root: " + graph.getRoot());
                continue;
            }
            System.out.print("no root. ");
        }
    }
}

