/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf.tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.corpus_tools.peppermodules.graf.GrAFImporter;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.IRegion;
import org.xces.graf.io.dom.ResourceHeader;
import org.xml.sax.SAXException;

public class RegionNodesTest {
    public static void main(String[] args) throws XPathExpressionException, GrafException, SAXException, IOException {
        String corpusPath = System.getProperty("user.home").toString() + "/corpora/masc_nyt/";
        File headerFile = new File(corpusPath, "resource-header.xml");
        ResourceHeader rscHeader = new ResourceHeader(headerFile);
        List<String> docHeaderPaths = GrAFImporter.recursiveListDir(corpusPath, "hdr");
        for (String docHeaderPath : docHeaderPaths) {
            System.out.println("DEBUG document: " + docHeaderPath);
            IGraph graph = GrafReader.getAnnoGraph(rscHeader, docHeaderPath);
            IGraph fixedIGraph = GrAFImporter.repairFloatingNodes(graph);
            RegionNodesTest.printRegionNodeStatistics(fixedIGraph);
        }
    }

    public static void printRegionNodeStatistics(IGraph graph) {
        int nonAnnotatedRegions = 0;
        int annotatedRegions = 0;
        for (IRegion region : graph.getRegions()) {
            if (region.getNodes().isEmpty()) {
                ++nonAnnotatedRegions;
                continue;
            }
            ++annotatedRegions;
        }
        System.out.println("IGraph has " + annotatedRegions + " annotated regions and " + nonAnnotatedRegions + " non-annotated regions");
    }
}

