/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf.tests;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.corpus_tools.peppermodules.graf.DepthFirstSearch;
import org.corpus_tools.peppermodules.graf.GrAFImporter;
import org.corpus_tools.peppermodules.graf.GrafDocumentHeader;
import org.corpus_tools.peppermodules.graf.GrafGraphInfo;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.INode;
import org.xces.graf.io.dom.ResourceHeader;
import org.xml.sax.SAXException;

public class FloatingNodesTest {
    public static void main(String[] args) throws XPathExpressionException, GrafException, SAXException, IOException {
        String corpusPath = System.getProperty("user.home").toString() + "/corpora/masc_one/";
        File headerFile = new File(corpusPath, "resource-header.xml");
        ResourceHeader rscHeader = new ResourceHeader(headerFile);
        List<String> docHeaderPaths = GrAFImporter.recursiveListDir(corpusPath, "hdr");
        ArrayList<String> desiredDocHeaderPaths = new ArrayList<String>();
        for (String docHeaderPath : docHeaderPaths) {
            GrafDocumentHeader docHeader = new GrafDocumentHeader(docHeaderPath);
            List annoTypes = docHeader.getAnnotationTypes();
            if (!annoTypes.contains("f.ptb")) continue;
            desiredDocHeaderPaths.add(docHeaderPath);
        }
        for (String docHeaderPath : desiredDocHeaderPaths) {
            IGraph graph = GrafReader.getAnnoGraph(rscHeader, docHeaderPath);
            GrafGraphInfo.printAnnotationSpacesInfo(graph);
            for (INode node : graph.getNodes()) {
                if (!GrafReader.isFloatingNode(node)) continue;
                System.out.println("\n\nfloating node: " + node.getId());
                INode rootNode = GrafReader.getRootNodeFromNode(node, graph);
                DepthFirstSearch floatSearch = new DepthFirstSearch(graph, node);
                INode precedingLeafNode = floatSearch.getPrecedingLeafNode(graph, node);
                if (precedingLeafNode != null) {
                    System.out.println("\t\tpreceding leaf node: " + floatSearch.getPrecedingLeafNode(graph, node).getId());
                } else {
                    System.out.println("\t\t there's no preceding leaf node!");
                }
                INode succeedingLeafNode = floatSearch.getSucceedingLeafNode(graph, node);
                if (succeedingLeafNode != null) {
                    System.out.println("\t\tsucceeding leaf node: " + floatSearch.getSucceedingLeafNode(graph, node).getId());
                    continue;
                }
                System.out.println("\t\t there's no succeeding leaf node!");
            }
        }
    }
}

