/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IAnchor;
import org.xces.graf.api.IAnnotation;
import org.xces.graf.api.IAnnotationSpace;
import org.xces.graf.api.IFeature;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.ILink;
import org.xces.graf.api.INode;
import org.xces.graf.api.IRegion;

public class SaltWriter {
    protected static final Logger logger = LoggerFactory.getLogger((String)"GrAFImporter");
    public static SALT_TYPE domRel = SALT_TYPE.SDOMINANCE_RELATION;
    private static int floatingNodeCount;
    private static HashMap<String, SLayer> annoSpaceSLayerMap;

    public static void addAnnotationToNode(String sAnnotationName, String sAnnotationId, String sAnnotationValue, String sAnnotationNamespace, SNode sNode) {
        HashSet<String> existingAnnotationSNames = new HashSet<String>();
        for (SAnnotation existingAnno : sNode.getAnnotations()) {
            existingAnnotationSNames.add(existingAnno.getName());
        }
        if (!existingAnnotationSNames.contains(sAnnotationName)) {
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName(sAnnotationName);
            sAnno.setValue((Object)sAnnotationValue);
            sAnno.setNamespace(sAnnotationNamespace);
            sNode.addAnnotation(sAnno);
        }
    }

    public static void addPrimaryTextToDocument(SDocument sDocument, String primaryText) {
        if (sDocument == null) {
            throw new PepperModuleException("Cannot create example, because the given sDocument is empty.");
        }
        if (sDocument.getDocumentGraph() == null) {
            throw new PepperModuleException("Cannot create example, because the given sDocument does not contain an SDocumentGraph.");
        }
        STextualDS sTextualDS = null;
        sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setText(primaryText);
        sDocument.getDocumentGraph().addNode((Node)sTextualDS);
    }

    public static List<String> addIRegionToSDocument(IRegion iRegion, SDocument sDocument, HashMap<String, SLayer> annoSpaceSLayerMap) {
        String iRegionId = iRegion.getId();
        List anchors = iRegion.getAnchors();
        int startAnchor = Integer.parseInt(((IAnchor)anchors.get(0)).writeString());
        int endAnchor = Integer.parseInt(((IAnchor)anchors.get(1)).writeString());
        ArrayList<String> sTokenIds = new ArrayList<String>();
        List annoNodes = iRegion.getNodes();
        if (annoNodes.isEmpty()) {
            SLayer regionLayer = annoSpaceSLayerMap.get("not-annotated");
            String sTokenId = SaltWriter.addTokenToDocument(startAnchor, endAnchor, sDocument, regionLayer, iRegionId);
            sTokenIds.add(sTokenId);
        } else {
            for (INode annoNode : annoNodes) {
                String annoSpaceName = annoNode.getAnnotation().getAnnotationSpace().getName();
                SLayer regionLayer = annoSpaceSLayerMap.get(annoSpaceName);
                String sTokenId = SaltWriter.addTokenToDocument(startAnchor, endAnchor, sDocument, regionLayer, iRegionId);
                sTokenIds.add(sTokenId);
            }
        }
        return sTokenIds;
    }

    public static HashMap<String, List<String>> addAllIRegionsToSDocument(IGraph iDocumentGraph, SDocument sDocument) throws GrafException {
        annoSpaceSLayerMap = new HashMap();
        for (IAnnotationSpace annoSpace : iDocumentGraph.getAnnotationSpaces()) {
            String annoSpaceName = annoSpace.getName();
            SaltWriter.addSLayerToSDocument(sDocument, annoSpaceName);
        }
        String annoSpaceName = "not-annotated";
        SaltWriter.addSLayerToSDocument(sDocument, annoSpaceName);
        HashMap<String, List<String>> regionIdToTokenIdsMap = new HashMap<String, List<String>>();
        for (IRegion iRegion : iDocumentGraph.getRegions()) {
            String regionId = iRegion.getId();
            List<String> tokenIds = SaltWriter.addIRegionToSDocument(iRegion, sDocument, annoSpaceSLayerMap);
            regionIdToTokenIdsMap.put(regionId, tokenIds);
        }
        return regionIdToTokenIdsMap;
    }

    public static void addSLayerToSDocument(SDocument doc, String layerName) {
        SLayer annoLayer = SaltFactory.createSLayer();
        annoLayer.setName(layerName);
        annoSpaceSLayerMap.put(layerName, annoLayer);
        doc.getDocumentGraph().addLayer((Layer)annoLayer);
    }

    public static List<SToken> mapRegionsToTokens(List<IRegion> regions, HashMap<String, List<String>> regionIdToTokenIdsMap, SDocumentGraph docGraph) {
        ArrayList<SToken> tokenList = new ArrayList<SToken>();
        for (IRegion region : regions) {
            String regionId = region.getId();
            if (regionIdToTokenIdsMap.containsKey(regionId)) {
                List<String> tokenIds = regionIdToTokenIdsMap.get(regionId);
                for (String tokenId : tokenIds) {
                    SToken sToken = (SToken)docGraph.getNode(tokenId);
                    tokenList.add(sToken);
                }
                continue;
            }
            throw new NullPointerException("There's no SToken mapped to the IRegion " + regionId);
        }
        return tokenList;
    }

    public static String addSSpanToSDocument(List<SToken> sTokens, SDocument sDocument, Set<SLayer> sLayers) {
        ArrayList<SToken> sTokensList = new ArrayList<SToken>(sTokens);
        SSpan sSpan = sDocument.getDocumentGraph().createSpan(sTokensList);
        for (SLayer layer : sLayers) {
            sSpan.addLayer((Layer)layer);
        }
        return sSpan.getId();
    }

    public static HashMap<String, List<String>> addSSpansToSDocument(IGraph iDocumentGraph, SDocument sDocument, HashMap<String, List<String>> regionIdsToTokenIdsMap) throws GrafException {
        SDocumentGraph sDocumentGraph = sDocument.getDocumentGraph();
        HashMap<String, List<String>> iNodeIdsToSNodeIdsMap = new HashMap<String, List<String>>();
        for (INode iNode : iDocumentGraph.getNodes()) {
            List<IRegion> iRegionsCoveredByINode = SaltWriter.getIRegionsCoveredByINode(iNode, sDocumentGraph);
            if (iRegionsCoveredByINode.isEmpty()) {
                if (GrafReader.isFloatingNode(iNode)) {
                    SaltWriter.addFloatingNodeToSDocument(iDocumentGraph, sDocument, iNode, iNodeIdsToSNodeIdsMap);
                    continue;
                }
                logger.debug("INode " + iNode.getId() + " doesn't cover any IRegions but is not a floating node either! Do we need to handle it separately?");
                continue;
            }
            if (iRegionsCoveredByINode.size() == 1) {
                String coveredIRegionId = iRegionsCoveredByINode.get(0).getId();
                SaltWriter.addRegionToINodeSNodeMap(coveredIRegionId, iNode, regionIdsToTokenIdsMap, iNodeIdsToSNodeIdsMap);
                continue;
            }
            if (iRegionsCoveredByINode.size() <= 1) continue;
            SaltWriter.addRegionsToINodeSNodeMap(iNode, iRegionsCoveredByINode, iNodeIdsToSNodeIdsMap, regionIdsToTokenIdsMap, sDocument);
        }
        return iNodeIdsToSNodeIdsMap;
    }

    public static void addFloatingNodeToSDocument(IGraph iDocumentGraph, SDocument sDocument, INode floatingINode, HashMap<String, List<String>> iNodeIdsToSNodeIdsMap) throws GrafException {
        int[] offsets = GrafReader.getFloatingNodeOffsets(iDocumentGraph, floatingINode);
        String annoSpaceName = floatingINode.getAnnotation().getAnnotationSpace().getName();
        SLayer regionLayer = annoSpaceSLayerMap.get(annoSpaceName);
        String regionId = "floating-" + regionLayer.getName() + "-node-" + String.valueOf(floatingNodeCount);
        String fakeTokenId = SaltWriter.addTokenToDocument(offsets[0], offsets[1], sDocument, regionLayer, regionId);
        iNodeIdsToSNodeIdsMap.put(floatingINode.getId(), Arrays.asList(fakeTokenId));
        ++floatingNodeCount;
    }

    public static void addRegionToINodeSNodeMap(String coveredIRegionId, INode iNode, HashMap<String, List<String>> regionIdsToTokenIdsMap, HashMap<String, List<String>> iNodeIdsToSNodeIdsMap) {
        if (!regionIdsToTokenIdsMap.containsKey(coveredIRegionId)) {
            throw new PepperModuleException("IRegion " + coveredIRegionId + " can't be found in regionIdsToTokenIdsMap.");
        }
        List<String> coveredSTokenIds = regionIdsToTokenIdsMap.get(coveredIRegionId);
        iNodeIdsToSNodeIdsMap.put(iNode.getId(), coveredSTokenIds);
    }

    public static void addRegionsToINodeSNodeMap(INode iNode, List<IRegion> iRegionsCoveredByINode, HashMap<String, List<String>> iNodeIdsToSNodeIdsMap, HashMap<String, List<String>> regionIdsToTokenIdsMap, SDocument sDocument) {
        List<SToken> tokens = SaltWriter.mapRegionsToTokens(iRegionsCoveredByINode, regionIdsToTokenIdsMap, sDocument.getDocumentGraph());
        Set<SLayer> sLayers = SaltWriter.mapTokensToSLayers(tokens);
        String sSpanId = SaltWriter.addSSpanToSDocument(tokens, sDocument, sLayers);
        iNodeIdsToSNodeIdsMap.put(iNode.getId(), Arrays.asList(sSpanId));
    }

    public static HashMap<String, List<String>> getINodeIdToIRegionIdsMap(IGraph iDocumentGraph, SDocumentGraph sDocumentGraph) {
        HashMap<String, List<String>> iNodeIdToIRegionIdsMap = new HashMap<String, List<String>>();
        for (INode iNode : iDocumentGraph.getNodes()) {
            List<IRegion> iRegionsCoveredByINode = SaltWriter.getIRegionsCoveredByINode(iNode, sDocumentGraph);
            ArrayList<String> iRegionIds = new ArrayList<String>();
            for (IRegion iRegion : iRegionsCoveredByINode) {
                iRegionIds.add(iRegion.getId());
            }
            iNodeIdToIRegionIdsMap.put(iNode.getId(), iRegionIds);
        }
        return iNodeIdToIRegionIdsMap;
    }

    public static HashMap<String, List<String>> getIRegionIdToINodeIdsMap(IGraph iDocumentGraph) {
        HashMap<String, List<String>> iRegionToINodesMap = new HashMap<String, List<String>>();
        Collection regions = iDocumentGraph.getRegions();
        for (IRegion region : regions) {
            List nodes = region.getNodes();
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (INode node : nodes) {
                nodeIds.add(node.getId());
            }
            iRegionToINodesMap.put(region.getId(), nodeIds);
        }
        return iRegionToINodesMap;
    }

    public static List<IRegion> getIRegionsCoveredByINode(INode iNode, SDocumentGraph sDocumentGraph) {
        ArrayList<IRegion> iRegionsCoveredByINode = new ArrayList<IRegion>();
        List<INode> connectedINodes = GrafReader.getOutboundConnectedNodes(iNode);
        for (INode connectedINode : connectedINodes) {
            List<IRegion> regionsFromConnectedNode = SaltWriter.getIRegionsCoveredByINode(connectedINode, sDocumentGraph);
            iRegionsCoveredByINode.addAll(regionsFromConnectedNode);
        }
        List links = iNode.getLinks();
        for (ILink link : links) {
            List regions = link.getRegions();
            iRegionsCoveredByINode.addAll(regions);
        }
        return iRegionsCoveredByINode;
    }

    public static String addTokenToDocument(int onset, int offset, SDocument sDocument, SLayer layer, String regionId) {
        STextualDS sTextualDS = (STextualDS)sDocument.getDocumentGraph().getTextualDSs().get(0);
        SToken sToken = SaltFactory.createSToken();
        sToken.setName(regionId);
        sDocument.getDocumentGraph().addNode((Node)sToken);
        sToken.addLayer((Layer)layer);
        STextualRelation sTextRel = SaltFactory.createSTextualRelation();
        sTextRel.setSource((Node)sToken);
        sTextRel.setTarget((Node)sTextualDS);
        sTextRel.setStart((Number)onset);
        sTextRel.setEnd((Number)offset);
        sDocument.getDocumentGraph().addRelation((Relation)sTextRel);
        return sToken.getId();
    }

    public static Set<SLayer> mapTokensToSLayers(List<SToken> tokens) {
        HashSet<SLayer> sLayersList = new HashSet<SLayer>();
        for (SToken token : tokens) {
            Set tokenLayers = token.getLayers();
            sLayersList.addAll(tokenLayers);
        }
        return sLayersList;
    }

    public static HashMap<String, SNode> addAnnotationsToSDocument(IGraph iGraph, HashMap<String, List<String>> iNodeIdToSNodeIdMap, SDocument sDocument) throws GrafException {
        SDocumentGraph docGraph = sDocument.getDocumentGraph();
        HashMap<String, SNode> nodeIdToNodeMap = new HashMap<String, SNode>();
        for (SNode sNode : docGraph.getTokens()) {
            nodeIdToNodeMap.put(sNode.getId(), sNode);
        }
        for (SNode sNode : docGraph.getSpans()) {
            nodeIdToNodeMap.put(sNode.getId(), sNode);
        }
        for (String iNodeId : iNodeIdToSNodeIdMap.keySet()) {
            INode annotationINode = iGraph.findNode(iNodeId);
            List<String> sNodeIds = iNodeIdToSNodeIdMap.get(iNodeId);
            for (String sNodeId : sNodeIds) {
                SNode sNode = nodeIdToNodeMap.get(sNodeId);
                SaltWriter.addAnnotationsToSNode(annotationINode, sNode);
            }
        }
        return nodeIdToNodeMap;
    }

    public static void addAnnotationsToSNode(INode annotationINode, SNode sNode) {
        String annotationId = annotationINode.getId();
        IAnnotation iAnnotation = annotationINode.getAnnotation();
        String annoNamespace = iAnnotation.getAnnotationSpace().getName();
        Iterable annoFeatures = iAnnotation.getFeatures().features();
        for (IFeature feature : annoFeatures) {
            SaltWriter.addAnnotationToNode(feature.getName(), annotationId, feature.getStringValue(), annoNamespace, sNode);
        }
    }

    public static HashMap<String, SStructure> createSyntaxINodeSStructures(IGraph syntaxIGraph) {
        HashMap<String, SStructure> iNodeIdToSStructureMap = new HashMap<String, SStructure>();
        Collection syntaxINodes = syntaxIGraph.getNodes();
        for (INode syntaxINode : syntaxINodes) {
            if (syntaxINode.getOutEdges().size() <= 0) continue;
            SStructure syntaxSStructure = SaltFactory.createSStructure();
            syntaxSStructure.setName(syntaxINode.getId());
            syntaxSStructure.setId(syntaxINode.getId());
            SaltWriter.addAnnotationsToSNode(syntaxINode, (SNode)syntaxSStructure);
            iNodeIdToSStructureMap.put(syntaxINode.getId(), syntaxSStructure);
        }
        return iNodeIdToSStructureMap;
    }

    public static void addSyntaxTreeRootDomRelsToDocGraph(IGraph syntaxIGraph, SDocumentGraph docGraph, HashMap<String, SStructure> iNodeIdToSStructureMap, SStructure rootSStructure) throws GrafException {
        for (INode treeRootINode : GrafReader.getRootNodes(syntaxIGraph)) {
            String treeRootNodeId = treeRootINode.getId();
            if (!iNodeIdToSStructureMap.containsKey(treeRootNodeId)) continue;
            SStructure dominatedSStructure = iNodeIdToSStructureMap.get(treeRootNodeId);
            if (!docGraph.getNodes().contains(dominatedSStructure)) {
                docGraph.addNode((Node)dominatedSStructure);
            }
            docGraph.addNode((SNode)rootSStructure, (SNode)dominatedSStructure, domRel);
        }
    }

    public static void addSyntaxNodeDomRelsToDocGraph(IGraph syntaxIGraph, SDocumentGraph docGraph, HashMap<String, SStructure> iNodeIdToSStructureMap, HashMap<String, List<String>> iNodeIDsToSNodeIdsMap, HashMap<String, SNode> sNodeIdToSNodeMap) throws GrafException {
        for (INode syntaxINode : syntaxIGraph.getNodes()) {
            if (syntaxINode.getOutEdges().size() <= 0) continue;
            SStructure sourceSStructure = iNodeIdToSStructureMap.get(syntaxINode.getId());
            if (!docGraph.getNodes().contains(sourceSStructure)) {
                docGraph.addNode((Node)sourceSStructure);
            }
            for (INode connectedSyntaxINode : GrafReader.getOutboundConnectedNodes(syntaxINode)) {
                if (connectedSyntaxINode.getOutEdges().size() == 0) {
                    List linksToTokenRegions = connectedSyntaxINode.getLinks();
                    if (linksToTokenRegions.size() > 0) {
                        SaltWriter.addDomRelToNonFloatingSToken(syntaxIGraph, docGraph, sourceSStructure, linksToTokenRegions);
                        continue;
                    }
                    SaltWriter.addDomRelToFloatingSToken(syntaxIGraph, docGraph, sourceSStructure, connectedSyntaxINode);
                    continue;
                }
                SaltWriter.addDomRelBetweenSyntaxNodes(docGraph, sourceSStructure, connectedSyntaxINode, iNodeIdToSStructureMap, iNodeIDsToSNodeIdsMap, sNodeIdToSNodeMap);
            }
        }
    }

    public static void addDomRelBetweenSyntaxNodes(SDocumentGraph docGraph, SStructure sourceSStructure, INode dominatedINode, HashMap<String, SStructure> iNodeIdToSStructureMap, HashMap<String, List<String>> iNodeIDsToSNodeIdsMap, HashMap<String, SNode> sNodeIdToSNodeMap) {
        String dominatedINodeId = dominatedINode.getId();
        if (iNodeIdToSStructureMap.containsKey(dominatedINodeId)) {
            SStructure dominatedSStructure = iNodeIdToSStructureMap.get(dominatedINodeId);
            docGraph.addNode((SNode)sourceSStructure, (SNode)dominatedSStructure, domRel);
        } else {
            List<String> dominatedSElementIds = iNodeIDsToSNodeIdsMap.get(dominatedINodeId);
            for (String dominatedSElementId : dominatedSElementIds) {
                if (sNodeIdToSNodeMap.containsKey(dominatedSElementId)) {
                    SNode dominatedSNode = sNodeIdToSNodeMap.get(dominatedSElementId);
                    docGraph.addNode((SNode)sourceSStructure, dominatedSNode, domRel);
                    continue;
                }
                throw new PepperModuleException(" Can't find element '" + dominatedSElementId + "' in token map or span map!1!!");
            }
        }
    }

    public static void addDomRelToFloatingSToken(IGraph syntaxIGraph, SDocumentGraph docGraph, SStructure sourceSStructure, INode connectedSyntaxINode) {
        logger.debug("Connected syntax INode " + connectedSyntaxINode.getId() + " does neither have out edges nor links.");
        throw new UnsupportedOperationException("TODO: METHOD NOT IMPLEMENTED, YET");
    }

    public static void addDomRelToNonFloatingSToken(IGraph syntaxIGraph, SDocumentGraph docGraph, SStructure sourceSStructure, List<ILink> linksToTokenRegions) throws GrafException {
        for (ILink link : linksToTokenRegions) {
            for (IRegion region : link.regions()) {
                List<SToken> dominatedSTokens = GrafReader.getSTokensFromIRegions(syntaxIGraph, region, docGraph);
                for (SToken dominatedSToken : dominatedSTokens) {
                    docGraph.addNode((SNode)sourceSStructure, (SNode)dominatedSToken, domRel);
                }
            }
        }
    }

    public static void addSyntaxToSDocument(IGraph syntaxIGraph, HashMap<String, List<String>> iNodeIdToSNodeIdMap, HashMap<String, SNode> sNodeIdToSNodeMap, SDocument sDocument) throws GrafException {
        SDocumentGraph docGraph = sDocument.getDocumentGraph();
        List sTokens = Collections.synchronizedList(docGraph.getTokens());
        HashMap<String, SStructure> iNodeIdToSStructureMap = SaltWriter.createSyntaxINodeSStructures(syntaxIGraph);
        SStructure rootSStructure = SaltFactory.createSStructure();
        rootSStructure.setName("root");
        docGraph.addNode((Node)rootSStructure);
        SaltWriter.addSyntaxTreeRootDomRelsToDocGraph(syntaxIGraph, docGraph, iNodeIdToSStructureMap, rootSStructure);
        SaltWriter.addSyntaxNodeDomRelsToDocGraph(syntaxIGraph, docGraph, iNodeIdToSStructureMap, iNodeIdToSNodeIdMap, sNodeIdToSNodeMap);
    }

    public static enum IRegionHandlingMethod {
        WORD_SEGMENTATION_ONLY,
        APPROXIMATE_MATCH,
        ALL_TOKEN_LEVELS;

    }
}

