/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltReader {
    protected static final Logger logger = LoggerFactory.getLogger((String)"GrAFImporter");

    public static SaltProject loadSaltProject(String saltProjectPath) {
        logger.trace("load salt project from path: " + saltProjectPath);
        SaltProject saltProject = SaltFactory.createSaltProject();
        saltProject.loadSaltProject(URI.createFileURI((String)saltProjectPath));
        logger.trace("OK");
        return saltProject;
    }

    public static String getPrimaryTextSequence(SNode sNode, SDocumentGraph sDocumentGraph) {
        List overlappedDSSequences = sDocumentGraph.getOverlappedDataSourceSequence(sNode, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
        if (!overlappedDSSequences.isEmpty()) {
            DataSourceSequence firstSequence = (DataSourceSequence)overlappedDSSequences.get(0);
            String primaryText = firstSequence.getDataSource().getData().toString();
            return primaryText.substring((Integer)firstSequence.getStart(), (Integer)firstSequence.getEnd());
        }
        return null;
    }

    public static String getPrimaryTextSequence(SToken sToken) {
        return SaltReader.getPrimaryTextSequence((SNode)sToken, sToken.getGraph());
    }

    public static String getPrimaryTextSequence(STextualRelation textRel) {
        String primaryText = ((STextualDS)textRel.getTarget()).getText();
        return primaryText.substring((Integer)textRel.getStart(), (Integer)textRel.getEnd());
    }

    public static String getPrimaryTextSequence(SSpan span) {
        return SaltReader.getPrimaryTextSequence((SNode)span, span.getGraph());
    }

    public static int[] getSTokenOffsets(SToken token) {
        SDocumentGraph docGraph = token.getGraph();
        DataSourceSequence sequence = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence((SNode)token, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        return new int[]{(Integer)sequence.getStart(), (Integer)sequence.getEnd()};
    }

    public static Pair<Integer, Integer> getSTextualRelationOffsets(STextualRelation textRel) {
        Pair textRelOffsets = Pair.of((Object)textRel.getStart(), (Object)textRel.getEnd());
        return textRelOffsets;
    }

    public static Pair<Integer, Integer> getSSpanOffset(SSpan span) {
        SDocumentGraph docGraph = span.getGraph();
        DataSourceSequence sequence = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence((SNode)span, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
        return Pair.of((Object)sequence.getStart(), (Object)sequence.getEnd());
    }

    public static List<SToken> getSTokensFromSSpan(SSpan span, SDocumentGraph docGraph) {
        List spanningRelations = docGraph.getSpanningRelations();
        ArrayList<SToken> spanTokens = new ArrayList<SToken>();
        for (SSpanningRelation spanningRel : spanningRelations) {
            if (spanningRel.getSource() != span) continue;
            SToken token = (SToken)spanningRel.getTarget();
            spanTokens.add(token);
        }
        return spanTokens;
    }
}

