/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.corpus_tools.peppermodules.graf.SaltReader;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;

public class SaltGraphInfo {
    public static void printLabelInfo(Label label) {
        System.out.println("label name: " + label.getName() + " qualified name: " + label.getQName());
        System.out.println("label namespace: " + label.getNamespace());
        System.out.println("label value: " + label.getValue());
    }

    public static void printLayerInfo(Layer layer) {
        System.out.println("layer id: " + layer.getId());
        System.out.println("\tnodes: " + layer.getNodes().size() + " edges: " + layer.getRelations().size() + " labels: " + layer.getLabels().size());
    }

    public static void printNodeInfo(Node node) {
        System.out.println("node id: " + node.getId());
        Collection nodeLabels = node.getLabels();
        System.out.println("\tnode has " + nodeLabels.size() + " labels");
        for (Label label : nodeLabels) {
            SaltGraphInfo.printLabelInfo(label);
        }
        Set nodeLayers = node.getLayers();
        System.out.println("\tnode has " + nodeLayers.size() + " layers");
        for (Layer layer : nodeLayers) {
            SaltGraphInfo.printLayerInfo(layer);
        }
    }

    public static void printSaltProjectInfo(SaltProject saltProject) {
        SCorpusGraph sCorpusGraph = (SCorpusGraph)saltProject.getCorpusGraphs().get(0);
        System.out.println("all corpora: " + sCorpusGraph.getCorpora());
        System.out.println("all documents: " + sCorpusGraph.getDocuments());
        for (SDocument sDocument : sCorpusGraph.getDocuments()) {
            SDocumentGraph sDocumentGraph = sDocument.getDocumentGraph();
            System.out.println("============ " + sDocument.getName() + " ============");
            System.out.println("root nodes\t: " + sDocumentGraph.getRoots());
            for (SToken sToken : sDocumentGraph.getTokens()) {
                System.out.println(SaltReader.getPrimaryTextSequence((SNode)sToken, sDocumentGraph));
            }
            System.out.println("----------------------------------------");
            for (SSpan sSpan : sDocumentGraph.getSpans()) {
                System.out.println(SaltReader.getPrimaryTextSequence((SNode)sSpan, sDocumentGraph));
            }
            System.out.println("----------------------------------------");
            for (SStructure sStruct : sDocumentGraph.getStructures()) {
                System.out.println(SaltReader.getPrimaryTextSequence((SNode)sStruct, sDocumentGraph));
            }
            System.out.println("================================================");
        }
    }

    public static void printSAnnotationInfo(SAnnotation sAnnotation) {
        System.out.println("sAnnotation name: " + sAnnotation.getName() + "qualified name: " + sAnnotation.getQName());
        System.out.println("SAnnotation namespace: " + sAnnotation.getNamespace());
        System.out.println("SAnnotation value: " + sAnnotation.getValue_STEXT());
        Collection sAnnotationLabels = sAnnotation.getLabels();
        for (Label label : sAnnotationLabels) {
            SaltGraphInfo.printLabelInfo(label);
        }
    }

    public static void printSCorpusGraphInfo(SCorpusGraph sCorpusGraph) {
        System.out.println("corpus graph id: " + sCorpusGraph.getId());
        System.out.println("corpus graph name : " + sCorpusGraph.getName());
        List sDocuments = sCorpusGraph.getDocuments();
        System.out.println("corpus contains " + sDocuments.size() + " documents:");
        for (SDocument doc : sDocuments) {
            SaltGraphInfo.printSDocumentInfo(doc);
        }
    }

    public static void printSDocumentGraphInfo(SDocumentGraph docGraph) {
        System.out.println("\tdoc graph name: " + docGraph.getName() + " id: " + docGraph.getId() + " sid: " + docGraph.getId());
        System.out.println("\t\troots: " + docGraph.getRoots().size() + " sroots: " + docGraph.getRoots().size());
        System.out.println("\t\tedges: " + docGraph.getRelations().size() + " nodes : " + docGraph.getNodes().size() + " snodes: " + docGraph.getNodes().size() + " sfeatures: " + docGraph.getFeatures().size());
        System.out.println("\t\tlayers: " + docGraph.getLayers().size() + " slayers: " + docGraph.getLayers().size() + " sannotations: " + docGraph.getAnnotations().size() + " stokens: " + docGraph.getTokens().size());
        System.out.println("\t\tsrelations: " + docGraph.getRelations().size() + " sdomrels: " + docGraph.getDominanceRelations().size() + " sorderrels: " + docGraph.getOrderRelations().size() + " sspanningrels: " + docGraph.getSpanningRelations().size() + " spointingrels: " + docGraph.getPointingRelations().size() + " stextualres: " + docGraph.getTextualRelations().size());
    }

    public static void printSDocumentInfo(SDocument doc) {
        System.out.println("\tdocument name: " + doc.getName() + " id: " + doc.getId());
    }

    public static void printSFeatureInfo(SFeature sFeature) {
        System.out.println("\nsFeature name: " + sFeature.getName() + " qualified name: " + sFeature.getQName());
        System.out.println("sFeature namespace: " + sFeature.getNamespace());
        System.out.println("sFeature value: " + sFeature.getValue_STEXT());
        Collection labels = sFeature.getLabels();
        System.out.println("sFeature has " + labels.size() + " labels.");
    }

    public static void printSLayerInfo(SLayer sLayer) {
        System.out.println("\t\tname: " + sLayer.getName() + " id: " + sLayer.getId());
        System.out.println("\t\t\tnodes: " + sLayer.getNodes().size() + " edges: " + sLayer.getRelations().size() + " features: " + sLayer.getFeatures().size() + " relations: " + sLayer.getRelations().size());
    }

    public static void printSNodeInfo(SNode sNode, SDocumentGraph sDocumentGraph) {
        System.out.println();
        System.out.println("\tnode name: " + sNode.getName() + " node id: " + sNode.getId());
        System.out.println("\t\tlabels: " + sNode.getLabels().size() + " annotations: " + sNode.getAnnotations().size() + " features: " + sNode.getFeatures().size() + " layers: " + sNode.getLayers().size());
    }

    public static void printSRelationInfo(SRelation relation) {
        System.out.println("\trelation sname: " + relation.getName() + " sid: " + relation.getId());
        System.out.println("\t\tssource id: " + relation.getSource().getId() + " starget id: " + relation.getTarget().getId());
    }

    public static void printSSpanInfo(SSpan span) {
        Set annotations = span.getAnnotations();
        System.out.println("\tspan sname: " + span.getName() + " sid: " + span.getId());
        System.out.println("\t\tlabels: " + span.getLabels().size() + " sannotations: " + annotations.size() + " sfeatures: " + span.getFeatures().size() + " slayers: " + span.getLayers().size());
        if (annotations.size() > 0) {
            for (SAnnotation anno : annotations) {
                System.out.println("\n\n+++ANNOTATION INFO:");
                SaltGraphInfo.printSAnnotationInfo(anno);
                System.out.println();
            }
        }
    }

    public static void printSTextualRelationInfo(STextualRelation textRel) {
        System.out.println("\ttextual relation name: " + textRel.getName() + " id: " + textRel.getId());
        System.out.println("\t\tstring onset: " + textRel.getStart() + " offset: " + textRel.getEnd());
        System.out.println("\t\tprimary text: " + SaltReader.getPrimaryTextSequence(textRel));
        System.out.println("\t\ttoken name: " + ((SToken)textRel.getSource()).getName() + " id: " + ((SToken)textRel.getSource()).getId());
    }

    public static void printSTokenInfo(SToken token) {
        System.out.println("\t\ttoken name: " + token.getName() + "token id: " + token.getId());
        System.out.println("\t\tannotations: " + token.getAnnotations().size() + " labels: " + token.getLabels().size() + " features: " + token.getFeatures().size() + " layers: " + token.getLayers().size());
        System.out.println("\t\tprimary text: " + SaltReader.getPrimaryTextSequence((SNode)token, token.getGraph()));
    }
}

