/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xces.graf.api.GrafException;
import org.xces.graf.io.dom.FileType;
import org.xces.graf.io.dom.ResourceHeader;

public class GrafResourceHeader
extends ResourceHeader {
    public GrafResourceHeader(File file) throws FileNotFoundException {
        super(file);
    }

    public GrafResourceHeader(InputStream input) {
        super(input);
    }

    public GrafResourceHeader(String corpusPath) throws FileNotFoundException {
        super(GrafResourceHeader.loadHeaderFile(corpusPath));
    }

    public GrafResourceHeader(String corpusPath, String headerFileName) throws FileNotFoundException {
        super(GrafResourceHeader.loadHeaderFile(corpusPath, headerFileName));
    }

    private static File loadHeaderFile(String corpusPath, String headerFileName) {
        return new File(corpusPath, headerFileName);
    }

    private static File loadHeaderFile(String corpusPath) {
        return new File(corpusPath, "resource-header.xml");
    }

    public void printResourceHeaderInfo() throws GrafException {
        System.out.println("The corpus / resource header uses these types of annotations: ");
        List fileTypes = this.getFileTypes();
        for (FileType fileType : fileTypes) {
            System.out.println("AnnotationId: " + fileType.getAnnotationId());
            System.out.println("FileId: " + fileType.getFileId());
            System.out.println("Medium: " + fileType.getMedium());
            System.out.println("Suffix: " + fileType.getSuffix());
            System.out.println();
        }
    }

    public List<String> getCorpusAnnotationTypes() throws GrafException {
        List fileTypes = this.getFileTypes();
        ArrayList<String> annoTypes = new ArrayList<String>();
        for (FileType fileType : fileTypes) {
            annoTypes.add(fileType.getFileId());
        }
        return annoTypes;
    }
}

