/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.graf.DepthFirstSearch;
import org.corpus_tools.peppermodules.graf.GrafDocumentHeader;
import org.corpus_tools.peppermodules.graf.GrafElementSortByID;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IAnchor;
import org.xces.graf.api.IEdge;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.ILink;
import org.xces.graf.api.INode;
import org.xces.graf.api.IRegion;
import org.xces.graf.io.GrafLoader;
import org.xces.graf.io.dom.DocumentHeader;
import org.xces.graf.io.dom.ResourceHeader;
import org.xces.graf.util.GraphUtils;
import org.xml.sax.SAXException;

public class GrafReader {
    protected static final Logger logger = LoggerFactory.getLogger((String)"GrAFImporter");

    public static IGraph getAnnoGraph(ResourceHeader rscHeader, String docHeaderPath) throws GrafException, SAXException, IOException {
        GrafLoader loader = new GrafLoader(rscHeader);
        return loader.load(new File(docHeaderPath));
    }

    public static IGraph getAnnoGraph(ResourceHeader rscHeader, String docHeaderPath, List<String> annoTypes) throws GrafException, SAXException, IOException {
        GrafDocumentHeader mascDocHeader = new GrafDocumentHeader(docHeaderPath);
        List existingAnnotations = mascDocHeader.getAnnotationTypes();
        if (existingAnnotations.containsAll(annoTypes)) {
            GrafLoader loader = new GrafLoader(rscHeader);
            loader.setTypes(annoTypes);
            return loader.load(new File(docHeaderPath));
        }
        throw new NullPointerException("The document was not annotated with the chosen annotation type(s).");
    }

    public static IGraph getAnnoGraph(ResourceHeader rscHeader, String docHeaderPath, String annoType) throws GrafException, SAXException, IOException {
        GrafDocumentHeader mascDocHeader = new GrafDocumentHeader(docHeaderPath);
        List existingAnnotations = mascDocHeader.getAnnotationTypes();
        if (existingAnnotations.contains(annoType)) {
            return GrafReader.getAnnoGraph(rscHeader, docHeaderPath, Arrays.asList(annoType));
        }
        throw new NullPointerException("The document was not annotated with the chosen annotation type.");
    }

    public static List<String> getAnnoSpaceNamesFromRegion(IRegion region) {
        ArrayList<String> annoSpaceNames = new ArrayList<String>();
        for (INode annoNodes : region.getNodes()) {
            String annoSpaceName = annoNodes.getAnnotation().getAnnotationSpace().getName();
            annoSpaceNames.add(annoSpaceName);
        }
        return annoSpaceNames;
    }

    public static List<String> getDocumentIds(List<String> docHeaderPaths) throws FileNotFoundException, XPathExpressionException {
        ArrayList<String> docIds = new ArrayList<String>();
        for (String docHeaderPath : docHeaderPaths) {
            GrafDocumentHeader header = new GrafDocumentHeader(docHeaderPath);
            String docId = header.getDocumentId();
            docIds.add(docId);
        }
        return docIds;
    }

    public static String getDocumentText(IGraph graph) {
        return graph.getContent().toString();
    }

    public static int getDocumentsWithAnnoTypeCount(List<String> docHeaderPaths, String annoType) throws FileNotFoundException, GrafException {
        int fileCount = 0;
        for (String docHeaderPath : docHeaderPaths) {
            File docHeaderFile = new File(docHeaderPath);
            DocumentHeader header = new DocumentHeader(docHeaderFile);
            List annoTypes = header.getAnnotationTypes();
            if (!annoTypes.contains(annoType)) continue;
            ++fileCount;
        }
        return fileCount;
    }

    public static List<INode> getNodesOfAnnoSpace(IGraph iGraph, String annoSpaceName) throws GrafException {
        ArrayList<INode> filteredNodes = new ArrayList<INode>();
        for (INode node : iGraph.getNodes()) {
            if (!annoSpaceName.equals(node.getAnnotation().getAnnotationSpace().getName())) continue;
            filteredNodes.add(node);
        }
        return filteredNodes;
    }

    private static List<INode> getInboundConnectedNodes(INode node) {
        List inEdges = node.getInEdges();
        ArrayList<INode> connectedNodes = new ArrayList<INode>();
        for (IEdge inEdge : inEdges) {
            connectedNodes.add(inEdge.getFrom());
        }
        return connectedNodes;
    }

    public static List<INode> getOutboundConnectedNodes(INode node) {
        List outEdges = node.getOutEdges();
        Collections.sort(outEdges, new GrafElementSortByID());
        ArrayList<INode> connectedNodes = new ArrayList<INode>();
        for (IEdge outEdge : outEdges) {
            connectedNodes.add(outEdge.getTo());
        }
        return connectedNodes;
    }

    public static String getPrimaryTextSequence(int start, int end, IGraph iGraph) {
        String primaryText = GrafReader.getDocumentText(iGraph);
        return primaryText.substring(start, end);
    }

    public static String getPrimaryTextSequence(IRegion iRegion, IGraph iGraph) throws GrafException {
        String primaryText = GrafReader.getDocumentText(iGraph);
        int[] regionOffsets = GrafReader.getRegionOffsets(iRegion);
        return primaryText.substring(regionOffsets[0], regionOffsets[1]);
    }

    public static String getPrimaryTextSequence(ILink iLink, IGraph iGraph) throws GrafException {
        int[] linkOffsets = GrafReader.getLinkOffsets(iLink);
        return GrafReader.getPrimaryTextSequence(linkOffsets[0], linkOffsets[1], iGraph);
    }

    public static String getPrimaryTextSequence(INode iNode, IGraph iGraph) throws GrafException {
        int[] nodeOffsets = GrafReader.getNodeOffsets(iNode);
        return GrafReader.getPrimaryTextSequence(nodeOffsets[0], nodeOffsets[1], iGraph);
    }

    public static List<IRegion> getRegionsOfAnnoSpace(IGraph iGraph, String annoSpace) throws GrafException {
        return GrafReader.getRegionsOfAnnoSpaces(iGraph, Arrays.asList(annoSpace));
    }

    public static List<IRegion> getRegionsOfAnnoSpaces(IGraph iGraph, List<String> annoSpaces) throws GrafException {
        ArrayList<IRegion> filteredRegions = new ArrayList<IRegion>();
        for (IRegion region : iGraph.getRegions()) {
            List nodes = region.getNodes();
            for (INode node : nodes) {
                String nodeAnnoSpace = node.getAnnotation().getAnnotationSpace().getName();
                if (!annoSpaces.contains(nodeAnnoSpace)) continue;
                filteredRegions.add(region);
            }
        }
        return filteredRegions;
    }

    public static int[] getRegionOffsets(IRegion region) throws GrafException {
        int regionStart = GraphUtils.getOffset((IAnchor)region.getStart());
        int regionEnd = GraphUtils.getOffset((IAnchor)region.getEnd());
        return new int[]{regionStart, regionEnd};
    }

    public static int[] getLinkOffsets(ILink link) throws GrafException {
        List iRegions = link.getRegions();
        if (iRegions.size() == 1) {
            IRegion iRegion = (IRegion)iRegions.get(0);
            return GrafReader.getRegionOffsets(iRegion);
        }
        int lowestStartOffset = Integer.MAX_VALUE;
        int highestEndOffset = Integer.MIN_VALUE;
        List regions = link.getRegions();
        for (IRegion region : regions) {
            int[] regionOffsets = GrafReader.getRegionOffsets(region);
            int startOffset = regionOffsets[0];
            int endOffset = regionOffsets[1];
            if (startOffset < lowestStartOffset) {
                lowestStartOffset = startOffset;
            }
            if (endOffset <= highestEndOffset) continue;
            highestEndOffset = endOffset;
        }
        return new int[]{lowestStartOffset, highestEndOffset};
    }

    public static int[] getNodeOffsets(INode node) throws GrafException {
        List nodeLinks = node.getLinks();
        if (!nodeLinks.isEmpty()) {
            ILink iLink = (ILink)nodeLinks.get(0);
            return GrafReader.getLinkOffsets(iLink);
        }
        List outEdges = node.getOutEdges();
        if (outEdges.isEmpty()) {
            throw new PepperModuleException("INode " + node.getId() + " is floating. It doesn't cover any primary text.");
        }
        int lowestStartOffset = Integer.MAX_VALUE;
        int highestEndOffset = Integer.MIN_VALUE;
        for (IEdge outEdge : outEdges) {
            INode targetNode = outEdge.getTo();
            int[] targetNodeOffsets = GrafReader.getNodeOffsets(targetNode);
            int startOffset = targetNodeOffsets[0];
            int endOffset = targetNodeOffsets[1];
            if (startOffset < lowestStartOffset) {
                lowestStartOffset = startOffset;
            }
            if (endOffset <= highestEndOffset) continue;
            highestEndOffset = endOffset;
        }
        return new int[]{lowestStartOffset, highestEndOffset};
    }

    public static int[] getFloatingNodeOffsets(IGraph graph, INode floatingNode) throws GrafException {
        DepthFirstSearch floatSearch = new DepthFirstSearch(graph, floatingNode);
        INode succeedingLeafNode = floatSearch.getSucceedingLeafNode(graph, floatingNode);
        INode precedingLeafNode = floatSearch.getPrecedingLeafNode(graph, floatingNode);
        if (succeedingLeafNode != null) {
            int[] successorOffsets = GrafReader.getNodeOffsets(succeedingLeafNode);
            return new int[]{successorOffsets[0], successorOffsets[0]};
        }
        if (precedingLeafNode != null) {
            int[] predecessorOffsets = GrafReader.getNodeOffsets(precedingLeafNode);
            return new int[]{predecessorOffsets[1], predecessorOffsets[1]};
        }
        throw new PepperModuleException("Can't produce fake offsets for floating node " + floatingNode.getId());
    }

    public static List<INode> getRootNodes(IGraph iGraph) {
        Collection iNodes = iGraph.getNodes();
        ArrayList<INode> rootNodes = new ArrayList<INode>();
        for (INode iNode : iNodes) {
            for (IEdge inEdge : iNode.getInEdges()) {
                INode motherNode = inEdge.getFrom();
                if (!motherNode.getInEdges().isEmpty() || iNode.getOutEdges().isEmpty()) continue;
                rootNodes.add(iNode);
            }
        }
        return rootNodes;
    }

    public static List<SToken> getSTokensFromIRegions(IGraph iGraph, IRegion region, SDocumentGraph docGraph) throws GrafException {
        STextualDS sTextualDS = (STextualDS)docGraph.getTextualDSs().get(0);
        DataSourceSequence sDataSourceSequence = new DataSourceSequence();
        int[] regionOffsets = GrafReader.getRegionOffsets(region);
        sDataSourceSequence.setStart((Number)regionOffsets[0]);
        sDataSourceSequence.setEnd((Number)regionOffsets[1]);
        sDataSourceSequence.setDataSource((SSequentialDS)sTextualDS);
        return docGraph.getTokensBySequence(sDataSourceSequence);
    }

    public static List<SToken> getSTokensFromOffsets(IGraph iGraph, int onset, int offset, SDocumentGraph docGraph) throws GrafException {
        STextualDS sTextualDS = (STextualDS)docGraph.getTextualDSs().get(0);
        DataSourceSequence sDataSourceSequence = new DataSourceSequence();
        sDataSourceSequence.setStart((Number)onset);
        sDataSourceSequence.setEnd((Number)offset);
        sDataSourceSequence.setDataSource((SSequentialDS)sTextualDS);
        return docGraph.getTokensBySequence(sDataSourceSequence);
    }

    public static boolean isLeafNode(INode iNode) {
        return iNode.getOutEdges().isEmpty() && !iNode.getLinks().isEmpty();
    }

    public static boolean isFloatingNode(INode iNode) {
        return iNode.getOutEdges().isEmpty() && iNode.getLinks().isEmpty();
    }

    public static INode getRootNodeFromNode(INode leafNode, IGraph iGraph) {
        List<INode> rootNodes = GrafReader.getRootNodes(iGraph);
        ArrayList<String> rootNodeCandidateIds = new ArrayList<String>();
        for (INode rootNodeCandidate : rootNodes) {
            String candidateId = rootNodeCandidate.getId();
            rootNodeCandidateIds.add(candidateId);
        }
        if (leafNode.getInEdges().isEmpty()) {
            logger.debug("IGraph has a weird floating root node: " + leafNode.getId());
            return leafNode;
        }
        INode firstParentNode = leafNode.getInEdge(0).getFrom();
        if (rootNodeCandidateIds.contains(firstParentNode.getId())) {
            return firstParentNode;
        }
        return GrafReader.getRootNodeFromNode(firstParentNode, iGraph);
    }

    public static List<String> getTokenNodesCoveredByRootNode(INode rootNode) {
        List<INode> connectedNodes = GrafReader.getOutboundConnectedNodes(rootNode);
        ArrayList<String> tokenNodeIds = new ArrayList<String>();
        for (INode connectedNode : connectedNodes) {
            if (connectedNode.getLinks().size() > 0) {
                tokenNodeIds.add(connectedNode.getId());
                continue;
            }
            List<String> recursivelyConnectedTokenNodes = GrafReader.getTokenNodesCoveredByRootNode(connectedNode);
            tokenNodeIds.addAll(recursivelyConnectedTokenNodes);
        }
        return tokenNodeIds;
    }

    public static List<INode> findOutboundConnectedFloatingNodes(INode dominatingNode) {
        List<INode> outboundConnectedNodes = GrafReader.getOutboundConnectedNodes(dominatingNode);
        ArrayList<INode> floatingNodes = new ArrayList<INode>();
        for (INode connectedNode : outboundConnectedNodes) {
            if (!GrafReader.isFloatingNode(connectedNode)) continue;
            floatingNodes.add(connectedNode);
        }
        return floatingNodes;
    }
}

