/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IAnnotation;
import org.xces.graf.api.IAnnotationSpace;
import org.xces.graf.api.IEdge;
import org.xces.graf.api.IFeature;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.ILink;
import org.xces.graf.api.INode;
import org.xces.graf.api.IRegion;
import org.xces.graf.api.IStandoffHeader;

public class GrafGraphInfo {
    public static void printAnnotationInfo(IAnnotation anno) {
        IAnnotationSpace annoSpace = anno.getAnnotationSpace();
        System.out.println("    anno space name: " + annoSpace.getName());
        System.out.println("    anno space type: " + annoSpace.getType());
        String annoId = anno.getId();
        String annoLabel = anno.getLabel();
        System.out.println("\tannotation ID: " + annoId);
        System.out.println("\tannotation label: " + annoLabel);
        Iterable features = anno.features();
        for (IFeature feature : features) {
            System.out.println();
            GrafGraphInfo.printFeatureInfo(feature);
        }
    }

    public static void printAnnotationSpacesInfo(IGraph graph) {
        Collection annoSpaces = graph.getAnnotationSpaces();
        int annoSpacesSize = annoSpaces.size();
        System.out.println("graph contains " + annoSpacesSize + " annotation spaces");
        for (IAnnotationSpace annoSpace : annoSpaces) {
            String annoSetName = annoSpace.getName();
            String annoSetType = annoSpace.getType();
            System.out.println("annotation set: " + annoSetName + " (name) " + annoSetType + " (type)");
        }
    }

    public static void printEdgeInfo(IEdge edge) {
        System.out.println("\tedge ID: " + edge.getId());
        System.out.println("\t\tsource node ID: " + edge.getFrom().getId());
        System.out.println("\t\tdestination node ID: " + edge.getTo().getId());
        if (edge.annotated()) {
            for (IAnnotation anno : edge.annotations()) {
                GrafGraphInfo.printAnnotationInfo(anno);
            }
        } else {
            System.out.println("    edge is not annotated.");
        }
    }

    public static void printFeatureInfo(IFeature feature) {
        System.out.println("\t    feature name: " + feature.getName());
        System.out.println("\t    feature value: " + feature.getStringValue());
    }

    public static void printGraphInfo(IGraph graph) throws GrafException {
        System.out.println("edge size: " + graph.getEdgeSetSize());
        System.out.println("node size: " + graph.getNodeSetSize());
        for (INode node : graph.getNodes()) {
            GrafGraphInfo.printNodeInfo(node, graph);
        }
        Collection regions = graph.getRegions();
        System.out.println("regions: " + regions.size());
        GrafGraphInfo.printRootInfo(graph);
        System.out.println("\n\n");
    }

    public static void printLinkInfo(ILink iLink, IGraph iGraph) throws GrafException {
        List regions = iLink.getRegions();
        int regionsCount = iLink.getRegions().size();
        System.out.print("\tlink targets " + regionsCount + " region(s):");
        for (IRegion region : regions) {
            System.out.print(" " + region.getId());
        }
        System.out.println();
        System.out.println("\t\tprimary text: " + GrafReader.getPrimaryTextSequence(iLink, iGraph));
    }

    public static void printNodeInfo(INode iNode, IGraph iGraph) throws GrafException {
        System.out.println("node ID: " + iNode.getId() + " has degree: " + iNode.degree());
        System.out.println();
        List inEdges = iNode.getInEdges();
        System.out.print("    ingoing edges: ");
        for (Object edge : inEdges) {
            System.out.print(edge.getId() + " ");
        }
        System.out.println();
        List outEdges = iNode.getOutEdges();
        System.out.print("    outgoing edges: ");
        for (Object edge : outEdges) {
            System.out.print(edge.getId() + " ");
        }
        System.out.println();
        IAnnotationSpace defaultAnnotation = iNode.getAnnotation().getAnnotationSpace();
        System.out.println("\tannotation space name: " + defaultAnnotation.getName());
        System.out.println("\tannotation space type: " + defaultAnnotation.getType());
        for (IAnnotation anno : iNode.annotations()) {
            GrafGraphInfo.printAnnotationInfo(anno);
        }
        System.out.println();
        List links = iNode.getLinks();
        for (ILink link : links) {
            GrafGraphInfo.printLinkInfo(link, iGraph);
        }
    }

    public static void printNodesStatistics(IGraph iGraph) {
        HashMap<String, Integer> annoSpaceNodeCountMap = GrafGraphInfo.getNodeCountPerAnnoSpace(iGraph);
        System.out.println("node annotation spaces:");
        for (String annoSpace : annoSpaceNodeCountMap.keySet()) {
            System.out.println("\t" + annoSpace + " : " + annoSpaceNodeCountMap.get(annoSpace) + " nodes");
        }
    }

    public static HashMap<String, Integer> getNodeCountPerAnnoSpace(IGraph iGraph) {
        Collection nodes = iGraph.getNodes();
        HashMap<String, Integer> annoSpaceNodeCountMap = new HashMap<String, Integer>();
        for (INode node : nodes) {
            String annoSpaceName = node.getAnnotation().getAnnotationSpace().getName();
            if (annoSpaceNodeCountMap.containsKey(annoSpaceName)) {
                Integer nodeCount = annoSpaceNodeCountMap.get(annoSpaceName);
                annoSpaceNodeCountMap.put(annoSpaceName, nodeCount + 1);
                continue;
            }
            annoSpaceNodeCountMap.put(annoSpaceName, 1);
        }
        return annoSpaceNodeCountMap;
    }

    public static void printNodesOfAnnoSpace(IGraph iGraph, String annoSpace) throws GrafException {
        for (INode node : iGraph.getNodes()) {
            String nodeAnnoSpace = node.getAnnotation().getAnnotationSpace().getName();
            if (!annoSpace.equals(nodeAnnoSpace)) continue;
            String primaryTextSequence = GrafReader.getPrimaryTextSequence(node, iGraph);
            System.out.println("node " + node.getId() + ": " + primaryTextSequence);
        }
    }

    public static void printRegionInfo(IRegion region, IGraph iGraph) throws GrafException {
        int[] regionOffsets = GrafReader.getRegionOffsets(region);
        System.out.println("\tregion id: " + region.getId() + " start: " + regionOffsets[0] + " end: " + regionOffsets[1]);
        System.out.println("    primary text sequence: " + GrafReader.getPrimaryTextSequence(regionOffsets[0], regionOffsets[1], iGraph));
    }

    public static void printRegionsStatistics(IGraph iGraph) {
        HashMap<String, Integer> annoSpaceRegionCountMap = GrafGraphInfo.getRegionCountPerAnnoSpace(iGraph);
        System.out.println("region annotation spaces (working directly on the primary text):");
        for (String annoSpace : annoSpaceRegionCountMap.keySet()) {
            System.out.println("\t" + annoSpace + " : " + annoSpaceRegionCountMap.get(annoSpace) + " regions");
        }
    }

    public static HashMap<String, Integer> getRegionCountPerAnnoSpace(IGraph iGraph) {
        Collection regions = iGraph.getRegions();
        HashMap<String, Integer> annoSpaceRegionCountMap = new HashMap<String, Integer>();
        for (IRegion region : regions) {
            List<String> annoSpaceNames = GrafReader.getAnnoSpaceNamesFromRegion(region);
            for (String annoSpaceName : annoSpaceNames) {
                if (annoSpaceRegionCountMap.containsKey(annoSpaceName)) {
                    Integer regionCount = annoSpaceRegionCountMap.get(annoSpaceName);
                    annoSpaceRegionCountMap.put(annoSpaceName, regionCount + 1);
                    continue;
                }
                annoSpaceRegionCountMap.put(annoSpaceName, 1);
            }
        }
        return annoSpaceRegionCountMap;
    }

    public static void printRegionsOfAnnoSpace(IGraph iGraph, String annoSpace) throws GrafException {
        for (IRegion region : iGraph.getRegions()) {
            List<String> regionAnnoSpaces = GrafReader.getAnnoSpaceNamesFromRegion(region);
            if (!regionAnnoSpaces.contains(annoSpace)) continue;
            String primaryTextSequence = GrafReader.getPrimaryTextSequence(region, iGraph);
            System.out.println("region " + region.getId() + ": " + primaryTextSequence);
        }
    }

    public static void printRootInfo(IGraph graph) {
        INode root = graph.getRoot();
        if (root == null) {
            System.out.println("This graph has no root.");
        } else {
            System.out.println("root id: " + root.getId());
        }
    }

    public static void printStandoffHeaderInfo(IGraph graph) {
        IStandoffHeader header = graph.getHeader();
        List dependencies = header.getDependsOn();
        if (dependencies.isEmpty()) {
            System.out.println("0 dependencies.");
        } else {
            System.out.print(dependencies.size() + " dependencies: ");
            for (String dependency : dependencies) {
                System.out.print(dependency);
            }
            System.out.println();
        }
        List annoSpaces = header.getAnnotationSpaces();
        if (annoSpaces.isEmpty()) {
            System.out.println("0 annotation spaces.");
        } else {
            GrafGraphInfo.printAnnotationSpacesInfo(graph);
        }
        List headerRoots = header.getRoots();
        if (headerRoots.isEmpty()) {
            System.out.println("This graph is not a forest.");
        } else {
            System.out.println("This graph has " + headerRoots.size() + " roots: ");
            for (String root : headerRoots) {
                System.out.print(root + " ");
            }
        }
        System.out.println("The IGraph uses the following labels:");
        for (String label : header.getLabels()) {
            System.out.println("\t" + label);
        }
    }

    public static void printSyntaxTreeRoots(IGraph syntaxIGraph) {
        List<INode> syntacticTreeRoots = GrafReader.getRootNodes(syntaxIGraph);
        System.out.println("The IGraph has these syntactic sentence roots: ");
        for (INode syntaxTreeRoot : syntacticTreeRoots) {
            System.out.println("\t" + syntaxTreeRoot.getId() + " " + syntaxTreeRoot.getAnnotation().getLabel());
        }
    }
}

