/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.xces.graf.api.GrafException;
import org.xces.graf.io.dom.DocumentHeader;

public class GrafDocumentHeader
extends DocumentHeader {
    public GrafDocumentHeader(File headerFile) throws FileNotFoundException {
        super(headerFile);
    }

    public GrafDocumentHeader(InputStream input) {
        super(input);
    }

    public GrafDocumentHeader(String pathToHeaderFile) throws FileNotFoundException {
        super(GrafDocumentHeader.loadHeaderFile(pathToHeaderFile));
    }

    private static File loadHeaderFile(String pathToHeaderFile) {
        return new File(pathToHeaderFile);
    }

    public void printDocumentHeaderInfo() throws GrafException, XPathExpressionException {
        System.out.println("document id: " + this.getDocumentId());
        System.out.println("document title: " + this.getDocumentTitle());
        System.out.println("The document has " + this.getDocumentAnnotationTypeCount() + " types of annotations:");
        for (String annoType : this.getAnnotationTypes()) {
            System.out.println("\t" + annoType);
        }
        System.out.println();
    }

    public List<String> getDocumentAnnotationTypes() throws GrafException {
        return this.getAnnotationTypes();
    }

    public int getDocumentAnnotationTypeCount() throws GrafException {
        List annoTypes = this.getAnnotationTypes();
        return annoTypes.size();
    }

    public String getDocumentTitle() throws XPathExpressionException {
        Node srcDescNode = this.getNode("/g:documentHeader/g:fileDesc/g:sourceDesc/g:title");
        return srcDescNode.getTextContent();
    }

    public String getDocumentId() throws XPathExpressionException {
        Node docHeaderNode = this.getNode("/g:documentHeader");
        return this.getAttributeValue(docHeaderNode, "docId");
    }
}

