/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.graf.GrAFImporterProperties;
import org.corpus_tools.peppermodules.graf.GrafDocumentHeader;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.corpus_tools.peppermodules.graf.GrafResourceHeader;
import org.corpus_tools.peppermodules.graf.SaltWriter;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.xces.graf.api.GrafException;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.ILink;
import org.xces.graf.api.INode;
import org.xces.graf.api.IRegion;
import org.xces.graf.impl.DefaultImplementation;

@Component(name="GrAFImporterComponent", factory="PepperImporterComponentFactory")
public class GrAFImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "GrAFImporter";
    Map<String, String> docIdDocHeaderMap = null;
    private GrafResourceHeader rscHeader = null;

    public GrAFImporter() {
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-GrAFModules"));
        this.setDesc("This importer transforms data in the GrAF format to a Salt model. ");
        this.addSupportedFormat("GrAF", "1.0", null);
        this.setProperties(new GrAFImporterProperties());
    }

    public List<String> getTokenizedPOSTaggedDocHeaders(List<String> documentHeaderPaths) throws FileNotFoundException, GrafException {
        ArrayList<String> desiredDocHeadersPaths = new ArrayList<String>();
        for (String docHeaderPath : documentHeaderPaths) {
            GrafDocumentHeader docHeader = new GrafDocumentHeader(docHeaderPath);
            List annoTypes = docHeader.getAnnotationTypes();
            if (!annoTypes.contains(((GrAFImporterProperties)this.getProperties()).getTokenizationLayer()) && !annoTypes.contains(((GrAFImporterProperties)this.getProperties()).getPOSLayer())) continue;
            desiredDocHeadersPaths.add(docHeaderPath);
        }
        return desiredDocHeadersPaths;
    }

    public static HashMap<String, String> createDocIdDocHeaderMap(List<String> documentHeaderPaths) throws FileNotFoundException, XPathExpressionException {
        HashMap<String, String> docIdDocHeader = new HashMap<String, String>();
        for (String headerPath : documentHeaderPaths) {
            GrafDocumentHeader mascDocHeader = new GrafDocumentHeader(headerPath);
            String docId = mascDocHeader.getDocumentId();
            docIdDocHeader.put(docId, headerPath);
        }
        return docIdDocHeader;
    }

    public static List<String> recursiveListDir(String path, String fileNameEndsWith) {
        List<String> fnamesList = GrAFImporter.recursiveListDir(path);
        ArrayList<String> filteredFnamesList = new ArrayList<String>();
        for (String fname : fnamesList) {
            if (!fname.endsWith(fileNameEndsWith)) continue;
            filteredFnamesList.add(fname);
        }
        return filteredFnamesList;
    }

    public static List<String> recursiveListDir(String path) {
        File[] faFiles;
        ArrayList<String> fnamesList = new ArrayList<String>();
        for (File file : faFiles = new File(path).listFiles()) {
            if (file.isDirectory()) {
                List<String> tmpFnames = GrAFImporter.recursiveListDir(file.getAbsolutePath());
                for (String fname : tmpFnames) {
                    fnamesList.add(fname);
                }
                continue;
            }
            String absPath = file.getAbsolutePath();
            String correctedPath = absPath.replace("\\", "/");
            fnamesList.add(correctedPath);
        }
        return fnamesList;
    }

    public void importCorpusStructure(SCorpusGraph corpusGraph) throws PepperModuleException {
        String corpusPath = this.getCorpusDesc().getCorpusPath().toFileString();
        try {
            List<String> docHeaderPaths = GrAFImporter.recursiveListDir(corpusPath, ((GrAFImporterProperties)this.getProperties()).getHeaderFileEnding());
            List<String> docIds = GrafReader.getDocumentIds(docHeaderPaths);
            this.docIdDocHeaderMap = GrAFImporter.createDocIdDocHeaderMap(docHeaderPaths);
            SCorpus corpus = SaltFactory.createSCorpus();
            corpus.setName("MASC_labels_not_namespaces");
            corpusGraph.addNode((Node)corpus);
            for (String docId : docIds) {
                SDocument sDoc = SaltFactory.createSDocument();
                sDoc.setName(docId);
                corpusGraph.addDocument(corpus, sDoc);
            }
            this.rscHeader = new GrafResourceHeader(corpusPath);
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus at location '" + corpusPath + "'. ", (Throwable)e);
        }
    }

    public static HashMap<String, List<String>> addGrafStructureToSDocument(IGraph iGraph, SDocument sDocument) throws GrafException {
        HashMap<String, List<String>> regionIdToTokenIdsMap = SaltWriter.addAllIRegionsToSDocument(iGraph, sDocument);
        return SaltWriter.addSSpansToSDocument(iGraph, sDocument, regionIdToTokenIdsMap);
    }

    public void start(Identifier Identifier2) throws PepperModuleException {
        if (Identifier2 != null && Identifier2.getIdentifiableElement() != null && (Identifier2.getIdentifiableElement() instanceof SDocument || Identifier2.getIdentifiableElement() instanceof SCorpus) && Identifier2.getIdentifiableElement() instanceof SDocument) {
            try {
                SDocument sDocument = (SDocument)Identifier2.getIdentifiableElement();
                sDocument.setDocumentGraph(SaltFactory.createSDocumentGraph());
                String sDocName = sDocument.getName();
                System.out.println("filling SDocument " + sDocName + " ...");
                String docHeaderPath = this.docIdDocHeaderMap.get(sDocName);
                IGraph iGraph = GrafReader.getAnnoGraph(this.rscHeader, docHeaderPath);
                IGraph fixedIGraph = GrAFImporter.repairFloatingNodes(iGraph);
                String primaryText = GrafReader.getDocumentText(iGraph);
                SaltWriter.addPrimaryTextToDocument(sDocument, primaryText);
                HashMap<String, List<String>> iNodeIdToSNodeIdsMap = GrAFImporter.addGrafStructureToSDocument(fixedIGraph, sDocument);
                HashMap<String, SNode> sNodeIdToSNodeMap = SaltWriter.addAnnotationsToSDocument(fixedIGraph, iNodeIdToSNodeIdsMap, sDocument);
                SaltWriter.addSyntaxToSDocument(fixedIGraph, iNodeIdToSNodeIdsMap, sNodeIdToSNodeMap, sDocument);
            }
            catch (Exception e) {
                throw new PepperModuleException((PepperModule)this, "Cannot import SDocument '" + Identifier2 + "' ", (Throwable)e);
            }
        }
    }

    public static IGraph repairFloatingNodes(IGraph iGraph) throws GrafException {
        DefaultImplementation grafFactory = new DefaultImplementation();
        int floatingNodeCount = 0;
        for (INode iNode : iGraph.getNodes()) {
            if (!GrafReader.isFloatingNode(iNode)) continue;
            int[] floatingNodeOffsets = GrafReader.getFloatingNodeOffsets(iGraph, iNode);
            IRegion emptyRegion = grafFactory.newRegion("seg-fake" + floatingNodeCount, Long.valueOf(floatingNodeOffsets[0]).longValue(), Long.valueOf(floatingNodeOffsets[1]).longValue());
            ILink linkToEmptyRegion = grafFactory.newLink();
            linkToEmptyRegion.addTarget(emptyRegion);
            iNode.addLink(linkToEmptyRegion);
            iGraph.addRegion(emptyRegion);
            ++floatingNodeCount;
        }
        return iGraph;
    }
}

