/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.graf;

import java.util.HashMap;
import org.corpus_tools.peppermodules.graf.GrafReader;
import org.xces.graf.api.IGraph;
import org.xces.graf.api.INode;

public class DepthFirstSearch {
    private boolean[] visited;
    private int nodeIndex;
    public HashMap<String, Integer> nodeIdToOrderedNodeNumberMap;
    public HashMap<Integer, String> OrderedNodeNumberToNodeIdMap;

    public DepthFirstSearch(IGraph graph, INode floatingNode) {
        this.visited = new boolean[graph.getNodeSetSize()];
        this.nodeIdToOrderedNodeNumberMap = new HashMap();
        this.OrderedNodeNumberToNodeIdMap = new HashMap();
        INode rootNode = GrafReader.getRootNodeFromNode(floatingNode, graph);
        this.dfs(graph, rootNode);
    }

    private void dfs(IGraph graph, INode sourceNode) {
        String nodeId = sourceNode.getId();
        if (this.nodeIdToOrderedNodeNumberMap.containsKey(nodeId)) {
            int orderedNodeNumber = this.nodeIdToOrderedNodeNumberMap.get(nodeId);
            this.visited[orderedNodeNumber] = true;
        } else {
            this.nodeIdToOrderedNodeNumberMap.put(nodeId, this.nodeIndex);
            this.OrderedNodeNumberToNodeIdMap.put(this.nodeIndex, nodeId);
            this.visited[this.nodeIndex] = true;
            ++this.nodeIndex;
        }
        for (INode outboundConnectedNode : GrafReader.getOutboundConnectedNodes(sourceNode)) {
            if (this.isVisited(outboundConnectedNode)) continue;
            this.dfs(graph, outboundConnectedNode);
        }
    }

    public boolean isVisited(INode node) {
        String nodeId = node.getId();
        if (this.nodeIdToOrderedNodeNumberMap.containsKey(nodeId)) {
            return this.visited[this.nodeIdToOrderedNodeNumberMap.get(nodeId)];
        }
        return false;
    }

    public INode getPrecedingLeafNode(IGraph graph, INode node) {
        String nodeId = node.getId();
        if (this.nodeIdToOrderedNodeNumberMap.containsKey(nodeId)) {
            int nodeNumber;
            for (int i = nodeNumber = this.nodeIdToOrderedNodeNumberMap.get(nodeId).intValue(); i > 0; --i) {
                String precedingNodeId = this.OrderedNodeNumberToNodeIdMap.get(i - 1);
                INode precedingNode = graph.findNode(precedingNodeId);
                if (!GrafReader.isLeafNode(precedingNode) || GrafReader.isFloatingNode(precedingNode)) continue;
                return precedingNode;
            }
            return null;
        }
        return null;
    }

    public INode getSucceedingLeafNode(IGraph graph, INode node) {
        String nodeId = node.getId();
        if (this.nodeIdToOrderedNodeNumberMap.containsKey(nodeId)) {
            int nodeNumber;
            for (int i = nodeNumber = this.nodeIdToOrderedNodeNumberMap.get(nodeId).intValue(); i < this.nodeIdToOrderedNodeNumberMap.keySet().size(); ++i) {
                String succeedingNodeId = this.OrderedNodeNumberToNodeIdMap.get(i + 1);
                INode succceedingNode = graph.findNode(succeedingNodeId);
                if (succceedingNode == null || !GrafReader.isLeafNode(succceedingNode) || GrafReader.isFloatingNode(succceedingNode)) continue;
                return succceedingNode;
            }
            return null;
        }
        return null;
    }
}

