/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper_RSDModule;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper_RSDModule.RSDImporterProperties;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSD2SaltMapper
extends PepperMapperImpl {
    private String namespace;
    private String edgeType;
    private String edgeAnnoName;
    private boolean addEduNum;
    private boolean addRel;
    private SLayer layer;
    private static final Logger logger = LoggerFactory.getLogger(RSD2SaltMapper.class);

    public RSD2SaltMapper() {
        this.setProperties(new RSDImporterProperties());
    }

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        this.namespace = this.getProperties().getProperties().getProperty("RSD.namespace", "rsd");
        if (this.namespace != null) {
            this.layer = SaltFactory.createSLayer();
            this.layer.setName(this.namespace);
            this.layer.setGraph((Graph)this.getDocument().getDocumentGraph());
        }
        this.edgeType = this.getProperties().getProperties().getProperty("RSD.edgeType", "rsd");
        this.edgeAnnoName = this.getProperties().getProperties().getProperty("RSD.edgeAnnoName", "func");
        this.addEduNum = this.getProperties().getProperty("RSD.addEduNum").getValue() instanceof Boolean ? ((Boolean)this.getProperties().getProperty("RSD.addEduNum").getValue()).booleanValue() : Boolean.valueOf((String)this.getProperties().getProperty("RSD.addEduNum").getValue()).booleanValue();
        this.addRel = this.getProperties().getProperty("RSD.addRelAnno").getValue() instanceof Boolean ? ((Boolean)this.getProperties().getProperty("RSD.addRelAnno").getValue()).booleanValue() : Boolean.valueOf((String)this.getProperties().getProperty("RSD.addRelAnno").getValue()).booleanValue();
        URI resource = this.getResourceURI();
        logger.debug("Importing the file {}.", (Object)resource.toFileString());
        TupleReader tupleReader = TupleConnectorFactory.fINSTANCE.createTupleReader();
        try {
            tupleReader.setSeperator("\t");
            tupleReader.setFile(new File(this.getResourceURI().toFileString()));
            tupleReader.readFile();
        }
        catch (IOException e) {
            String errorMessage = "Input file could not be read. Aborting conversion of file " + this.getResourceURI() + ".";
            logger.error(errorMessage);
            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
        }
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setGraph((Graph)this.getDocument().getDocumentGraph());
        LinkedHashMap<String, String> child2parent = new LinkedHashMap<String, String>();
        LinkedHashMap<String, SSpan> id2edu = new LinkedHashMap<String, SSpan>();
        LinkedHashMap<String, String> id2rel = new LinkedHashMap<String, String>();
        Collection tuple = null;
        int numOfTuples = tupleReader.getNumOfTuples();
        boolean fieldNum = true;
        float processedTuples = 0.0f;
        int stringBuilderCharBufferSize = tupleReader.characterSize(Integer.valueOf(2)) + numOfTuples;
        StringBuilder primaryText = new StringBuilder(stringBuilderCharBufferSize);
        for (int rowIndex = 0; rowIndex < numOfTuples; ++rowIndex) {
            try {
                tuple = tupleReader.getTuple();
            }
            catch (IOException e) {
                String errorMessage = String.format("line %d of input file could not be read. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1);
                throw new PepperModuleDataException((PepperMapper)this, errorMessage);
            }
            int tupleSize = tuple.size();
            if (tupleSize != 1 && tupleSize == 10) {
                String[] featlist;
                String[] toks;
                Iterator iter = tuple.iterator();
                String eduID = (String)iter.next();
                String eduText = (String)iter.next();
                iter.next();
                iter.next();
                iter.next();
                String feats = (String)iter.next();
                String parentID = (String)iter.next();
                String rsdRel = (String)iter.next();
                SSpan edu = SaltFactory.createSSpan();
                edu.setGraph((Graph)this.getDocument().getDocumentGraph());
                if (this.namespace != null) {
                    edu.addLayer((Layer)this.layer);
                }
                for (String tok : toks = eduText.split(" ")) {
                    int tokenTextStartOffset = primaryText.length();
                    primaryText.append(tok).append(" ");
                    int tokenTextEndOffset = primaryText.length() - 1;
                    SToken sToken = SaltFactory.createSToken();
                    sToken.setGraph((Graph)this.getDocument().getDocumentGraph());
                    STextualRelation sTextualRelation = SaltFactory.createSTextualRelation();
                    sTextualRelation.setSource((Node)sToken);
                    sTextualRelation.setTarget((Node)sTextualDS);
                    sTextualRelation.setStart((Number)tokenTextStartOffset);
                    sTextualRelation.setEnd((Number)tokenTextEndOffset);
                    sTextualRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                    SSpanningRelation spanrel = SaltFactory.createSSpanningRelation();
                    spanrel.setSource((Node)edu);
                    spanrel.setTarget((Node)sToken);
                    spanrel.setGraph((Graph)this.getDocument().getDocumentGraph());
                }
                if (this.addEduNum) {
                    if (feats.length() > 0) {
                        feats = feats + "|";
                    }
                    feats = feats + "edu_num=" + eduID;
                }
                if (this.addRel) {
                    if (feats.length() > 0) {
                        feats = feats + "|";
                    }
                    feats = feats + "rsd_rel=" + rsdRel;
                }
                for (String feat : featlist = feats.split("\\|")) {
                    if (feat.indexOf("=") <= 0 || feat.indexOf("=") >= feat.length() - 1) continue;
                    String[] keyval = feat.split("=");
                    SAnnotation anno = SaltFactory.createSAnnotation();
                    anno.setName(keyval[0]);
                    anno.setValue((Object)keyval[1]);
                    if (this.namespace != null) {
                        anno.setNamespace(this.namespace);
                    }
                    edu.addAnnotation(anno);
                }
                id2edu.put(eduID, edu);
                child2parent.put(eduID, parentID);
                id2rel.put(eduID, rsdRel);
            }
            if (rowIndex / numOfTuples * 100 % 10 != 0) continue;
            this.addProgress(Double.valueOf(rowIndex / numOfTuples));
        }
        primaryText.deleteCharAt(primaryText.length() - 1);
        sTextualDS.setText(primaryText.toString());
        for (String childID : ((HashMap)child2parent).keySet()) {
            String parentID = (String)((HashMap)child2parent).get(childID);
            if (parentID.equals("0") || childID.equals(parentID)) continue;
            if (!id2edu.containsKey(childID)) {
                throw new PepperModuleDataException((PepperMapper)this, "Input error: relation with missing source element: " + childID + "\n");
            }
            if (!id2edu.containsKey(parentID)) {
                throw new PepperModuleDataException((PepperMapper)this, "Input error: relation with missing target element: " + parentID + "\n");
            }
            SPointingRelation sRel = SaltFactory.createSPointingRelation();
            sRel.setSource((Node)((HashMap)id2edu).get(childID));
            sRel.setTarget((Node)((HashMap)id2edu).get(parentID));
            sRel.setType(this.edgeType);
            SAnnotation relAnno = SaltFactory.createSAnnotation();
            if (this.namespace != null) {
                relAnno.setNamespace(this.namespace);
                sRel.addLayer((Layer)this.layer);
            }
            relAnno.setName(this.edgeAnnoName);
            relAnno.setValue(((HashMap)id2rel).get(childID));
            sRel.addAnnotation(relAnno);
            this.getDocument().getDocumentGraph().addRelation((Relation)sRel);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }
}

