/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources;

import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.EXBResourceFactory;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EXBMain {
    public static void main(String[] args) throws IOException {
        System.out.println("************************************ ExmaraldaMain ************************************");
        System.out.println("ExmaraldaMain converts files into different treetagger-formats. Therefore it loads data ");
        System.out.println("from input format into the treetagger model and exports them into output format.");
        System.out.println("supported formats:");
        System.out.println("\t * a tab-separted file with ending .tab");
        System.out.println("\t * the xmi file created by ecore with ending .treetagger");
        System.out.println("The kind of file will be discovered automatically.");
        System.out.println();
        System.out.println("Synopsis: ExmaraldaMain -i INPUT_FILE -o OUTPUT_FILE");
        System.out.println();
        String inputFile = null;
        String outputFile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-i")) {
                inputFile = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-o")) {
                outputFile = args[i + 1];
            }
            ++i;
        }
        System.out.println("reading from: " + inputFile + " writing to: " + outputFile);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("exmaralda", new XMIResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("exb", new EXBResourceFactory());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)inputFile));
        if (resource == null) {
            throw new NullPointerException("The resource is null.");
        }
        resource.load(null);
        BasicTranscription basicTranscription = (BasicTranscription)resource.getContents().get(0);
        System.out.println(basicTranscription);
        Resource resourceOut = resourceSet.createResource(URI.createFileURI((String)outputFile));
        resourceOut.getContents().add((Object)basicTranscription);
        resourceOut.save(null);
        System.out.println("****************************************************************************************");
    }
}

