/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.nlpModules.tokenizer;

import java.util.List;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.exceptions.SaltTokenizerException;

public class SimpleTokenizer {
    private SDocumentGraph documentGraph = null;

    public void setDocumentGraph(SDocumentGraph documentGraph) {
        this.documentGraph = documentGraph;
    }

    public SDocumentGraph getDocumentGraph() {
        return this.documentGraph;
    }

    public List<SToken> tokenize(STextualDS textualDSs, Character ... separator) {
        return this.tokenize(textualDSs, (Integer)null, (Integer)null, separator);
    }

    public List<SToken> tokenize(STextualDS textualDS, Integer startPos, Integer endPos, Character ... separator) {
        List<SToken> retVal = null;
        if (textualDS == null) {
            throw new SaltTokenizerException("Cannot tokenize an empty 'SSTextualDS' object.");
        }
        if (this.getDocumentGraph() == null) {
            if (textualDS.getGraph() == null) {
                throw new SaltTokenizerException("Cannot add tokens to an empty SDocumentGraph object and can not estimate SDocumentGraph, because STextualDS does not belong to a SDocumentGraph object.");
            }
            this.setDocumentGraph(textualDS.getGraph());
        }
        if (textualDS.getText() != null) {
            if (startPos == null) {
                startPos = 0;
            }
            if (endPos == null) {
                endPos = textualDS.getText().length();
            }
            char[] text = startPos != 0 || endPos.intValue() != textualDS.getText().length() ? textualDS.getText().substring(startPos, endPos).toCharArray() : textualDS.getText().toCharArray();
            boolean isSep = false;
            int currStart = 0;
            int currEnd = 0;
            boolean wasHere = false;
            for (char chr : text) {
                wasHere = false;
                Character[] characterArray = separator;
                int n = characterArray.length;
                for (int i = 0; i < n; ++i) {
                    char sep = characterArray[i].charValue();
                    if (chr == sep) {
                        if (currStart != currEnd) {
                            this.getDocumentGraph().createToken((SSequentialDS)textualDS, Integer.valueOf(startPos + currStart), Integer.valueOf(startPos + currEnd));
                        }
                        isSep = true;
                    } else {
                        if (wasHere) break;
                        isSep = false;
                    }
                    wasHere = true;
                }
                ++currEnd;
                if (!isSep) continue;
                currStart = currEnd;
            }
            if (!isSep) {
                this.getDocumentGraph().createToken((SSequentialDS)textualDS, Integer.valueOf(startPos + currStart), Integer.valueOf(startPos + currEnd));
            }
        }
        return retVal;
    }
}

