/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.nlpModules;

import java.io.File;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;

public class TokenizerProperties
extends PepperModuleProperties {
    public static final String PREFIX = "tokenizer.";
    public static final String PROP_ABBREVIATION_FOLDER = "tokenizer.abbreviationFolder";
    public static final String PROP_ADD_TEXT_TO_SPAN = "tokenizer.addTextToSpan";

    public boolean checkProperty(PepperModuleProperty<?> prop) {
        super.checkProperty(prop);
        if (PROP_ABBREVIATION_FOLDER.equals(prop.getName())) {
            File file = (File)prop.getValue();
            if (!file.exists()) {
                throw new PepperModuleException("The file set to property 'tokenizer.abbreviationFolder' does not exist.");
            }
            if (!file.isDirectory()) {
                throw new PepperModuleException("The file '" + file.getAbsolutePath() + "'set to property '" + PROP_ABBREVIATION_FOLDER + "' is not a directory.");
            }
        }
        return true;
    }

    public TokenizerProperties() {
        this.addProperty(new PepperModuleProperty(PROP_ABBREVIATION_FOLDER, File.class, "Since the TreeTagger tokenizer produces better results, when it knows about abbreviations used in the text corresponding to the language of the text, it is possible to feed the Tokenizer module with lists of abbreviations.", null, false));
        this.addProperty(new PepperModuleProperty(PROP_ADD_TEXT_TO_SPAN, Boolean.class, "For existing tokens, add the original text as annotation to the newly created span", (Object)false, false));
    }

    public File getAbbreviationFolder() {
        File abbFolder = (File)this.getProperty(PROP_ABBREVIATION_FOLDER).getValue();
        return abbFolder;
    }

    public boolean getAddTextToSpan() {
        Boolean b = (Boolean)this.getProperty(PROP_ADD_TEXT_TO_SPAN).getValue();
        if (b != null) {
            return b;
        }
        return false;
    }
}

