/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.nlpModules;

import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class LemmatizerProperties
extends PepperModuleProperties {
    public static final String PREFIX = "lemmatizer.";
    public static final String POS_ANNO = "lemmatizer.posAnno";
    public static final String NO_LOWER = "lemmatizer.noLower";
    public static final String ALLOW_UNKNOWN = "lemmatizer.allowUnknown";
    public static final String MAKE_UNKNOWN_LOWER = "lemmatizer.makeUnknownLower";
    public static final String UNKNOWN_STRING = "lemmatizer.unknownString";
    public static final String LEMMA_NAME = "lemmatizer.lemmaName";
    public static final String LEMMA_NAMESPACE = "lemmatizer.lemmaNamespace";
    public static final String LEXICON_FILE = "lemmatizer.lexiconFile";

    public LemmatizerProperties() {
        this.addProperty(new PepperModuleProperty(POS_ANNO, String.class, "Name of a part of speech annotation to check (default: pos).", (Object)"pos", false));
        this.addProperty(new PepperModuleProperty(NO_LOWER, Boolean.class, "Normally lower cased forms are searched if exact match is not found, set noLower to TRUE to override (default: FALSE).", (Object)false, false));
        this.addProperty(new PepperModuleProperty(ALLOW_UNKNOWN, Boolean.class, "If no lemma is found, the token's string will be used instead, set noUnknown to FALSE to use the unknownString value instead (default: FALSE).", (Object)false, false));
        this.addProperty(new PepperModuleProperty(MAKE_UNKNOWN_LOWER, Boolean.class, "Optionally, when using the token string instead of an unknown lemma, the value can be lower cased (default: FALSE).", (Object)false, false));
        this.addProperty(new PepperModuleProperty(UNKNOWN_STRING, String.class, "Specifies a string to use for all unknown lemmas.", null, false));
        this.addProperty(new PepperModuleProperty(LEMMA_NAME, String.class, "Specifies the name of the lemma annotation (default: lemma).", (Object)"lemma", false));
        this.addProperty(new PepperModuleProperty(LEMMA_NAMESPACE, String.class, "Specifies the namespace for the lemma annotation (default: default_ns).", (Object)"default_ns", false));
        this.addProperty(new PepperModuleProperty(LEXICON_FILE, String.class, "Optional path to a file containing the lemma lexicon, if not using a built-in lexicon.", null, false));
    }
}

