/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.genericXMLModules.xpath;

import java.util.List;
import java.util.Vector;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;

public class XPathExpression {
    public static final String XML_WILDCARD_ALIAS = "WILDCARD";
    public static final String XML_TEXT = "text()";
    private List<String> steps = null;

    public XPathExpression(String xPathExpression) {
        this.setXPathExpression(xPathExpression);
    }

    public XPathExpression() {
    }

    public void setXPathExpression(String xPathExpression) {
        if (xPathExpression == null) {
            throw new NullPointerException("an empty XPathExpression was given.");
        }
        if ((xPathExpression = xPathExpression.replace("//", "/WILDCARD/")).startsWith("/")) {
            xPathExpression = xPathExpression.replaceFirst("/", "");
        }
        this.steps = new Vector<String>();
        String[] parts = xPathExpression.split("/");
        if (parts.length > 0) {
            for (String part : parts) {
                this.steps.add(part);
            }
        }
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public Boolean matches(String xPathExpressionStr) {
        XPathExpression xPathExpression = new XPathExpression(xPathExpressionStr);
        return this.matches(xPathExpression);
    }

    public Boolean matches(XPathExpression xPathExpression) {
        if (xPathExpression == null) {
            throw new NullPointerException("Cannot math against an empty XPath expression.");
        }
        return XPathExpression.matches(this, xPathExpression);
    }

    public static Boolean matches(XPathExpression xPathExpression1, XPathExpression xPathExpression2) {
        if (xPathExpression1 == null || xPathExpression2 == null) {
            throw new PepperModuleException("Cannot match against an empty XPath expression.");
        }
        boolean goOn = true;
        int step1 = 0;
        int step2 = 0;
        boolean equal = true;
        while (goOn) {
            if (step2 == xPathExpression2.getSteps().size()) {
                if (step1 == xPathExpression1.getSteps().size()) {
                    equal = true;
                    break;
                }
                equal = false;
                break;
            }
            if (step1 == xPathExpression1.getSteps().size()) {
                if (step2 == xPathExpression2.getSteps().size()) {
                    equal = true;
                    break;
                }
                equal = false;
                break;
            }
            if (xPathExpression1.getSteps().get(step1).equals(xPathExpression2.getSteps().get(step2))) {
                ++step1;
            } else if (XML_WILDCARD_ALIAS.toString().equals(xPathExpression1.getSteps().get(step1))) {
                if (step1 == xPathExpression1.getSteps().size() - 1) {
                    if (xPathExpression2.getSteps().get(xPathExpression2.getSteps().size() - 1).startsWith("@") || XML_TEXT.equals(xPathExpression2.getSteps().get(xPathExpression2.getSteps().size() - 1))) {
                        equal = false;
                        break;
                    }
                    equal = true;
                    break;
                }
                if (!xPathExpression1.getSteps().get(step1 + 1).equals(xPathExpression2.getSteps().get(step2))) {
                    equal = false;
                } else {
                    equal = true;
                    step1 += 2;
                }
            } else if (!xPathExpression1.getSteps().get(step1).equals(xPathExpression2.getSteps().get(step2))) {
                equal = false;
            }
            ++step2;
        }
        return equal;
    }

    public void addStep(String step) {
        if (this.steps == null) {
            this.steps = new Vector<String>();
        }
        if (step != null && !step.isEmpty()) {
            if ("//".equals(step)) {
                this.steps.add(XML_WILDCARD_ALIAS);
            } else {
                this.steps.add(step);
            }
        }
    }

    public void removeLastStep() {
        if (this.steps != null && this.steps.size() > 0) {
            this.steps.remove(this.steps.size() - 1);
        }
    }

    public String toString() {
        if (this.steps != null) {
            return this.steps.toString();
        }
        return "[]";
    }
}

