/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.genericXMLModules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.peppermodules.genericXMLModules.GenericXMLImporterProperties;
import org.corpus_tools.peppermodules.genericXMLModules.xpath.XPathExpression;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class XML2SaltMapper
extends PepperMapperImpl {
    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        try {
            XMLReader reader = new XMLReader();
            this.readXMLResource(reader, this.getResourceURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            return DOCUMENT_STATUS.FAILED;
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public synchronized boolean onlyContainsIgnorableCharacters(String text) {
        Set<String> ignorableCharacters = ((GenericXMLImporterProperties)this.getProperties()).getIgnorableWhitespaces();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            if (ignorableCharacters.contains(ch.toString())) continue;
            return false;
        }
        return true;
    }

    private class XMLReader
    extends DefaultHandler2 {
        private boolean isInitialized = false;
        private XPathExpression currentXPath = null;
        private STextualDS currentSDS = null;
        private Stack<ElementNodeEntry> elementNodeStack = null;
        private Stack<SLayer> sLayerStack = null;

        private XMLReader() {
        }

        private boolean matches(Collection<XPathExpression> xprList, XPathExpression xpr) {
            if (xprList != null && xprList.size() > 0) {
                for (XPathExpression xpr2 : xprList) {
                    if (!XPathExpression.matches(xpr2, xpr).booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }

        private void init() {
            this.currentXPath = new XPathExpression();
            this.currentSDS = SaltFactory.createSTextualDS();
            this.getsDocumentGraph().addNode((Node)this.currentSDS);
            this.elementNodeStack = new Stack();
            this.isInitialized = true;
            this.sLayerStack = new Stack();
        }

        public SDocumentGraph getsDocumentGraph() {
            return XML2SaltMapper.this.getDocument().getDocumentGraph();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.isInitialized) {
                this.init();
            }
            this.currentXPath.addStep("text()");
            if (!this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getIgnoreList(), this.currentXPath)) {
                StringBuffer textBuf = new StringBuffer();
                for (int i = start; i < start + length; ++i) {
                    textBuf.append(ch[i]);
                }
                String text = textBuf.toString();
                if (textBuf.length() > 0 && !XML2SaltMapper.this.onlyContainsIgnorableCharacters(text)) {
                    textBuf = new StringBuffer();
                    String containedText = this.currentSDS.getText();
                    if (containedText != null) {
                        textBuf.append(containedText);
                        textBuf.append(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getSeparateToken());
                    }
                    int sStart = textBuf.length();
                    textBuf.append(text);
                    this.currentSDS.setText(textBuf.toString());
                    int sEnd = textBuf.length();
                    if (!((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).isTextOnly()) {
                        SToken sToken = SaltFactory.createSToken();
                        sToken.setName(this.elementNodeStack.peek().nodeName);
                        this.getsDocumentGraph().addNode((Node)sToken);
                        this.copySAbstractAnnotations((SNode)sToken);
                        if (!this.sLayerStack.isEmpty()) {
                            sToken.addLayer((Layer)this.sLayerStack.peek());
                        }
                        STextualRelation sTextRel = SaltFactory.createSTextualRelation();
                        sTextRel.setSource((Node)sToken);
                        sTextRel.setTarget((Node)this.currentSDS);
                        sTextRel.setStart((Number)sStart);
                        sTextRel.setEnd((Number)sEnd);
                        this.getsDocumentGraph().addRelation((Relation)sTextRel);
                        if (((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).isCreateSStructure()) {
                            Object sNode = null;
                            this.currentXPath.removeLastStep();
                            sNode = this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getAsSpans(), this.currentXPath) ? SaltFactory.createSSpan() : SaltFactory.createSStructure();
                            this.currentXPath.addStep("text()");
                            sNode.setName("art");
                            this.getsDocumentGraph().addNode((Node)sNode);
                            SSpanningRelation sRel = null;
                            if (sNode instanceof SSpan) {
                                sRel = SaltFactory.createSSpanningRelation();
                            } else if (sNode instanceof SStructure) {
                                sRel = SaltFactory.createSDominanceRelation();
                            }
                            if (sRel != null) {
                                sRel.setSource((Node)sNode);
                                sRel.setTarget((Node)sToken);
                                this.getsDocumentGraph().addRelation((Relation)sRel);
                                if (!this.sLayerStack.isEmpty()) {
                                    sRel.getLayers().add(this.sLayerStack.peek());
                                }
                            }
                            for (SAnnotation sAnno : sToken.getAnnotations()) {
                                sNode.addAnnotation(sAnno);
                            }
                            for (SMetaAnnotation sMetaAnno : sToken.getMetaAnnotations()) {
                                sNode.addMetaAnnotation(sMetaAnno);
                            }
                            if (this.elementNodeStack.size() > 1) {
                                ((ElementNodeEntry)this.elementNodeStack.get((int)(this.elementNodeStack.size() - 2))).openSNodes.add((SNode)sNode);
                            }
                            if (!this.sLayerStack.isEmpty()) {
                                sNode.getLayers().add(this.sLayerStack.peek());
                            }
                        } else {
                            this.elementNodeStack.peek().representedSToken = sToken;
                            if (this.elementNodeStack.peek().isComplex().booleanValue()) {
                                this.elementNodeStack.peek().openSNodes.add((SNode)sToken);
                            } else if (this.elementNodeStack.size() > 1) {
                                ((ElementNodeEntry)this.elementNodeStack.get((int)(this.elementNodeStack.size() - 2))).openSNodes.add((SNode)sToken);
                            }
                        }
                    }
                }
            }
            this.currentXPath.removeLastStep();
        }

        private void createArtificialSAnno(ElementNodeEntry entry) {
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName(entry.nodeName);
            sAnno.setValue((Object)entry.nodeName);
            if (entry.annotations == null) {
                entry.annotations = new ArrayList<SAbstractAnnotation>();
            }
            entry.annotations.add((SAbstractAnnotation)sAnno);
        }

        private List<SAbstractAnnotation> createSAbstractAnnotations(Class<? extends SAbstractAnnotation> clazz, String nodeName, Attributes attributes) {
            ArrayList<SMetaAnnotation> annoList = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if (annoList == null) {
                    annoList = new ArrayList<SMetaAnnotation>();
                }
                this.currentXPath.addStep("@" + attName);
                if (!this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getIgnoreList(), this.currentXPath)) {
                    if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getMetaAnnotationSDocumentList(), this.currentXPath)) {
                        if (this.getsDocumentGraph().getDocument() != null) {
                            this.getsDocumentGraph().getDocument().createAnnotation(null, attName, (Object)attributes.getValue(i));
                        }
                    } else {
                        SMetaAnnotation sAnno = null;
                        if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getMetaAnnotationList(), this.currentXPath)) {
                            sAnno = SaltFactory.createSMetaAnnotation();
                        } else if (SMetaAnnotation.class.equals(clazz)) {
                            sAnno = SaltFactory.createSMetaAnnotation();
                        } else if (SAnnotation.class.equals(clazz)) {
                            sAnno = SaltFactory.createSAnnotation();
                        }
                        if (!(sAnno == null || ((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).isIgnoreNamespaces() && "xmlns".equals(attName) || attName.contains("xmlns"))) {
                            String[] parts = attName.split(":");
                            String sName = parts.length > 1 ? parts[parts.length - 1] : attName;
                            if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getPrefixedAnnoList(), this.currentXPath)) {
                                sAnno.setName(nodeName + "_" + sName);
                            } else {
                                sAnno.setName(sName);
                            }
                            sAnno.setValue((Object)attributes.getValue(i));
                            annoList.add(sAnno);
                        }
                    }
                }
                this.currentXPath.removeLastStep();
            }
            return annoList;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.isInitialized) {
                this.init();
            }
            this.currentXPath.addStep(qName);
            if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getMetaAnnotationSDocumentList(), this.currentXPath)) {
                List<SAbstractAnnotation> annoList = this.createSAbstractAnnotations(SMetaAnnotation.class, localName, attributes);
                if (this.getsDocumentGraph().getDocument() != null && annoList != null) {
                    for (SAbstractAnnotation sAnno : annoList) {
                        this.getsDocumentGraph().getDocument().addMetaAnnotation((SMetaAnnotation)sAnno);
                    }
                }
            } else if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getSLayerList(), this.currentXPath)) {
                SLayer currSLayer = null;
                List sLayers = this.getsDocumentGraph().getLayerByName(qName);
                if (sLayers != null && sLayers.size() > 0) {
                    currSLayer = (SLayer)sLayers.get(0);
                }
                if (currSLayer == null) {
                    currSLayer = SaltFactory.createSLayer();
                    currSLayer.setName(qName);
                }
                List<SAbstractAnnotation> annoList = this.createSAbstractAnnotations(SMetaAnnotation.class, qName, attributes);
                if (currSLayer != null && annoList != null && annoList.size() > 0) {
                    for (SAbstractAnnotation sAnno : annoList) {
                        currSLayer.addMetaAnnotation((SMetaAnnotation)sAnno);
                    }
                }
                this.getsDocumentGraph().addLayer((Layer)currSLayer);
                this.sLayerStack.push(currSLayer);
            } else if (!this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getIgnoreList(), this.currentXPath) && !((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).isTextOnly()) {
                if (this.elementNodeStack.size() > 0) {
                    this.elementNodeStack.peek().setIsComplex(true);
                }
                ArrayList<SAbstractAnnotation> annoList = null;
                if (attributes.getLength() > 0) {
                    annoList = new ArrayList<SAbstractAnnotation>();
                    annoList.addAll(this.createSAbstractAnnotations(SAnnotation.class, qName, attributes));
                }
                if (this.elementNodeStack.size() > 0) {
                    this.elementNodeStack.peek().setIsComplex(true);
                }
                ElementNodeEntry elementNode = new ElementNodeEntry(qName, annoList);
                if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getElementNameAsSAnnoList(), this.currentXPath)) {
                    this.createArtificialSAnno(elementNode);
                }
                this.elementNodeStack.push(elementNode);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getMetaAnnotationSDocumentList(), this.currentXPath)) {
                if (this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getSLayerList(), this.currentXPath)) {
                    if (!this.sLayerStack.isEmpty()) {
                        this.sLayerStack.pop();
                    }
                } else if (!this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getIgnoreList(), this.currentXPath) && !((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).isTextOnly()) {
                    if (this.elementNodeStack.peek().isComplex().booleanValue()) {
                        Object sNode = null;
                        sNode = this.matches(((GenericXMLImporterProperties)XML2SaltMapper.this.getProperties()).getAsSpans(), this.currentXPath) ? SaltFactory.createSSpan() : SaltFactory.createSStructure();
                        sNode.setName(qName);
                        this.getsDocumentGraph().addNode((Node)sNode);
                        this.copySAbstractAnnotations((SNode)sNode);
                        if (this.elementNodeStack.peek().openSNodes.size() > 0) {
                            for (SNode childSNode : this.elementNodeStack.peek().openSNodes) {
                                List outRelations;
                                SSpanningRelation sRel = null;
                                if (sNode instanceof SSpan && childSNode instanceof SToken) {
                                    sRel = SaltFactory.createSSpanningRelation();
                                } else if (sNode instanceof SStructure) {
                                    sRel = SaltFactory.createSDominanceRelation();
                                } else if (sNode instanceof SSpan && childSNode instanceof SSpan && (outRelations = this.getsDocumentGraph().getOutRelations(childSNode.getId())) != null) {
                                    for (Relation outRelation : outRelations) {
                                        if (!(outRelation instanceof SSpanningRelation)) continue;
                                        SSpanningRelation sSpanRel = SaltFactory.createSSpanningRelation();
                                        sSpanRel.setSource((Node)sNode);
                                        sSpanRel.setTarget(((SSpanningRelation)outRelation).getTarget());
                                        this.getsDocumentGraph().addRelation((Relation)sSpanRel);
                                        if (this.sLayerStack.isEmpty()) continue;
                                        sSpanRel.getLayers().add(this.sLayerStack.peek());
                                    }
                                }
                                if (sRel == null) continue;
                                sRel.setSource((Node)sNode);
                                sRel.setTarget((Node)childSNode);
                                this.getsDocumentGraph().addRelation((Relation)sRel);
                                if (this.sLayerStack.isEmpty()) continue;
                                sRel.addLayer((Layer)this.sLayerStack.peek());
                            }
                        }
                        if (this.elementNodeStack.size() > 1) {
                            ((ElementNodeEntry)this.elementNodeStack.get((int)(this.elementNodeStack.size() - 2))).openSNodes.add((SNode)sNode);
                        }
                        if (!this.sLayerStack.isEmpty()) {
                            sNode.addLayer((Layer)this.sLayerStack.peek());
                        }
                    }
                    this.elementNodeStack.pop();
                }
            }
            this.currentXPath.removeLastStep();
        }

        private void copySAbstractAnnotations(SNode sNode) {
            if (this.elementNodeStack.peek().annotations != null) {
                for (SAbstractAnnotation sAnno : this.elementNodeStack.peek().annotations) {
                    if (sAnno instanceof SAnnotation) {
                        sNode.addAnnotation((SAnnotation)sAnno);
                        continue;
                    }
                    if (!(sAnno instanceof SMetaAnnotation)) continue;
                    sNode.addMetaAnnotation((SMetaAnnotation)sAnno);
                }
            }
        }

        private class ElementNodeEntry {
            public List<SNode> openSNodes = null;
            public String nodeName = null;
            public SToken representedSToken = null;
            public List<SAbstractAnnotation> annotations = null;
            private Boolean isComplex = false;

            public Boolean isComplex() {
                return this.isComplex;
            }

            public void setIsComplex(Boolean isComplex) {
                this.isComplex = isComplex;
                if (isComplex.booleanValue() && this.representedSToken != null) {
                    if (!this.openSNodes.contains(this.representedSToken)) {
                        this.openSNodes.add((SNode)this.representedSToken);
                    }
                    if (XMLReader.this.elementNodeStack.size() > 1) {
                        ((ElementNodeEntry)((XMLReader)XMLReader.this).elementNodeStack.get((int)(((XMLReader)XMLReader.this).elementNodeStack.size() - 2))).openSNodes.remove(this.representedSToken);
                    }
                    this.representedSToken = null;
                }
            }

            public ElementNodeEntry(String nodeName, List<SAbstractAnnotation> annotations) {
                this.nodeName = nodeName;
                this.annotations = annotations;
                this.openSNodes = new Vector<SNode>();
            }

            public String toString() {
                return "[" + this.nodeName + ", annotations: " + this.annotations + ", isComplex: " + this.isComplex() + ", openSNodes: " + this.openSNodes + "]";
            }
        }
    }
}

