/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.genericXMLModules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.peppermodules.genericXMLModules.xpath.XPathExpression;

public class GenericXMLImporterProperties
extends PepperModuleProperties {
    public static final String PREFIX = "genericXml.importer.";
    public static final String PROP_IGNORE_LIST = "genericXml.importer.ignoreList";
    public static final String PROP_AS_SPANS = "genericXml.importer.asSSpan";
    public static final String PROP_PREFIXED_ANNOS = "genericXml.importer.prefixSAnnotationName";
    public static final String PROP_ARTIFICIAL_SSTRUCT = "genericXml.importer.artificialSStruct";
    public static final String PROP_SMETA_ANNOTATION = "genericXml.importer.sMetaAnnotation";
    public static final String PROP_SMETA_ANNOTATION_SDOCUMENT = "genericXml.importer.sMetaAnnotation.sDocument";
    public static final String PROP_TEXT_ONLY = "genericXml.importer.textOnly";
    public static final String PROP_SLAYER = "genericXml.importer.sLayer";
    public static final String PROP_IGNORABLE_WHITESPACES = "genericXml.importer.ignoreWhitepsaces";
    public static final String PROP_IGNORABLE_NAMESPACES = "genericXml.importer.ignoreNamespaces";
    public static final String PROP_ELEMENTNAME_AS_SANNO = "genericXml.importer.elementNameAsSAnno";
    public static final String PROP_FILE_ENDINGS = "genericXml.importer.file.endings";
    public static final String PROP_SEPARATE_TOKENS = "genericXml.importer.separateTokens";
    public static final String KW_ALL = "ALL";
    public static final String DEFAULT_WHITESPACES = "'\n','\r','\t',' '";
    private Collection<XPathExpression> ignoreList = null;
    private Collection<XPathExpression> asSpans = null;
    private Collection<XPathExpression> prefixedAnnoList = null;
    private Collection<XPathExpression> sMetaAnnoList = null;
    private Collection<XPathExpression> sMetaAnnoSDocumentList = null;
    private Collection<XPathExpression> sLayerList = null;
    private Set<String> ignorableWhitespaces = null;
    private Collection<XPathExpression> elementNameAsSAnnoList = null;
    private String separateToken = "";

    public GenericXMLImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_IGNORE_LIST, String.class, "IgnoreList is a list of nodes (element nodes , attribute -nodes and text-nodes, which shall be ignored while processing. Note that if an element node is part of the ignore list, its subtree will also be ignored)", false));
        this.addProperty(new PepperModuleProperty(PROP_AS_SPANS, String.class, "In case of you don't want to map an element node to an SStructure, you can map it to an SSpan. Note that this is only possible, if the element node directly contains a text node.", false));
        this.addProperty(new PepperModuleProperty(PROP_PREFIXED_ANNOS, String.class, "You can set this flag to prefix the SName of the SAnnotation with the name of the surrounding element node.", false));
        this.addProperty(new PepperModuleProperty(PROP_SMETA_ANNOTATION, String.class, "Determines a list a list of attribute names mapped to SMetaAnnotation objects instead of SAnnotationobjects.", false));
        this.addProperty(new PepperModuleProperty(PROP_SMETA_ANNOTATION_SDOCUMENT, String.class, "Determines a list of element-nodes which subtrees are mapped to meta-data on entire SDocument.", false));
        this.addProperty(new PepperModuleProperty(PROP_SLAYER, String.class, "Determines a list of element-nodes which are mapped to a SLayer object.", false));
        this.addProperty(new PepperModuleProperty(PROP_ARTIFICIAL_SSTRUCT, Boolean.class, "If set to true, for each text node an artificial SStructuredNode will be created and overlap the also created (always even if this property is set to false) SToken node.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_TEXT_ONLY, Boolean.class, "Determines if only text-nodes are mapped.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_IGNORABLE_WHITESPACES, String.class, "Determine which whitespace characters are ignored and add to {@link STextualDS} object,     * but do not get an own {@link SToken} object. A list separated by ',' for instance \\n,\\r, ,... for linefeed, carriage return and blank.", (Object)DEFAULT_WHITESPACES, false));
        this.addProperty(new PepperModuleProperty(PROP_IGNORABLE_NAMESPACES, Boolean.class, "Determines if xml-namespaces and namespace declarations are ignored.", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENTNAME_AS_SANNO, String.class, " Determines a list of element-nodes whichs names are mapped to SAnnotation objects having that name as sName and sValue", false));
        this.addProperty(new PepperModuleProperty(PROP_FILE_ENDINGS, String.class, "Determines a list, containing the file endings, which files shall be imported. If you want to import all contained files no matter to their ending, add the string 'ALL' to the list. ", (Object)KW_ALL, false));
        this.addProperty(new PepperModuleProperty(PROP_SEPARATE_TOKENS, String.class, "Sets a separator between tokens, the default is a blank, but it can be set to any other character or even ot the empty String. ", (Object)" ", false));
    }

    public synchronized List<String> getFileEndings() {
        ArrayList<String> retVal = new ArrayList<String>();
        String endingList = (String)this.getProperty(PROP_FILE_ENDINGS).getValue();
        String[] endings = endingList.split(",");
        if (endings != null) {
            for (String ending : endings) {
                retVal.add(ending.trim());
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getIgnoreList() {
        if (this.ignoreList == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.ignoreList == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_IGNORE_LIST);
                    if (this.ignoreList == null) {
                        this.ignoreList = xPathList;
                    }
                }
            }
        }
        return this.ignoreList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getAsSpans() {
        if (this.asSpans == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.asSpans == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_AS_SPANS);
                    if (this.asSpans == null) {
                        this.asSpans = xPathList;
                    }
                }
            }
        }
        return this.asSpans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getPrefixedAnnoList() {
        if (this.prefixedAnnoList == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.prefixedAnnoList == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_PREFIXED_ANNOS);
                    if (this.prefixedAnnoList == null) {
                        this.prefixedAnnoList = xPathList;
                    }
                }
            }
        }
        return this.prefixedAnnoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getMetaAnnotationList() {
        if (this.sMetaAnnoList == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.sMetaAnnoList == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_SMETA_ANNOTATION);
                    if (this.sMetaAnnoList == null) {
                        this.sMetaAnnoList = xPathList;
                    }
                }
            }
        }
        return this.sMetaAnnoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getMetaAnnotationSDocumentList() {
        if (this.sMetaAnnoSDocumentList == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.sMetaAnnoSDocumentList == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_SMETA_ANNOTATION_SDOCUMENT);
                    if (this.sMetaAnnoSDocumentList == null) {
                        this.sMetaAnnoSDocumentList = xPathList;
                    }
                }
            }
        }
        return this.sMetaAnnoSDocumentList;
    }

    public Collection<XPathExpression> getSLayerList() {
        if (this.sLayerList == null) {
            Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_SLAYER);
            if (this.sLayerList == null) {
                this.sLayerList = xPathList;
            }
        }
        return this.sLayerList;
    }

    private synchronized Collection<XPathExpression> extractXPathExpr(String propName) {
        Vector<XPathExpression> xPathList = new Vector<XPathExpression>();
        PepperModuleProperty prop = this.getProperty(propName);
        if (prop != null && prop.getValue() != null) {
            String[] xPathListStr = ((String)prop.getValue()).split(",");
            if (xPathList != null) {
                for (String xPathString : xPathListStr) {
                    xPathList.add(new XPathExpression(xPathString.trim()));
                }
            }
        }
        return xPathList;
    }

    public boolean isCreateSStructure() {
        return (Boolean)this.getProperty(PROP_ARTIFICIAL_SSTRUCT).getValue();
    }

    public boolean isTextOnly() {
        return (Boolean)this.getProperty(PROP_TEXT_ONLY).getValue();
    }

    public boolean isIgnoreNamespaces() {
        return (Boolean)this.getProperty(PROP_IGNORABLE_NAMESPACES).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIgnorableWhitespaces() {
        if (this.ignorableWhitespaces == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                PepperModuleProperty prop;
                if (this.ignorableWhitespaces == null && (prop = this.getProperty(PROP_IGNORABLE_WHITESPACES)).getValue() != null) {
                    String[] parts;
                    this.ignorableWhitespaces = new HashSet<String>();
                    for (String part : parts = ((String)prop.getValue()).split(",")) {
                        this.ignorableWhitespaces.add(part.replace("'", ""));
                    }
                }
            }
        }
        return this.ignorableWhitespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XPathExpression> getElementNameAsSAnnoList() {
        if (this.elementNameAsSAnnoList == null) {
            GenericXMLImporterProperties genericXMLImporterProperties = this;
            synchronized (genericXMLImporterProperties) {
                if (this.elementNameAsSAnnoList == null) {
                    Collection<XPathExpression> xPathList = this.extractXPathExpr(PROP_ELEMENTNAME_AS_SANNO);
                    if (this.elementNameAsSAnnoList == null) {
                        this.elementNameAsSAnnoList = xPathList;
                    }
                }
            }
        }
        return this.elementNameAsSAnnoList;
    }

    public String getSeparateToken() {
        PepperModuleProperty prop = this.getProperty(PROP_SEPARATE_TOKENS);
        if (prop.getValue() != null) {
            this.separateToken = (String)prop.getValue();
        }
        return this.separateToken;
    }
}

