/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.genericXMLModules;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.genericXMLModules.GenericXMLImporterProperties;
import org.corpus_tools.peppermodules.genericXMLModules.XML2SaltMapper;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="GenericXMLImporterComponent", factory="PepperImporterComponentFactory")
public class GenericXMLImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String FORMAT_NAME = "xml";
    public static final String FORMAT_VERSION = "1.0";

    public GenericXMLImporter() {
        this.setName("GenericXMLImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-GenericXMLModules"));
        this.setDesc("Imports data coming from any XML file. The textual content of an element will be interpreted as a sequence of primary data. When processing the file, the importer will concatenate all these texts to an entire primary text. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.setProperties(new GenericXMLImporterProperties());
    }

    public boolean isReadyToStart() {
        Boolean retVal = super.isReadyToStart();
        List<String> fileEndings = ((GenericXMLImporterProperties)this.getProperties()).getFileEndings();
        if (!fileEndings.isEmpty()) {
            this.getDocumentEndings().add(FORMAT_NAME);
        } else if (fileEndings.contains("ALL")) {
            this.getDocumentEndings().add("ALL_FILES");
        } else if (!fileEndings.contains("ALL")) {
            this.getDocumentEndings().addAll(fileEndings);
        }
        return retVal;
    }

    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, new String[0])) {
            Pattern pattern = Pattern.compile("<?xml version=(\"|')1[.]0(\"|')");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    public SelfTestDesc getSelfTestDesc() {
        this.getProperties().setPropertyValue("genericXml.importer.asSSpan", (Object)"//body//, //body, //p//, //p, //persName//, //persName, //label//, //label, //state//, //state");
        this.getProperties().setPropertyValue("genericXml.importer.elementNameAsSAnno", (Object)"//body//, //body, //p//, //p, //persName//, //persName, //label//, //label, //state//, //state");
        this.getProperties().setPropertyValue("genericXml.importer.artificialSStruct", (Object)true);
        return new SelfTestDesc(this.getResources().appendSegment("selfTests").appendSegment("genericXmlImporter").appendSegment("in").appendSegment("rootCorpus"), this.getResources().appendSegment("selfTests").appendSegment("genericXmlImporter").appendSegment("expected"));
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        XML2SaltMapper mapper = new XML2SaltMapper();
        URI resource = (URI)this.getIdentifier2ResourceTable().get(sElementId);
        mapper.setResourceURI(resource);
        return mapper;
    }
}

