/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.uamModules;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.uamModules.UAM2SaltMapper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="UAMImporterComponent", factory="PepperImporterComponentFactory")
public class UAMImporter
extends PepperImporterImpl
implements PepperImporter {
    private static final Logger logger = LoggerFactory.getLogger(UAMImporter.class);
    private static final String PATH_TO_TEXT = "./Corpus";
    private Map<String, String> resourceOptions = null;

    public UAMImporter() {
        this.setName("UAMImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-UAMModules"));
        this.setDesc("This importer transforms data in UAM format produced by the UAM corpus tool to a Salt model. ");
        this.addSupportedFormat("UAM", "1.0", null);
    }

    public synchronized void importCorpusStructure(SCorpusGraph sCorpusGraph) throws PepperModuleException {
        if (this.getCorpusDesc() == null) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because no CorpusDefinition object is given.");
        }
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because the given uri is empty.");
        }
        logger.debug(((Object)((Object)this)).getClass().getName() + "> start importing of corpus structure for path '" + this.getCorpusDesc().getCorpusPath() + "'... ");
        File corpusPath = new File(this.getCorpusDesc().getCorpusPath().toFileString());
        if (!corpusPath.exists()) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because the given file-uri does not exist:" + corpusPath + " .");
        }
        if (!corpusPath.isDirectory()) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because the given file-uri '" + corpusPath + "'is not a directory .");
        }
        File analysesPath = new File(corpusPath.getAbsoluteFile() + "/analyses/");
        if (!analysesPath.exists()) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because an analyses folder does not exist for given uri:" + corpusPath + " .");
        }
        if (!analysesPath.isDirectory()) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus, because the analyses folder for :" + corpusPath + " is not a folder.");
        }
        for (File corpusResource : analysesPath.listFiles()) {
            SCorpus sCorpus = null;
            sCorpus = SaltFactory.createSCorpus();
            sCorpus.setName(corpusResource.getAbsoluteFile().getName());
            sCorpusGraph.addNode((Node)sCorpus);
            for (File documentResource : corpusResource.listFiles()) {
                SDocument sDocument = SaltFactory.createSDocument();
                sDocument.setName(documentResource.getName());
                sCorpusGraph.addNode((Node)sDocument);
                SCorpusDocumentRelation sCorpDocRel = SaltFactory.createSCorpusDocumentRelation();
                sCorpDocRel.setSource((Node)sCorpus);
                sCorpDocRel.setTarget((Node)sDocument);
                sCorpusGraph.addRelation((Relation)sCorpDocRel);
                this.getIdentifier2ResourceTable().put(sDocument.getIdentifier(), URI.createFileURI((String)documentResource.getAbsolutePath()));
            }
        }
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        UAM2SaltMapper mapper = new UAM2SaltMapper();
        mapper.setResourceOptions(this.getResourceOptions());
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResourceOptions() {
        if (this.resourceOptions == null) {
            UAMImporter uAMImporter = this;
            synchronized (uAMImporter) {
                if (this.resourceOptions == null) {
                    File path2Corpus = new File(this.getCorpusDesc().getCorpusPath().toFileString() + "/" + PATH_TO_TEXT);
                    if (!path2Corpus.exists()) {
                        throw new PepperModuleException((PepperModule)this, "Cannot import document, because path to corpus '" + path2Corpus.getAbsolutePath() + "' does not exist.");
                    }
                    this.resourceOptions = new Hashtable<String, String>();
                    this.resourceOptions.put("PATH_2_TEXT", path2Corpus.getAbsolutePath());
                }
            }
        }
        return this.resourceOptions;
    }
}

