/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.uamModules;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.model.uam.Layer;
import org.corpus_tools.peppermodules.model.uam.Segment;
import org.corpus_tools.peppermodules.model.uam.Text;
import org.corpus_tools.peppermodules.model.uam.UAMDocument;
import org.corpus_tools.peppermodules.model.uam.UAMFactory;
import org.corpus_tools.peppermodules.uam.resources.UAMResourceFactory;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UAM2SaltMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(UAM2SaltMapper.class);
    private Hashtable<Text, STextualDS> text2STextualDS = null;
    private UAMDocument uamDocument = null;
    private Map<String, String> resourceOptions = null;

    public DOCUMENT_STATUS mapSDocument() {
        Object obj;
        if (this.getResourceURI() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the given uamDocument to sDocument, because uri for UAM document is null.");
        }
        if (this.uamDocument == null) {
            this.uamDocument = UAMFactory.eINSTANCE.createUAMDocument();
        }
        if (this.getDocument() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the given uamDocument to sDocument, because sDocument is null.");
        }
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(null, new UAMResourceFactory());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("txt", new UAMResourceFactory());
        Resource resource = resourceSet.createResource(this.getResourceURI());
        if (resource == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot load the UAMDocument for path: " + this.getResourceURI() + ", becuase the resource is null.");
        }
        try {
            resource.load(this.getResourceOptions());
        }
        catch (IOException e) {
            throw new PepperModuleException((PepperMapper)this, "Cannot load the uam file: " + this.getResourceURI() + ".", (Throwable)e);
        }
        if (resource.getContents().size() != 0 && (obj = resource.getContents().get(0)) != null && obj instanceof UAMDocument) {
            UAMDocument uAMDocument = (UAMDocument)resource.getContents().get(0);
        }
        this.getDocument().setName(this.uamDocument.getName());
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        this.text2STextualDS = this.mapText2STextualDS(this.uamDocument, this.getDocument());
        if (this.uamDocument.getLayers() != null && this.uamDocument.getLayers().size() > 0) {
            for (Layer layer : this.uamDocument.getLayers()) {
                if (layer == null) continue;
                SLayer sLayer = null;
                sLayer = this.mapLayer2SLayer(layer, this.getDocument());
                if (layer.getSegments() == null || layer.getSegments().size() <= 0) continue;
                for (Segment segment : layer.getSegments()) {
                    if (segment == null) continue;
                    SToken sToken = this.mapSegments2SToken(segment, this.getDocument());
                    sToken.getLayers().add(sLayer);
                    this.mapSegment2SAnnotation(segment, (SNode)sToken);
                }
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void setResourceOptions(Map<String, String> resourceOptions) {
        this.resourceOptions = resourceOptions;
    }

    public Map<String, String> getResourceOptions() {
        return this.resourceOptions;
    }

    public Hashtable<Text, STextualDS> mapText2STextualDS(UAMDocument uamDocument, SDocument sDocument) {
        Hashtable<Text, STextualDS> text2STextualDS = null;
        if (uamDocument.getTexts() != null && uamDocument.getTexts().size() > 0) {
            text2STextualDS = new Hashtable<Text, STextualDS>();
            for (Text text : uamDocument.getTexts()) {
                STextualDS sText = SaltFactory.createSTextualDS();
                sText.setName(text.getName());
                sText.setText(text.getText());
                sDocument.getDocumentGraph().addNode((Node)sText);
                text2STextualDS.put(text, sText);
            }
        }
        return text2STextualDS;
    }

    private SLayer mapLayer2SLayer(Layer layer, SDocument sDocument) {
        SLayer sLayer = null;
        if (layer != null) {
            sLayer = SaltFactory.createSLayer();
            sLayer.setName(layer.getName());
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName("complete");
            sAnno.setValue((Object)layer.getComplete());
            sLayer.addAnnotation(sAnno);
            sAnno = SaltFactory.createSAnnotation();
            sAnno.setName("lang");
            sAnno.setValue((Object)layer.getLang());
            sLayer.addAnnotation(sAnno);
            sDocument.getDocumentGraph().addLayer((org.corpus_tools.salt.graph.Layer)sLayer);
        }
        return sLayer;
    }

    private SToken mapSegments2SToken(Segment segment, SDocument sDocument) {
        SToken sToken = null;
        if (segment != null) {
            sToken = SaltFactory.createSToken();
            sDocument.getDocumentGraph().addNode((Node)sToken);
            if (segment.getSourceText() != null) {
                STextualDS sText = this.text2STextualDS.get(segment.getSourceText());
                if (sText != null) {
                    STextualRelation sTextRel = SaltFactory.createSTextualRelation();
                    sTextRel.setSource((Node)sToken);
                    sTextRel.setTarget((Node)sText);
                    sTextRel.setStart((Number)segment.getStart());
                    sTextRel.setEnd((Number)segment.getEnd());
                    sDocument.getDocumentGraph().addRelation((Relation)sTextRel);
                }
                logger.warn("Some SToken objects exist without refering to a STextualDS in SDocument '" + sDocument.getId() + "'.");
            }
            logger.warn("Some SToken objects exist without refering to a STextualDS in SDocument '" + sDocument.getId() + "'.");
        }
        return sToken;
    }

    private void mapSegment2SAnnotation(Segment segment, SNode sNode) {
        SAnnotation sAnno = null;
        sAnno = SaltFactory.createSAnnotation();
        sAnno.setName("state");
        sAnno.setValue((Object)segment.getState());
        sNode.addAnnotation(sAnno);
        sAnno = SaltFactory.createSAnnotation();
        sAnno.setName("features");
        sAnno.setValue((Object)segment.getFeatures());
        sNode.addAnnotation(sAnno);
    }
}

