/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.uam.resources;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.peppermodules.model.uam.Layer;
import org.corpus_tools.peppermodules.model.uam.UAMDocument;
import org.corpus_tools.peppermodules.model.uam.UAMFactory;
import org.corpus_tools.peppermodules.uam.exceptions.UAMModelException;
import org.corpus_tools.peppermodules.uam.resources.UAMReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UAMResource
extends ResourceImpl {
    public static final String PROP_PATH_2_TEXT = "PATH_2_TEXT";
    private static volatile SAXParserFactory factory = null;

    public void save(Map<?, ?> options) throws IOException {
        throw new UAMModelException("We are very sorry, but the storing of an UAMModel is not yet implemented.");
    }

    public static synchronized SAXParserFactory getFactory() {
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        return factory;
    }

    public static void setFactory(SAXParserFactory factory) {
        UAMResource.factory = factory;
    }

    public void load(Map<?, ?> options) throws IOException {
        if (options.get(PROP_PATH_2_TEXT) == null || !(options.get(PROP_PATH_2_TEXT) instanceof String) || options.get(PROP_PATH_2_TEXT).equals("")) {
            throw new UAMModelException("Cannot load UAMDocument from uri '" + this.uri + "', because no path to text is set.");
        }
        if (this.getURI() == null) {
            throw new UAMModelException("Cannot load any resource, because no uri is given.");
        }
        File uamPath = new File(this.getURI().toFileString());
        if (!uamPath.exists()) {
            throw new UAMModelException("Cannot load resource, because the file does not exist: " + uamPath);
        }
        if (!uamPath.canRead()) {
            throw new UAMModelException("Cannot load resource, because the file can not be read: " + uamPath);
        }
        UAMDocument uamDocument = null;
        uamDocument = UAMFactory.eINSTANCE.createUAMDocument();
        uamDocument.setName(uamPath.getName());
        for (File uamFile : uamPath.listFiles()) {
            if (!uamFile.toString().endsWith(".xml")) continue;
            try {
                SAXParser parser = UAMResource.getFactory().newSAXParser();
                XMLReader xmlReader = parser.getXMLReader();
                String layerName = uamFile.toString().replace(".xml", "");
                String[] parts = layerName.split("/");
                if (parts.length <= 1) {
                    parts = layerName.split("\\\\");
                }
                layerName = parts[parts.length - 1];
                Layer layer = UAMFactory.eINSTANCE.createLayer();
                layer.setName(layerName);
                uamDocument.getLayers().add((Object)layer);
                File path2Text = new File((String)options.get(PROP_PATH_2_TEXT));
                UAMReader uamReader = new UAMReader();
                uamReader.setPath2Text(path2Text);
                uamReader.setUamDocument(uamDocument);
                uamReader.setCurrLayer(layer);
                uamReader.setCorpusPath(uamPath);
                uamReader.setDocumentURI(URI.createFileURI((String)uamFile.getAbsolutePath()));
                xmlReader.setContentHandler(uamReader);
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", uamReader);
                xmlReader.setContentHandler(uamReader);
                xmlReader.parse(uamFile.getAbsolutePath());
            }
            catch (ParserConfigurationException e) {
                throw new UAMModelException("Cannot load UAMDocument from resource '" + uamFile.getAbsolutePath() + "'.", e);
            }
            catch (SAXException e) {
                throw new UAMModelException("Cannot load UAMDocument from resource '" + uamFile.getAbsolutePath() + "'.", e);
            }
        }
        if (uamDocument != null) {
            this.getContents().add((Object)uamDocument);
        }
    }
}

