/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.uam.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import org.corpus_tools.peppermodules.model.uam.Layer;
import org.corpus_tools.peppermodules.model.uam.Segment;
import org.corpus_tools.peppermodules.model.uam.Text;
import org.corpus_tools.peppermodules.model.uam.UAMDocument;
import org.corpus_tools.peppermodules.model.uam.UAMFactory;
import org.corpus_tools.peppermodules.uam.exceptions.UAMModelException;
import org.corpus_tools.peppermodules.uam.exceptions.UAMResourceException;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class UAMReader
extends DefaultHandler2 {
    private Logger logger = LoggerFactory.getLogger(UAMReader.class);
    private UAMDocument uamDocument = null;
    private URI documentURI = null;
    private Layer currLayer = null;
    private File path2Text = null;
    private File corpusPath = null;
    private Stack<String> currXMLElementName = null;
    private Text currText = null;
    public static final String XML_ELEMENT_SEGMENT = "segment";
    public static final String XML_ELEMENT_TEXTFILE = "textfile";
    public static final String XML_ATTRIBUTE_SEGMENT_ID = "id";
    public static final String XML_ATTRIBUTE_SEGMENT_FEATURE = "features";
    public static final String XML_ATTRIBUTE_SEGMENT_START = "start";
    public static final String XML_ATTRIBUTE_SEGMENT_END = "end";
    public static final String XML_ATTRIBUTE_SEGMENT_STATE = "state";
    private boolean isTextFile = false;

    public void setUamDocument(UAMDocument uamDocument) {
        this.uamDocument = uamDocument;
    }

    public UAMDocument getUamDocument() {
        return this.uamDocument;
    }

    public URI getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(URI documentURI) {
        this.documentURI = documentURI;
    }

    public Layer getCurrLayer() {
        return this.currLayer;
    }

    public void setCurrLayer(Layer currLayer) {
        this.currLayer = currLayer;
    }

    public File getPath2Text() {
        return this.path2Text;
    }

    public void setPath2Text(File path2Text) {
        this.path2Text = path2Text;
    }

    public File getCorpusPath() {
        return this.corpusPath;
    }

    public void setCorpusPath(File corpusPath) {
        this.corpusPath = corpusPath;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isTextFile) {
            StringBuffer text = new StringBuffer();
            for (int i = start; i < start + length; ++i) {
                text.append(ch[i]);
            }
            String[] parts = text.toString().trim().split("/");
            String textFileName = parts[parts.length - 1];
            textFileName = text.toString();
            if (textFileName == null || textFileName.equals("")) {
                throw new UAMModelException("Cannot read UAMDocument, because path to textfile is corrupt: " + text + ".");
            }
            parts = textFileName.split("[.]");
            String textName = parts[parts.length - 1];
            if (textName == null || textName.equals("")) {
                throw new UAMModelException("Cannot read UAMDocument, because path to textfile is corrupt: " + text + ".");
            }
            boolean alreadyContainsText = false;
            if (this.getUamDocument().getTexts() != null && this.getUamDocument().getTexts().size() > 0) {
                for (Text uamText : this.getUamDocument().getTexts()) {
                    if (!uamText.getName().equals(textName)) continue;
                    alreadyContainsText = true;
                    this.currText = uamText;
                    break;
                }
            }
            if (!alreadyContainsText) {
                File textFile = new File(this.getPath2Text().getAbsolutePath() + "/" + textFileName);
                if (!textFile.exists()) {
                    throw new UAMResourceException("Cannot read primary data ('" + textFile.getAbsolutePath() + "') refered by file: ");
                }
                StringBuffer contents = new StringBuffer();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(textFile));
                    String inputText = null;
                    while ((inputText = reader.readLine()) != null) {
                        contents.append(inputText).append(System.getProperty("line.separator"));
                    }
                }
                catch (FileNotFoundException e) {
                    throw new UAMModelException("", e);
                }
                catch (IOException e) {
                    throw new UAMModelException("", e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UAMModelException("", e);
                    }
                }
                Text uamText = UAMFactory.eINSTANCE.createText();
                uamText.setText(contents.toString());
                uamText.setName(textName);
                this.getUamDocument().getTexts().add((Object)uamText);
                this.currText = uamText;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stack<String> getCurrXMLElementName() {
        if (this.currXMLElementName == null) {
            UAMReader uAMReader = this;
            synchronized (uAMReader) {
                if (this.currXMLElementName == null) {
                    this.currXMLElementName = new Stack();
                }
            }
        }
        return this.currXMLElementName;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(XML_ELEMENT_TEXTFILE)) {
            this.isTextFile = true;
        } else if (qName.equalsIgnoreCase(XML_ELEMENT_SEGMENT)) {
            Segment segment = UAMFactory.eINSTANCE.createSegment();
            this.getCurrLayer().getSegments().add((Object)segment);
            if (this.currText == null) {
                throw new UAMResourceException("Cannot set the corresponding text to segment, because it is null.");
            }
            segment.setSourceText(this.currText);
            segment.setId(attributes.getValue(XML_ATTRIBUTE_SEGMENT_ID));
            segment.setFeatures(attributes.getValue(XML_ATTRIBUTE_SEGMENT_FEATURE));
            segment.setState(attributes.getValue(XML_ATTRIBUTE_SEGMENT_STATE));
            try {
                segment.setStart(new Integer(attributes.getValue(XML_ATTRIBUTE_SEGMENT_START)));
                segment.setEnd(new Integer(attributes.getValue(XML_ATTRIBUTE_SEGMENT_END)));
                if (segment.getEnd() < segment.getStart()) {
                    int tmpStart = segment.getStart();
                    segment.setStart(segment.getEnd());
                    segment.setEnd(tmpStart);
                }
                if (segment.getEnd() >= this.currText.getText().length()) {
                    segment.setEnd(this.currText.getText().length());
                }
                this.logger.warn("The end of a 'segment' in file '" + this.getDocumentURI() + "' is bigger than the max. size of the text (" + this.currText.getText().length() + "). Therefore the end of the segment was cutted at end of the text. ");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.getCurrXMLElementName().push(qName);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.getCurrXMLElementName().peek().equalsIgnoreCase(qName)) {
            throw new UAMResourceException("The given file is not wellformed. Expected element is: " + this.getCurrXMLElementName().peek() + ", but given is: " + qName);
        }
        if (qName.equalsIgnoreCase(XML_ELEMENT_TEXTFILE)) {
            this.isTextFile = false;
        }
        this.getCurrXMLElementName().pop();
    }
}

