/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.gateModules;

import com.google.common.io.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.peppermodules.gateModules.GateImporter;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GateMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(GateImporter.class);
    protected String text = "";
    STextualDS sText = null;
    Map<Integer, SToken> tokenIDs = new HashMap<Integer, SToken>();
    List<Integer> nodeIDs = new ArrayList<Integer>();
    public static final String TextWithNodes_TAG = "TextWithNodes";
    public static final String AnnotationSet_TAG = "AnnotationSet";
    public static final String Annotation_TAG = "Annotation";
    public static final String Name_TAG = "Name";
    public static final String Type_TAG = "Type";
    public static final String StartNode_TAG = "StartNode";
    public static final String EndNode_TAG = "EndNode";
    public static final String GateDocument_TAG = "GateDocument";
    public static final String Node_TAG = "Node";
    public static final String Value_TAG = "Value";
    public static final String GateDocumentFeatures_TAG = "GateDocumentFeatures";
    public static final String Feature_TAG = "Feature";

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public InputSource getInputSource(Reader reader, String encoding) {
        InputSource is = new InputSource(reader);
        is.setEncoding(encoding);
        return is;
    }

    public InputSource getInputSource(String fttext, String encoding) {
        InputSource is = new InputSource(new StringReader(fttext));
        is.setEncoding(encoding);
        return is;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        URI resource = this.getResourceURI();
        logger.debug("Importing the file {}.", (Object)resource);
        String encoding = "UTF-8";
        File file = new File(resource.toFileString());
        final long fileSize = file.length();
        try (final CountingInputStream inputStream = new CountingInputStream((InputStream)new FileInputStream(file));){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                boolean btext = false;
                boolean bas = false;
                boolean bname = false;
                boolean bvalue = false;
                boolean bgatedocfeat = false;
                boolean banno = false;
                String as_name = "";
                String nodeID = "";
                int a_start = -1;
                int a_end = -1;
                String a_name = "";
                String name = "";
                String value = "";
                List<String> featurepairs = new ArrayList<String>();

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (GateMapper.TextWithNodes_TAG.equals(qName)) {
                        this.btext = true;
                    } else if (GateMapper.AnnotationSet_TAG.equals(qName)) {
                        this.bas = true;
                        if (attributes.getLength() > 0) {
                            if (GateMapper.Name_TAG.equals(attributes.getQName(0))) {
                                this.as_name = attributes.getValue(0);
                            }
                        } else {
                            this.as_name = "Default";
                        }
                    } else if (GateMapper.Annotation_TAG.equals(qName)) {
                        this.banno = true;
                        for (int i = 0; i < attributes.getLength(); i = (int)((short)(i + 1))) {
                            if (GateMapper.Type_TAG.equals(attributes.getQName(i))) {
                                this.a_name = attributes.getValue(i);
                                continue;
                            }
                            if (GateMapper.StartNode_TAG.equals(attributes.getQName(i))) {
                                try {
                                    this.a_start = Integer.parseInt(attributes.getValue(i).trim());
                                }
                                catch (NumberFormatException e) {
                                    logger.error("NumberFormatException in Annotation {} at: {}", (Object)this.a_name, (Object)attributes.getValue(i));
                                }
                                continue;
                            }
                            if (!GateMapper.EndNode_TAG.equals(attributes.getQName(i))) continue;
                            try {
                                this.a_end = Integer.parseInt(attributes.getValue(i).trim());
                                continue;
                            }
                            catch (NumberFormatException e) {
                                logger.error("NumberFormatException in Annotation {} at: {}", (Object)this.a_name, (Object)attributes.getValue(i));
                            }
                        }
                    } else if (GateMapper.GateDocument_TAG.equals(qName)) {
                        if ("version".equals(attributes.getQName(0)) && !("3".equals(attributes.getValue(0)) | "2".equals(attributes.getValue(0)))) {
                            logger.warn("This Importer covers GATE_Document Version 2 and 3. Anyway still trying...");
                        }
                    } else if (GateMapper.Node_TAG.equals(qName)) {
                        if (attributes.getLength() > 0) {
                            this.nodeID = attributes.getValue(0).trim();
                        } else {
                            logger.error("Node {} has no attribute", (Object)this.nodeID);
                        }
                        try {
                            GateMapper.this.nodeIDs.add(Integer.parseInt(this.nodeID));
                        }
                        catch (NumberFormatException e) {
                            logger.error("NumberFormatException at Node: {}", (Object)attributes.getValue(0));
                        }
                    } else if (GateMapper.Name_TAG.equals(qName)) {
                        if (this.banno | this.bgatedocfeat) {
                            this.bname = true;
                        }
                    } else if (GateMapper.Value_TAG.equals(qName)) {
                        if (this.banno | this.bgatedocfeat) {
                            this.bvalue = true;
                        }
                    } else if (GateMapper.GateDocumentFeatures_TAG.equals(qName)) {
                        this.bgatedocfeat = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (GateMapper.TextWithNodes_TAG.equals(qName)) {
                        this.btext = false;
                        GateMapper.this.sText = GateMapper.this.getDocument().getDocumentGraph().createTextualDS(GateMapper.this.text);
                        GateMapper.this.text = null;
                        int pos = -1;
                        for (Integer nodeID : GateMapper.this.nodeIDs) {
                            int act_val = nodeID;
                            if (pos > -1) {
                                SToken token = GateMapper.this.getDocument().getDocumentGraph().createToken((SSequentialDS)GateMapper.this.sText, Integer.valueOf(pos), Integer.valueOf(act_val));
                                GateMapper.this.tokenIDs.put(pos, token);
                            }
                            pos = act_val;
                        }
                    } else if (GateMapper.AnnotationSet_TAG.equals(qName)) {
                        this.bas = false;
                    } else if (GateMapper.Annotation_TAG.equals(qName)) {
                        ArrayList<SToken> token_set = new ArrayList<SToken>();
                        for (Integer ele : GateMapper.this.nodeIDs) {
                            if (ele >= this.a_start & ele <= this.a_end && GateMapper.this.tokenIDs.containsKey(ele)) {
                                token_set.add(GateMapper.this.tokenIDs.get(ele));
                            }
                            if (ele <= this.a_end) continue;
                            break;
                        }
                        String afeatures = "";
                        if (this.featurepairs.isEmpty()) {
                            afeatures = this.a_name;
                        } else {
                            for (String ele : this.featurepairs) {
                                String tvalue = ele.split("#\\+#")[1];
                                afeatures = afeatures + tvalue + ",";
                            }
                            afeatures = afeatures.substring(0, afeatures.length() - 1);
                        }
                        if (token_set.size() > 0) {
                            SSpan topic = GateMapper.this.getDocument().getDocumentGraph().createSpan(token_set);
                            topic.createAnnotation(null, this.a_name, (Object)afeatures);
                        }
                        this.name = "";
                        this.value = "";
                        this.featurepairs.clear();
                        this.banno = false;
                    } else if (GateMapper.Feature_TAG.equals(qName)) {
                        if (this.name != "" & this.value != "") {
                            if (this.bgatedocfeat) {
                                if (!"gate.SourceURL".equals(this.name)) {
                                    GateMapper.this.getDocument().createMetaAnnotation(null, this.name, (Object)this.value);
                                }
                            } else {
                                this.featurepairs.add(this.name + "#+#" + this.value);
                            }
                            this.name = "";
                            this.value = "";
                        }
                    } else if (GateMapper.GateDocumentFeatures_TAG.equals(qName)) {
                        this.bgatedocfeat = false;
                    }
                    GateMapper.this.setProgress((double)inputStream.getCount() / (double)fileSize);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.btext) {
                        GateMapper.this.text = GateMapper.this.text + new String(ch, start, length);
                    } else if (this.bas | this.bgatedocfeat) {
                        if (this.bname) {
                            this.bname = false;
                            this.name = new String(ch, start, length);
                        } else if (this.bvalue) {
                            this.bvalue = false;
                            this.value = new String(ch, start, length);
                        }
                    }
                }
            };
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);
            InputSource is = this.getInputSource(reader, encoding);
            saxParser.parse(is, handler);
        }
        catch (Exception e) {
            logger.error("XML-Parser Error: ", (Throwable)e);
        }
        this.setProgress(1.0);
        return DOCUMENT_STATUS.COMPLETED;
    }
}

