/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.PTBModules;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.PTBModules.PTBExporterProperties;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class PTBExporterMapper
extends PepperMapperImpl
implements GraphTraverseHandler {
    public StringBuilder stbOutput = new StringBuilder();
    private String strNamespace;
    private String strPosName;
    private String strCatName;
    private String strRelationAnnoSeparator;
    private String strRelationAnnoName;
    private Boolean bolRelationAnnos;
    private Boolean bolHandleSlashTokens;

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() != null && this.getDocument().getDocumentGraph() != null) {
            this.getSettings();
            this.getDocument().getDocumentGraph().traverse(this.getDocument().getDocumentGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "TraverseTrees", (GraphTraverseHandler)this);
            File outputFile = null;
            outputFile = this.getResourceURI().toFileString() != null ? new File(this.getResourceURI().toFileString()) : new File(this.getResourceURI().toString());
            if (!outputFile.isDirectory() && !outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            FileWriter flwTemp = null;
            try {
                flwTemp = new FileWriter(outputFile);
                flwTemp.write(this.stbOutput.toString());
                flwTemp.flush();
            }
            catch (IOException e) {
                throw new PepperModuleException((PepperMapper)this, "Unable to write output file for PTB export '" + this.getResourceURI() + "'.", (Throwable)e);
            }
            finally {
                try {
                    if (flwTemp != null) {
                        flwTemp.close();
                    }
                }
                catch (IOException e) {
                    throw new PepperModuleException((PepperMapper)this, "Unable to close output file writer for PTB export '" + this.getResourceURI() + "'.", (Throwable)e);
                }
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE trvTraverseType, String strTraverseName, SRelation relCurrentRelation, SNode nodCurrentNode, long lngChildNumber) {
        boolean bolFoundNamespace = false;
        if (relCurrentRelation != null) {
            if (!(relCurrentRelation instanceof SDominanceRelation)) return false;
        }
        if (this.strNamespace == null) return true;
        if (this.strNamespace.isEmpty()) return true;
        Iterator i$ = nodCurrentNode.getLayers().iterator();
        while (i$.hasNext()) {
            SLayer sLayer = (SLayer)i$.next();
            if (sLayer.getName().equals(this.strNamespace)) {
                return true;
            }
            bolFoundNamespace = false;
        }
        return bolFoundNamespace;
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE trvTraverseType, String strTraverseName, SNode nodCurrentNode, SRelation relCurrentRelation, SNode nodPrevNode, long lngChildNumber) {
        if (!(nodCurrentNode instanceof SToken)) {
            this.stbOutput.append(") ");
        }
        if (relCurrentRelation == null) {
            this.stbOutput.append("\n");
        }
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE trvTraverseType, String strTraverseName, SNode nodCurrentNode, SRelation relCurrentRelation, SNode nodPrevNode, long lngChildNumber) {
        if (nodCurrentNode instanceof SToken) {
            String strTokenOut = ((SToken)nodCurrentNode).getGraph().getText(nodCurrentNode);
            if (nodCurrentNode.getAnnotation(this.strPosName) != null) {
                String strAnnoOut = nodCurrentNode.getAnnotation(this.strPosName).getValue_STEXT();
                if (!this.bolHandleSlashTokens.booleanValue()) {
                    this.stbOutput.append(" (" + strAnnoOut + " " + strTokenOut + ") ");
                } else {
                    this.stbOutput.append(" " + strTokenOut + "/" + strAnnoOut + " ");
                }
            } else {
                this.stbOutput.append("( " + strTokenOut + " )");
            }
        } else if (nodCurrentNode.getAnnotation(this.strCatName) != null) {
            String strAnnoOut = nodCurrentNode.getAnnotation(this.strCatName).getValue_STEXT();
            if (this.bolRelationAnnos.booleanValue() && relCurrentRelation.getAnnotation(this.strRelationAnnoName) != null) {
                strAnnoOut = strAnnoOut + this.strRelationAnnoSeparator + relCurrentRelation.getAnnotation(this.strRelationAnnoName).getValue_STEXT();
            }
            this.stbOutput.append(" (" + strAnnoOut);
        }
    }

    private void getSettings() {
        this.strNamespace = ((PTBExporterProperties)this.getProperties()).getNodeNamespace();
        this.strPosName = ((PTBExporterProperties)this.getProperties()).getPosName();
        this.strCatName = ((PTBExporterProperties)this.getProperties()).getCatName();
        this.strRelationAnnoSeparator = ((PTBExporterProperties)this.getProperties()).getRelationAnnoSeparator();
        this.strRelationAnnoName = ((PTBExporterProperties)this.getProperties()).getRelationAnnoName();
        this.bolRelationAnnos = ((PTBExporterProperties)this.getProperties()).getImportRelationAnnos();
        this.bolHandleSlashTokens = ((PTBExporterProperties)this.getProperties()).getHandleSlashTokens();
    }
}

