/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.samples;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import java.net.URI;

public class Tiger2Sample {
    public static Corpus createSampleCorpus1() {
        Corpus corpus = Tiger2Factory.eINSTANCE.createCorpus();
        corpus.setMeta(Tiger2Factory.eINSTANCE.createMeta());
        corpus.getMeta().setName("sampleCorpus1");
        corpus.getMeta().setAuthor("author1");
        corpus.getMeta().setDate("1 January 2010");
        corpus.getMeta().setDescription("some Description");
        corpus.getMeta().setFormat("format 01");
        corpus.getMeta().setHistory("any history");
        Segment segment = Tiger2Factory.eINSTANCE.createSegment();
        corpus.getSegments().add((Object)segment);
        Graph graph = Tiger2Factory.eINSTANCE.createGraph();
        segment.getGraphs().add((Object)graph);
        Feature lemmaFeat = Tiger2Factory.eINSTANCE.createFeature();
        lemmaFeat.setName("lemma");
        lemmaFeat.setDomain(DOMAIN.T);
        corpus.getFeatures().add((Object)lemmaFeat);
        Feature posFeat = Tiger2Factory.eINSTANCE.createFeature();
        posFeat.setName("pos");
        posFeat.setDomain(DOMAIN.T);
        corpus.getFeatures().add((Object)posFeat);
        FeatureValue pos_Punc = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_Punc.setValue(".");
        pos_Punc.setDescription("Punctuation");
        pos_Punc.setFeature(posFeat);
        FeatureValue pos_JJ = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_JJ.setValue("JJ");
        pos_JJ.setDescription("Adjective");
        pos_JJ.setFeature(posFeat);
        FeatureValue pos_NN = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_NN.setValue("NN");
        pos_NN.setDescription("Noun, singular or mass");
        pos_NN.setDcrReference(URI.create("http://www.isocat.org/datcat/DC-1230"));
        pos_NN.setFeature(posFeat);
        FeatureValue pos_PP = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_PP.setValue("PP");
        pos_PP.setDescription("Personal pronoun");
        pos_PP.setFeature(posFeat);
        FeatureValue pos_RP = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_RP.setValue("RP");
        pos_RP.setDescription("Particle");
        pos_RP.setFeature(posFeat);
        FeatureValue pos_VB = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_VB.setValue("VB");
        pos_VB.setDescription("Verb, base form");
        pos_VB.setFeature(posFeat);
        FeatureValue pos_VBP = Tiger2Factory.eINSTANCE.createFeatureValue();
        pos_VBP.setValue("VBP");
        pos_VBP.setDescription("Verb, non-3rd person singular present");
        pos_VBP.setFeature(posFeat);
        Feature functionFeat = Tiger2Factory.eINSTANCE.createFeature();
        functionFeat.setName("function");
        functionFeat.setDomain(DOMAIN.T);
        functionFeat.setType("PRO");
        corpus.getFeatures().add((Object)functionFeat);
        FeatureValue func_SC = Tiger2Factory.eINSTANCE.createFeatureValue();
        func_SC.setValue("SC");
        func_SC.setDescription("Verb, base form");
        func_SC.setFeature(functionFeat);
        Feature labelFeatCoref = Tiger2Factory.eINSTANCE.createFeature();
        labelFeatCoref.setName("label");
        labelFeatCoref.setDomain(DOMAIN.EDGE);
        labelFeatCoref.setType("coref");
        corpus.getFeatures().add((Object)labelFeatCoref);
        FeatureValue labelCoref_ANA = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelCoref_ANA.setValue("anaphoric");
        labelCoref_ANA.setDescription("Anaphoric Link");
        labelCoref_ANA.setFeature(labelFeatCoref);
        Feature labelFeatPrim = Tiger2Factory.eINSTANCE.createFeature();
        labelFeatPrim.setName("label");
        labelFeatPrim.setDomain(DOMAIN.EDGE);
        labelFeatPrim.setType("prim");
        corpus.getFeatures().add((Object)labelFeatPrim);
        FeatureValue labelPrim_AT = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelPrim_AT.setValue("AT");
        labelPrim_AT.setDescription("Attribute");
        labelPrim_AT.setFeature(labelFeatPrim);
        FeatureValue labelPrim_DO = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelPrim_DO.setValue("DO");
        labelPrim_DO.setDescription("Direct Object");
        labelPrim_DO.setFeature(labelFeatPrim);
        FeatureValue labelPrim_HD = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelPrim_HD.setValue("HD");
        labelPrim_HD.setDescription("Head");
        labelPrim_HD.setFeature(labelFeatPrim);
        FeatureValue labelPrim_IO = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelPrim_IO.setValue("IO");
        labelPrim_IO.setDescription("Infinitive");
        labelPrim_IO.setFeature(labelFeatPrim);
        FeatureValue labelPrim_SB = Tiger2Factory.eINSTANCE.createFeatureValue();
        labelPrim_SB.setValue("SB");
        labelPrim_SB.setDescription("Subject");
        labelPrim_SB.setFeature(labelFeatPrim);
        Feature catFeat = Tiger2Factory.eINSTANCE.createFeature();
        catFeat.setName("cat");
        catFeat.setDomain(DOMAIN.T);
        corpus.getFeatures().add((Object)catFeat);
        FeatureValue cat_NP = Tiger2Factory.eINSTANCE.createFeatureValue();
        cat_NP.setValue("NP");
        cat_NP.setDescription("Nominal Phrase");
        cat_NP.setFeature(catFeat);
        FeatureValue cat_S = Tiger2Factory.eINSTANCE.createFeatureValue();
        cat_S.setValue("S");
        cat_S.setDescription("Sentence or Clause");
        cat_S.setFeature(catFeat);
        FeatureValue cat_VP = Tiger2Factory.eINSTANCE.createFeatureValue();
        cat_VP.setValue("VP");
        cat_VP.setDescription("Verbal Phrase");
        cat_VP.setFeature(catFeat);
        FeatureValue cat_ROOT = Tiger2Factory.eINSTANCE.createFeatureValue();
        cat_ROOT.setValue("ROOT");
        cat_ROOT.setDescription("Graph Root");
        cat_ROOT.setFeature(catFeat);
        Annotation annotation = null;
        Terminal t1 = Tiger2Factory.eINSTANCE.createTerminal();
        t1.setId("s1_t1");
        t1.setWord("I");
        graph.getSyntacticNodes().add((Object)t1);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("I");
        t1.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_PP);
        t1.getAnnotations().add((Object)annotation);
        Terminal t2 = Tiger2Factory.eINSTANCE.createTerminal();
        t2.setId("s1_t2");
        t2.setWord("wanna");
        graph.getSyntacticNodes().add((Object)t2);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("wanna");
        t2.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_VBP);
        t2.getAnnotations().add((Object)annotation);
        Terminal t3 = Tiger2Factory.eINSTANCE.createTerminal();
        t3.setId("s1_t3");
        t3.setType("PRO");
        graph.getSyntacticNodes().add((Object)t3);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(functionFeat);
        annotation.setFeatureValueRef(func_SC);
        t3.getAnnotations().add((Object)annotation);
        Terminal t4 = Tiger2Factory.eINSTANCE.createTerminal();
        t4.setId("s1_t4");
        t4.setWord("put");
        graph.getSyntacticNodes().add((Object)t4);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("put");
        t4.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_VB);
        t4.getAnnotations().add((Object)annotation);
        Terminal t5 = Tiger2Factory.eINSTANCE.createTerminal();
        t5.setId("s1_t5");
        graph.getSyntacticNodes().add((Object)t5);
        t5.setWord("up");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("up");
        t5.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_RP);
        t5.getAnnotations().add((Object)annotation);
        Terminal t6 = Tiger2Factory.eINSTANCE.createTerminal();
        t6.setId("s1_t6");
        t6.setWord("new");
        graph.getSyntacticNodes().add((Object)t6);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("new");
        t6.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_JJ);
        t6.getAnnotations().add((Object)annotation);
        Terminal t7 = Tiger2Factory.eINSTANCE.createTerminal();
        t7.setId("s1_t7");
        t7.setWord("wallpaper");
        graph.getSyntacticNodes().add((Object)t7);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue("wallpaper");
        t7.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_NN);
        t7.getAnnotations().add((Object)annotation);
        Terminal t8 = Tiger2Factory.eINSTANCE.createTerminal();
        t8.setId("s1_t8");
        t8.setWord(".");
        graph.getSyntacticNodes().add((Object)t8);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(lemmaFeat);
        annotation.setValue(".");
        t8.getAnnotations().add((Object)annotation);
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(posFeat);
        annotation.setFeatureValueRef(pos_Punc);
        t8.getAnnotations().add((Object)annotation);
        NonTerminal nt1 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt1.setId("s1_nt1");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_NP);
        nt1.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt1);
        NonTerminal nt2 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt2.setId("s1_nt2");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_VP);
        nt2.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt2);
        NonTerminal nt3 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt3.setId("s1_nt3");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_VP);
        nt3.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt3);
        NonTerminal nt4 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt4.setId("s1_nt4");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_NP);
        nt4.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt4);
        NonTerminal nt5 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt5.setId("s1_nt5");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_S);
        nt5.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt5);
        NonTerminal nt6 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt6.setId("s1_nt6");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_S);
        nt6.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt6);
        NonTerminal nt7 = Tiger2Factory.eINSTANCE.createNonTerminal();
        nt7.setId("s1_ROOT");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(catFeat);
        annotation.setFeatureValueRef(cat_ROOT);
        nt7.getAnnotations().add((Object)annotation);
        graph.getSyntacticNodes().add((Object)nt7);
        Edge edge1 = Tiger2Factory.eINSTANCE.createEdge();
        edge1.setSource(t3);
        edge1.setTarget(t1);
        edge1.setType("coref");
        edge1.setId("edge1");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatCoref);
        annotation.setFeatureValueRef(labelCoref_ANA);
        edge1.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge1);
        Edge edge2 = Tiger2Factory.eINSTANCE.createEdge();
        edge2.setSource(nt1);
        edge2.setTarget(t1);
        edge2.setType("prim");
        edge2.setId("edge2");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_HD);
        edge2.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge2);
        Edge edge3 = Tiger2Factory.eINSTANCE.createEdge();
        edge3.setSource(nt2);
        edge3.setTarget(t2);
        edge3.setType("prim");
        edge3.setId("edge3");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_HD);
        edge3.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge3);
        Edge edge4 = Tiger2Factory.eINSTANCE.createEdge();
        edge4.setSource(nt2);
        edge4.setTarget(nt5);
        edge4.setType("prim");
        edge4.setId("edge4");
        graph.getEdges().add((Object)edge4);
        Edge edge5 = Tiger2Factory.eINSTANCE.createEdge();
        edge5.setSource(nt3);
        edge5.setTarget(t4);
        edge5.setType("prim");
        edge5.setId("edge5");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_HD);
        edge5.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge5);
        Edge edge6 = Tiger2Factory.eINSTANCE.createEdge();
        edge6.setSource(nt3);
        edge6.setTarget(t5);
        edge6.setType("prim");
        edge6.setId("edge6");
        graph.getEdges().add((Object)edge6);
        Edge edge7 = Tiger2Factory.eINSTANCE.createEdge();
        edge7.setSource(nt3);
        edge7.setTarget(nt4);
        edge7.setType("prim");
        edge7.setId("edge7");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_DO);
        edge7.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge7);
        Edge edge8 = Tiger2Factory.eINSTANCE.createEdge();
        edge8.setSource(nt4);
        edge8.setTarget(t6);
        edge8.setType("prim");
        edge8.setId("edge8");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_AT);
        edge8.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge8);
        Edge edge9 = Tiger2Factory.eINSTANCE.createEdge();
        edge9.setSource(nt4);
        edge9.setTarget(t7);
        edge9.setType("prim");
        edge9.setId("edge9");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_HD);
        edge9.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge9);
        Edge edge10 = Tiger2Factory.eINSTANCE.createEdge();
        edge10.setSource(nt5);
        edge10.setTarget(t3);
        edge10.setType("prim");
        edge10.setId("edge10");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_SB);
        edge10.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge10);
        Edge edge11 = Tiger2Factory.eINSTANCE.createEdge();
        edge11.setSource(nt5);
        edge11.setTarget(t1);
        edge11.setType("prim");
        edge11.setId("edge11");
        graph.getEdges().add((Object)edge11);
        Edge edge12 = Tiger2Factory.eINSTANCE.createEdge();
        edge12.setSource(nt6);
        edge12.setTarget(t1);
        edge12.setType("prim");
        edge12.setId("edge12");
        annotation = Tiger2Factory.eINSTANCE.createAnnotation();
        annotation.setFeatureRef(labelFeatPrim);
        annotation.setFeatureValueRef(labelPrim_SB);
        edge12.getAnnotations().add((Object)annotation);
        graph.getEdges().add((Object)edge12);
        Edge edge13 = Tiger2Factory.eINSTANCE.createEdge();
        edge13.setSource(nt6);
        edge13.setTarget(nt2);
        edge13.setType("prim");
        edge13.setId("edge13");
        graph.getEdges().add((Object)edge13);
        Edge edge14 = Tiger2Factory.eINSTANCE.createEdge();
        edge14.setSource(nt7);
        edge14.setTarget(nt1);
        edge14.setType("prim");
        edge14.setId("edge14");
        graph.getEdges().add((Object)edge14);
        Edge edge15 = Tiger2Factory.eINSTANCE.createEdge();
        edge15.setSource(nt7);
        edge15.setTarget(t8);
        edge15.setType("prim");
        edge15.setId("edge15");
        graph.getEdges().add((Object)edge15);
        return corpus;
    }
}

