/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tigerXML;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DEFAULT_TYPE;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.SyntacticNode;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInvalidModelException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class TigerXMLWriter {
    private Corpus corpus = null;
    private URI outputURI = null;
    protected PrintWriter output = null;
    public static final String NS_ALIAS_TIGER2 = "tiger2";

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setOutputURI(URI inputURI) {
        this.outputURI = inputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public void save() {
        if (this.getOutputURI() == null) {
            throw new TigerInternalException("Cannot save the 'Corpus' object, because no output uri was given.");
        }
        try {
            File tiger2out = new File(this.getOutputURI().toFileString());
            tiger2out.getParentFile().mkdirs();
            try {
                this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tiger2out), "UTF8")), false);
            }
            catch (UnsupportedEncodingException e) {
                throw new TigerResourceException("Cannot open stream for writing 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
            }
            catch (FileNotFoundException e) {
                throw new TigerResourceException("Cannot open stream for writing 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
            }
            this.saveSuperCorpus(this.getCorpus());
        }
        catch (Exception e) {
            if (e instanceof TigerException) {
                throw (TigerException)e;
            }
            throw new TigerException("An unknown exception occurs while saving 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
        }
        finally {
            if (this.output != null) {
                this.output.close();
            }
        }
    }

    protected void saveSuperCorpus(Corpus corpus) {
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.output.print("<corpus ");
        String idVal = null;
        idVal = corpus.getId() != null && !corpus.getId().isEmpty() ? corpus.getId() : "NOT_SET";
        this.output.print("id=\"" + idVal + "\"");
        this.output.println(">");
        this.output.println("<head>");
        if (corpus.getMeta() != null) {
            this.saveMeta(corpus.getMeta());
        }
        if (corpus.getFeatures() != null) {
            this.output.println("<annotation>");
            this.saveFeatures(corpus.getFeatures());
            this.output.println("</annotation>");
        }
        this.output.println("</head>");
        if (corpus.getSubCorpora() != null && corpus.getSubCorpora().size() > 0) {
            for (Corpus subCorpus : corpus.getSubCorpora()) {
                this.saveSubCorpus(subCorpus);
            }
        }
        this.saveBody(corpus.getSegments());
        this.output.println("</corpus>");
    }

    protected void saveSubCorpus(Corpus corpus) {
        this.output.println("<subcorpus id=\"" + corpus.getId() + "\">");
        if (corpus.getMeta() != null) {
            this.saveMeta(corpus.getMeta());
        }
        if (corpus.getSubCorpora() != null && corpus.getSubCorpora().size() > 0) {
            for (Corpus subCorpus : corpus.getSubCorpora()) {
                this.saveSubCorpus(subCorpus);
            }
        }
        this.saveBody(corpus.getSegments());
        this.output.println("</subcorpus>");
    }

    protected void saveMeta(Meta meta) {
        this.output.println("<meta>");
        if (meta.getName() != null && !meta.getName().isEmpty()) {
            this.output.println("<name>" + meta.getName() + "</" + "name" + ">");
        }
        if (meta.getAuthor() != null && !meta.getAuthor().isEmpty()) {
            this.output.println("<author>" + meta.getAuthor() + "</" + "author" + ">");
        }
        if (meta.getDate() != null && !meta.getDate().isEmpty()) {
            this.output.println("<date>" + meta.getDate() + "</" + "date" + ">");
        }
        if (meta.getDescription() != null && !meta.getDescription().isEmpty()) {
            this.output.println("<description>" + meta.getDescription() + "</" + "description" + ">");
        }
        if (meta.getFormat() != null && !meta.getFormat().isEmpty()) {
            this.output.println("<format>" + meta.getFormat() + "</" + "format" + ">");
        }
        if (meta.getHistory() != null && !meta.getHistory().isEmpty()) {
            this.output.println("<history>" + meta.getHistory() + "</" + "history" + ">");
        }
        this.output.println("</meta>");
    }

    protected void saveFeatures(EList<Feature> features) {
        if (features != null) {
            StringBuffer edgeLabel = null;
            StringBuffer secedgeLabel = null;
            for (Feature feature : features) {
                if (DOMAIN.EDGE.equals((Object)feature.getDomain())) {
                    String featureXMLElement = "feature".toString();
                    StringBuffer currentBuffer = null;
                    if (DEFAULT_TYPE.EDGE.getLiteral().equals(feature.getType()) || DEFAULT_TYPE.PRIM.getLiteral().equals(feature.getType())) {
                        edgeLabel = new StringBuffer();
                        featureXMLElement = "edgelabel".toString();
                        currentBuffer = edgeLabel;
                    } else if (DEFAULT_TYPE.SECEDGE.getLiteral().equals(feature.getType())) {
                        currentBuffer = secedgeLabel = new StringBuffer();
                        featureXMLElement = "secedgelabel".toString();
                    } else {
                        currentBuffer = secedgeLabel = new StringBuffer();
                        featureXMLElement = "secedgelabel".toString();
                    }
                    if (feature.getFeatureValues() != null || feature.getFeatureValues().size() > 0) {
                        currentBuffer.append("<" + featureXMLElement.toString());
                        currentBuffer.append(">");
                        currentBuffer.append("\n");
                        this.saveFeaturesValues(currentBuffer, feature.getFeatureValues());
                        currentBuffer.append("</" + featureXMLElement + ">");
                        continue;
                    }
                    this.output.println(">");
                    continue;
                }
                this.output.print("<" + "feature".toString());
                if (feature.getId() != null) {
                    this.output.print(" id=\"" + feature.getId() + "\"");
                }
                if (feature.getName() != null) {
                    this.output.print(" name=\"" + feature.getName() + "\"");
                }
                if (feature.getDomain() != null) {
                    this.output.print(" domain=\"" + feature.getDomain().getName() + "\"");
                }
                if (feature.getFeatureValues() != null || feature.getFeatureValues().size() > 0) {
                    this.output.println(">");
                    this.saveFeaturesValues(feature.getFeatureValues());
                    this.output.println("</" + "feature".toString() + ">");
                    continue;
                }
                this.output.println(">");
            }
            if (edgeLabel != null) {
                this.output.println(edgeLabel.toString());
            }
            if (secedgeLabel != null) {
                this.output.println(secedgeLabel.toString());
            }
        }
    }

    protected void saveFeaturesValues(EList<FeatureValue> featureValues) {
        StringBuffer buf = new StringBuffer();
        this.saveFeaturesValues(buf, featureValues);
        this.output.append(buf.toString());
    }

    protected void saveFeaturesValues(StringBuffer output, EList<FeatureValue> featureValues) {
        if (featureValues != null) {
            for (FeatureValue featureValue : featureValues) {
                output.append("<value");
                if (featureValue.getId() != null) {
                    output.append(" id=\"" + featureValue.getId() + "\"");
                }
                if (featureValue.getValue() != null) {
                    output.append(" name=\"" + featureValue.getValue() + "\"");
                }
                if (featureValue.getDescription() != null) {
                    output.append(">");
                    output.append(featureValue.getDescription());
                    output.append("</value>");
                    output.append("\n");
                    continue;
                }
                output.append("/>");
                output.append("\n");
            }
        }
    }

    protected void saveBody(EList<Segment> segments) {
        this.output.println("<body>");
        if (segments != null && segments.size() > 0) {
            for (Segment segment : segments) {
                this.output.println("<s id=\"" + segment.getId() + "\">");
                if (segment.getGraphs() != null && segment.getGraphs().size() > 0) {
                    for (Graph graph : segment.getGraphs()) {
                        if (graph == null) continue;
                        this.saveGraph(graph);
                    }
                }
                this.output.println("</s>");
            }
        }
        this.output.println("</body>");
    }

    protected void saveGraph(Graph graph) {
        this.output.print("<graph");
        SyntacticNode synNode = graph.findRoot();
        if (synNode != null) {
            this.output.print(" root=\"" + synNode.getId() + "\"");
        }
        this.output.println(">");
        if (graph.getTerminals() != null && graph.getTerminals().size() > 0) {
            this.output.println("<terminals>");
            for (Terminal terminal : graph.getTerminals()) {
                this.saveTerminal(terminal);
            }
            this.output.println("</terminals>");
        }
        if (graph.getNonTerminals() != null && graph.getNonTerminals().size() > 0) {
            this.output.println("<nonterminals>");
            for (NonTerminal nonTerminal : graph.getNonTerminals()) {
                this.saveNonTerminal(nonTerminal);
            }
            this.output.println("</nonterminals>");
        }
        this.output.println("</graph>");
    }

    protected void saveTerminal(Terminal terminal) {
        if (terminal != null) {
            this.output.print("<t id=\"" + terminal.getId() + "\"");
            if (terminal.getWord() != null) {
                String word = "";
                if (!terminal.getWord().isEmpty()) {
                    word = StringEscapeUtils.escapeXml((String)terminal.getWord());
                }
                this.output.print(" word=\"" + word + "\"");
            }
            this.saveAnnotations(terminal.getAnnotations());
            if (terminal.getGraph().getOutgoingEdges(terminal.getId()) != null) {
                this.output.println(">");
                for (Edge edge : terminal.getGraph().getOutgoingEdges(terminal.getId())) {
                    this.saveEdge(edge);
                }
                this.output.println("</t>");
            } else {
                this.output.println("/>");
            }
        }
    }

    protected void saveNonTerminal(NonTerminal nonTerminal) {
        if (nonTerminal != null) {
            this.output.print("<nt id=\"" + nonTerminal.getId() + "\"");
            this.saveAnnotations(nonTerminal.getAnnotations());
            if (nonTerminal.getGraph().getOutgoingEdges(nonTerminal.getId()) != null) {
                this.output.println(">");
                for (Edge edge : nonTerminal.getGraph().getOutgoingEdges(nonTerminal.getId())) {
                    this.saveEdge(edge);
                }
                this.output.println("</nt>");
            } else {
                this.output.println("/>");
            }
        }
    }

    protected void saveAnnotations(EList<Annotation> annotations) {
        if (annotations != null && annotations.size() > 0) {
            for (Annotation annotation : annotations) {
                this.output.print(" " + annotation.getName() + "=\"" + StringEscapeUtils.escapeXml((String)annotation.getValue()) + "\"");
            }
        }
    }

    protected void saveEdge(Edge edge) {
        if (edge == null) {
            throw new TigerInvalidModelException("Cannot save edge, because it is empty.");
        }
        if (edge.getSource() == null) {
            throw new TigerInvalidModelException("Cannot save edge '" + edge + "', because its source is empty.");
        }
        if (edge.getTarget() == null) {
            throw new TigerInvalidModelException("Cannot save edge '" + edge + "', because its target is empty.");
        }
        String xmlElement = null;
        if (edge.getType() != null) {
            xmlElement = DEFAULT_TYPE.PRIM.toString().equalsIgnoreCase(edge.getType()) || DEFAULT_TYPE.EDGE.toString().equalsIgnoreCase(edge.getType()) ? "edge" : "secedge";
        } else {
            String featType = null;
            for (Annotation annotation : edge.getAnnotations()) {
                if (annotation.getFeatureRef().getType() == null || annotation.getFeatureRef().getType().isEmpty()) continue;
                if (featType == null) {
                    annotation.getFeatureRef().getType();
                    continue;
                }
                if (!featType.equals(annotation.getFeatureRef().getType())) continue;
                throw new TigerInvalidModelException("Cannot export <tiger2/> model to TigerXML, because the type of Annotation of the given edge '" + edge.getId() + "' is not the same for all annotations.");
            }
            xmlElement = DEFAULT_TYPE.PRIM.toString().equalsIgnoreCase(featType) || DEFAULT_TYPE.EDGE.toString().equalsIgnoreCase(featType) ? "edge" : "secedge";
        }
        this.output.print("<" + xmlElement);
        this.output.print(" idref=\"" + edge.getTarget().getId() + "\"");
        Annotation labelAnno = null;
        if (edge.getAnnotations() != null && edge.getAnnotations().size() > 0) {
            for (Annotation anno : edge.getAnnotations()) {
                if (!DEFAULT_TYPE.LABEL.toString().equals(anno.getValue())) continue;
                labelAnno = anno;
                break;
            }
            if (labelAnno == null) {
                labelAnno = (Annotation)edge.getAnnotations().get(0);
            }
        }
        if (labelAnno != null) {
            this.output.print(" " + DEFAULT_TYPE.LABEL.toString() + "=\"" + StringEscapeUtils.escapeXml((String)labelAnno.getValue()) + "\"");
        }
        this.output.println("/>");
    }
}

