/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tigerXML;

import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import de.hu_berlin.german.korpling.tiger2.resources.tigerXML.TigerXMLReader;
import de.hu_berlin.german.korpling.tiger2.resources.tigerXML.TigerXMLWriter;
import de.hu_berlin.german.korpling.tiger2.resources.util.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;

public class TigerXMLResource
extends ResourceImpl {
    public void save(Map<?, ?> options) throws IOException {
        TigerXMLWriter writer = new TigerXMLWriter();
        writer.setOutputURI(this.getURI());
        writer.setCorpus((Corpus)this.getContents().get(0));
        writer.save();
    }

    public void load(Map<?, ?> options) throws IOException {
        if (this.getURI() == null) {
            throw new TigerResourceException("Cannot load any resource, because no uri is given.");
        }
        File tigerFile = new File(this.getURI().toFileString());
        if (!tigerFile.exists()) {
            throw new TigerResourceException("Cannot load resource, because the file does not exists: " + tigerFile);
        }
        if (!tigerFile.canRead()) {
            throw new TigerResourceException("Cannot load resource, because the file can not be read: " + tigerFile);
        }
        Corpus corpus = null;
        corpus = Tiger2Factory.eINSTANCE.createCorpus();
        this.getContents().add((Object)corpus);
        TigerXMLReader tigerXMLReader = new TigerXMLReader();
        tigerXMLReader.setRootCorpus(corpus);
        tigerXMLReader.setInputURI(URI.createFileURI((String)tigerFile.getAbsolutePath()));
        XMLHelper.readXml(tigerFile, tigerXMLReader);
    }
}

