/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tigerXML;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DEFAULT_TYPE;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.SyntacticNode;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerImplausibleContentException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInvalidModelException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class TigerXMLReader
extends DefaultHandler2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(TigerXMLReader.class);
    private Corpus rootCorpus = null;
    private URI inputURI = null;
    private Stack<String> elementStack = null;
    private Segment currentSegment = null;
    private Graph currentGraph = null;
    private Feature currentFeature = null;
    private FeatureValue currentFeatureValue = null;
    private SyntacticNode currentSyntacticNode = null;
    private Corpus currentCorpus = null;
    private Map<String, SyntacticNode> id2synNode = null;
    private Map<Edge, String> notTargetedEdges = null;
    private int edgeCounter = 0;
    boolean edgesWithNoIds = false;
    boolean terminalsWithNoIds = false;
    boolean nonTerminalsWithNoIds = false;

    public void setRootCorpus(Corpus corpus) {
        this.rootCorpus = corpus;
        this.currentCorpus = corpus;
    }

    public Corpus getRootCorpus() {
        return this.rootCorpus;
    }

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public TigerXMLReader() {
        this.init();
    }

    public void init() {
        this.elementStack = new Stack();
        this.id2synNode = Collections.synchronizedMap(new HashMap());
        this.notTargetedEdges = Collections.synchronizedMap(new HashMap());
        this.currentSegment = null;
        this.currentGraph = null;
        this.currentSyntacticNode = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementStack != null && this.elementStack.size() > 0) {
            StringBuffer text = new StringBuffer();
            for (int i = start; i < start + length; ++i) {
                text.append(ch[i]);
            }
            if ("name".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setName(text.toString());
            } else if ("author".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setAuthor(text.toString());
            } else if ("date".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setDate(text.toString());
            } else if ("description".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setDescription(text.toString());
            } else if ("format".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setFormat(text.toString());
            } else if ("history".equals(this.elementStack.peek())) {
                this.currentCorpus.getMeta().setHistory(text.toString());
            } else if ("value".equals(this.elementStack.peek())) {
                this.currentFeatureValue.setDescription(text.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("corpus".equals(qName)) {
            String idVal = attributes.getValue("id");
            this.currentCorpus.setId(idVal);
        } else if ("subcorpus".equals(qName)) {
            Corpus subCorpus = Tiger2Factory.eINSTANCE.createCorpus();
            this.currentCorpus.getSubCorpora().add((Object)subCorpus);
            this.currentCorpus = subCorpus;
        } else if ("meta".equals(qName)) {
            Meta meta = Tiger2Factory.eINSTANCE.createMeta();
            this.currentCorpus.setMeta(meta);
            this.elementStack.push(qName);
        } else if ("feature".equals(qName)) {
            if (!"annotation".toString().equals(this.elementStack.peek())) throw new TigerImplausibleContentException("An element of type 'feature' was found, which is not nedted in a 'annotation' element");
            this.currentFeature = Tiger2Factory.eINSTANCE.createFeature();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getLocalName(i);
                String attValue = attributes.getValue(i);
                if ("id".equals(attName)) {
                    this.currentFeature.setId(attValue);
                    continue;
                }
                if ("name".equals(attName)) {
                    this.currentFeature.setName(attValue);
                    continue;
                }
                if (!"domain".equals(attName)) continue;
                DOMAIN domain = DOMAIN.get(attValue.toLowerCase());
                if (domain == null) {
                    throw new TigerImplausibleContentException("The domain value for a Feature can only be one of the following: '" + DOMAIN.T.toString() + "', '" + DOMAIN.NT.toString() + "' or '" + DOMAIN.EDGE.toString() + "'.");
                }
                this.currentFeature.setDomain(domain);
            }
            this.currentCorpus.getFeatures().add((Object)this.currentFeature);
        } else if ("edgelabel".equals(qName) || "secedgelabel".equals(qName)) {
            if ("annotation".toString().equals(this.elementStack.peek())) {
                String idValue = attributes.getValue("id");
                this.currentFeature.setId(idValue);
                this.currentFeature = Tiger2Factory.eINSTANCE.createFeature();
                this.currentFeature.setName(DEFAULT_TYPE.LABEL.toString());
                this.currentFeature.setDomain(DOMAIN.EDGE);
                if ("edgelabel".equals(qName)) {
                    this.currentFeature.setType(DEFAULT_TYPE.EDGE.toString());
                } else if ("secedgelabel".equals(qName)) {
                    this.currentFeature.setType(DEFAULT_TYPE.SECEDGE.toString());
                }
                this.currentCorpus.getFeatures().add((Object)this.currentFeature);
            }
        } else if ("value".equals(qName)) {
            if (!"feature".toString().equals(this.elementStack.peek()) && !"edgelabel".toString().equals(this.elementStack.peek()) && !"secedgelabel".toString().equals(this.elementStack.peek())) throw new TigerImplausibleContentException("An element of type 'value' was found, which is not contained in a 'feature' element.");
            this.currentFeatureValue = Tiger2Factory.eINSTANCE.createFeatureValue();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getLocalName(i);
                String attValue = attributes.getValue(i);
                if ("id".equals(attName)) {
                    this.currentFeatureValue.setId(attValue);
                    continue;
                }
                if (!"name".equals(attName)) continue;
                this.currentFeatureValue.setValue(attValue);
            }
            this.currentFeature.getFeatureValues().add((Object)this.currentFeatureValue);
        } else if ("s".equals(qName)) {
            Segment segment;
            this.currentSegment = segment = Tiger2Factory.eINSTANCE.createSegment();
            String id = attributes.getValue("id");
            if (id != null) {
                segment.setId(id);
            }
            this.currentCorpus.getSegments().add((Object)segment);
        } else if ("graph".equals(qName)) {
            Graph graph;
            this.currentGraph = graph = Tiger2Factory.eINSTANCE.createGraph();
            String id = attributes.getValue("id");
            if (id != null) {
                graph.setId(id);
            }
            if (this.currentSegment == null) {
                throw new TigerInternalException("The variable 'currentSegment' of Tiger2Reader was empty when reding a graph element.");
            }
            this.currentSegment.getGraphs().add((Object)graph);
        } else if ("t".equals(qName)) {
            this.importTerminal(attributes);
        } else if ("nt".equals(qName)) {
            this.importNonTerminal(attributes);
        } else if ("edge".equals(qName) || "secedge".equals(qName)) {
            this.importEdges(qName, attributes);
        }
        this.elementStack.push(qName);
    }

    public void importTerminal(Attributes attributes) {
        Terminal terminal = Tiger2Factory.eINSTANCE.createTerminal();
        String id = attributes.getValue("id");
        if (id == null) {
            this.terminalsWithNoIds = true;
            id = "synNode_" + this.currentGraph.getSyntacticNodes().size() + 1;
        } else if (this.currentGraph.findNode(id) != null) {
            id = id + "_" + this.currentGraph.getSyntacticNodes().size() + 1;
        }
        terminal.setId(id);
        this.id2synNode.put(id, terminal);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getLocalName(i);
            String attValue = attributes.getValue(i);
            if ("id".equals(attributes.getQName(i))) continue;
            if ("word".equals(attName) || "word".equals(attName) && attributes.getURI(i).equals("http://www.ims.uni-stuttgart.de/projekte/TIGER/public/")) {
                terminal.setWord(attValue);
                continue;
            }
            Annotation annotation = null;
            if (this.currentCorpus.findFeature(attName, DOMAIN.T) == null) {
                Feature newFeature = Tiger2Factory.eINSTANCE.createFeature();
                newFeature.setDomain(DOMAIN.T);
                newFeature.setName(attName);
                this.currentCorpus.getFeatures().add((Object)newFeature);
            }
            try {
                annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.T, attValue);
            }
            catch (TigerInvalidModelException e) {
                throw new TigerImplausibleContentException("Error in corpus in file '" + this.getInputURI() + "'.", e);
            }
            if (annotation == null) continue;
            terminal.getAnnotations().add((Object)annotation);
        }
        this.currentGraph.getSyntacticNodes().add((Object)terminal);
        this.currentSyntacticNode = terminal;
    }

    public void importNonTerminal(Attributes attributes) {
        NonTerminal nonTerminal = Tiger2Factory.eINSTANCE.createNonTerminal();
        String id = attributes.getValue("id");
        if (id == null) {
            this.nonTerminalsWithNoIds = true;
            id = "synNode_" + this.currentGraph.getSyntacticNodes().size() + 1;
        } else if (this.currentGraph.findNode(id) != null) {
            id = id + "_" + this.currentGraph.getSyntacticNodes().size() + 1;
        }
        nonTerminal.setId(id);
        this.id2synNode.put(id, nonTerminal);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getLocalName(i);
            String attValue = attributes.getValue(i);
            if ("id".equals(attributes.getQName(i))) continue;
            Annotation annotation = null;
            if (this.currentCorpus.findFeature(attName, DOMAIN.NT) == null) {
                Feature newFeature = Tiger2Factory.eINSTANCE.createFeature();
                newFeature.setDomain(DOMAIN.NT);
                newFeature.setName(attName);
                this.currentCorpus.getFeatures().add((Object)newFeature);
            }
            try {
                annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.NT, attValue);
            }
            catch (TigerInvalidModelException e) {
                throw new TigerImplausibleContentException("Error in corpus in file '" + this.getInputURI() + "'.", e);
            }
            if (annotation == null) continue;
            nonTerminal.getAnnotations().add((Object)annotation);
        }
        this.currentGraph.getSyntacticNodes().add((Object)nonTerminal);
        this.currentSyntacticNode = nonTerminal;
    }

    public void importEdges(String qName, Attributes attributes) {
        Edge edge = Tiger2Factory.eINSTANCE.createEdge();
        String id = attributes.getValue("id");
        if (id == null) {
            this.edgesWithNoIds = true;
            id = "edge_" + this.edgeCounter;
            ++this.edgeCounter;
        } else if (this.currentGraph.findEdge(id) != null) {
            id = id + "_" + this.edgeCounter;
            ++this.edgeCounter;
        }
        edge.setId(id);
        String type = null;
        type = "edge".equals(qName) ? DEFAULT_TYPE.EDGE.toString() : DEFAULT_TYPE.SECEDGE.toString();
        edge.setType(type);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getLocalName(i);
            String attValue = attributes.getValue(i);
            if ("id".equals(attributes.getQName(i))) continue;
            if ("idref".equals(attName)) {
                SyntacticNode synNode;
                if (attName == null || attName.isEmpty()) {
                    throw new TigerImplausibleContentException("An edge was found with an empty 'idref' value.");
                }
                if (attValue.startsWith("#")) {
                    attValue = attValue.replace("#", "");
                }
                if ((synNode = this.id2synNode.get(attValue)) != null) {
                    edge.setTarget(synNode);
                    continue;
                }
                this.notTargetedEdges.put(edge, attValue);
                continue;
            }
            Annotation annotation = null;
            if (this.currentCorpus.findFeature(attName, DOMAIN.EDGE, type) == null) {
                Feature newFeature = Tiger2Factory.eINSTANCE.createFeature();
                newFeature.setDomain(DOMAIN.EDGE);
                newFeature.setName(attName);
                newFeature.setType(type);
                this.currentCorpus.getFeatures().add((Object)newFeature);
            }
            try {
                annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.EDGE, edge.getType(), attValue);
            }
            catch (TigerInvalidModelException e) {
                throw new TigerImplausibleContentException("Error in corpus in file '" + this.getInputURI() + "'.", e);
            }
            if (annotation == null) continue;
            edge.getAnnotations().add((Object)annotation);
        }
        edge.setSource(this.currentSyntacticNode);
        if (edge.getTarget() != null) {
            this.currentGraph.getEdges().add((Object)edge);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("graph".equals(qName)) {
            this.processNotTargetedEdges();
            this.currentGraph = null;
        }
        this.elementStack.pop();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.edgesWithNoIds) {
            LOGGER.warn("One or more edge elements have no id in file '" + this.inputURI + "'. ");
        }
        if (this.nonTerminalsWithNoIds) {
            LOGGER.warn("One or more syntactic node (non-terminal) elements have no id in file '" + this.inputURI + "'. ");
        }
        if (this.terminalsWithNoIds) {
            LOGGER.warn("One or more syntactic node (terminal) elements have no id in file '" + this.inputURI + "'. ");
        }
    }

    private void processNotTargetedEdges() {
        if (this.notTargetedEdges != null && this.notTargetedEdges.size() > 0) {
            Set<Edge> edges = this.notTargetedEdges.keySet();
            for (Edge edge : edges) {
                String targetId = this.notTargetedEdges.get(edge);
                if (targetId == null) {
                    throw new TigerInternalException("An edge was found in 'NotTargetedEdges', that has no corresponding target node id.");
                }
                SyntacticNode target = this.id2synNode.get(targetId);
                if (target == null) {
                    throw new TigerImplausibleContentException("The referred target of an edge ( id of target is '" + targetId + "') in the document '" + this.getInputURI() + "' cannot be found. The reason might be, that the node is not contained in document.");
                }
                edge.setTarget(target);
                this.currentGraph.getEdges().add((Object)edge);
            }
            this.notTargetedEdges = Collections.synchronizedMap(new HashMap());
        }
    }
}

