/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInvalidModelException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class Tiger2Writer {
    private Corpus corpus = null;
    private URI outputURI = null;
    protected PrintWriter output = null;
    public static final String NS_ALIAS_TIGER2 = "tiger2";

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setOutputURI(URI inputURI) {
        this.outputURI = inputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public void save() {
        if (this.getOutputURI() == null) {
            throw new TigerInternalException("Cannot save the 'Corpus' object, because no output uri was given.");
        }
        try {
            File tiger2out = new File(this.getOutputURI().toFileString());
            tiger2out.getParentFile().mkdirs();
            try {
                this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tiger2out), "UTF8")), false);
            }
            catch (UnsupportedEncodingException e) {
                throw new TigerResourceException("Cannot open stream for writing 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
            }
            catch (FileNotFoundException e) {
                throw new TigerResourceException("Cannot open stream for writing 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
            }
            this.saveSuperCorpus(this.getCorpus());
        }
        catch (Exception e) {
            if (e instanceof TigerException) {
                throw (TigerException)e;
            }
            throw new TigerException("An unknown exception occurs while saving 'Corpus' object to uri '" + this.getOutputURI() + "'.", e);
        }
        finally {
            if (this.output != null) {
                this.output.close();
            }
        }
    }

    protected void saveSuperCorpus(Corpus corpus) {
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.output.println("<corpus ");
        if (corpus.getId() != null && !corpus.getId().isEmpty()) {
            this.output.println("xml:id=\"" + corpus.getId() + "\"");
        }
        this.output.println(" xmlns=\"http://korpling.german.hu-berlin.de/tiger2/V2.0.5/\" xmlns:tiger2=\"http://korpling.german.hu-berlin.de/tiger2/V2.0.5/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://korpling.german.hu-berlin.de/tiger2/V2.0.5/ http://korpling.german.hu-berlin.de/tiger2/V2.0.5/Tiger2.xsd\">");
        this.output.println("<head>");
        if (corpus.getMeta() != null) {
            this.saveMeta(corpus.getMeta());
        }
        if (corpus.getFeatures() != null) {
            this.output.println("<annotation>");
            this.saveFeatures(corpus.getFeatures());
            this.output.println("</annotation>");
        }
        this.output.println("</head>");
        if (corpus.getSubCorpora() != null && corpus.getSubCorpora().size() > 0) {
            for (Corpus subCorpus : corpus.getSubCorpora()) {
                this.saveSubCorpus(subCorpus);
            }
        }
        this.saveBody(corpus.getSegments());
        this.output.println("</corpus>");
    }

    protected void saveSubCorpus(Corpus corpus) {
        this.output.println("<subcorpus xml:id=\"" + corpus.getId() + "\">");
        if (corpus.getMeta() != null) {
            this.saveMeta(corpus.getMeta());
        }
        if (corpus.getSubCorpora() != null && corpus.getSubCorpora().size() > 0) {
            for (Corpus subCorpus : corpus.getSubCorpora()) {
                this.saveSubCorpus(subCorpus);
            }
        }
        this.saveBody(corpus.getSegments());
        this.output.println("</subcorpus>");
    }

    protected void saveMeta(Meta meta) {
        this.output.println("<meta>");
        if (meta.getName() != null && !meta.getName().isEmpty()) {
            this.output.println("<name>" + meta.getName() + "</" + "name" + ">");
        }
        if (meta.getAuthor() != null && !meta.getAuthor().isEmpty()) {
            this.output.println("<author>" + meta.getAuthor() + "</" + "author" + ">");
        }
        if (meta.getDate() != null && !meta.getDate().isEmpty()) {
            this.output.println("<date>" + meta.getDate() + "</" + "date" + ">");
        }
        if (meta.getDescription() != null && !meta.getDescription().isEmpty()) {
            this.output.println("<description>" + meta.getDescription() + "</" + "description" + ">");
        }
        if (meta.getFormat() != null && !meta.getFormat().isEmpty()) {
            this.output.println("<format>" + meta.getFormat() + "</" + "format" + ">");
        }
        if (meta.getHistory() != null && !meta.getHistory().isEmpty()) {
            this.output.println("<history>" + meta.getHistory() + "</" + "history" + ">");
        }
        this.output.println("</meta>");
    }

    protected void saveFeatures(EList<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                this.output.print("<feature");
                if (feature.getId() != null) {
                    this.output.print(" xml:id=\"" + feature.getId() + "\"");
                }
                if (feature.getType() != null) {
                    this.output.print(" type=\"" + feature.getType() + "\"");
                }
                if (feature.getName() != null) {
                    this.output.print(" name=\"" + feature.getName() + "\"");
                }
                if (feature.getDomain() != null) {
                    this.output.print(" domain=\"" + (Object)((Object)feature.getDomain()) + "\"");
                }
                if (feature.getDcrReference() != null) {
                    this.output.print(" datcat=\"" + feature.getDcrReference() + "\"");
                }
                if (feature.getFeatureValues() != null || feature.getFeatureValues().size() > 0) {
                    this.output.println(">");
                    this.saveFeaturesValues(feature.getFeatureValues());
                    this.output.println("</feature>");
                    continue;
                }
                this.output.println(">");
            }
        }
    }

    protected void saveFeaturesValues(EList<FeatureValue> featureValues) {
        if (featureValues != null) {
            for (FeatureValue featureValue : featureValues) {
                this.output.print("<value");
                if (featureValue.getId() != null) {
                    this.output.print(" xml:id=\"" + featureValue.getId() + "\"");
                }
                if (featureValue.getValue() != null) {
                    this.output.print(" name=\"" + featureValue.getValue() + "\"");
                }
                if (featureValue.getDcrReference() != null) {
                    this.output.print(" datcat=\"" + featureValue.getDcrReference() + "\"");
                }
                if (featureValue.getDescription() != null) {
                    this.output.print(">");
                    this.output.print(featureValue.getDescription());
                    this.output.println("</value>");
                    continue;
                }
                this.output.println("/>");
            }
        }
    }

    protected void saveBody(EList<Segment> segments) {
        this.output.println("<body>");
        if (segments != null && segments.size() > 0) {
            for (Segment segment : segments) {
                this.output.println("<s xml:id=\"" + segment.getId() + "\">");
                if (segment.getGraphs() != null && segment.getGraphs().size() > 0) {
                    for (Graph graph : segment.getGraphs()) {
                        if (graph == null) continue;
                        this.saveGraph(graph);
                    }
                }
                this.output.println("</s>");
            }
        }
        this.output.println("</body>");
    }

    protected void saveGraph(Graph graph) {
        this.output.println("<graph xml:id=\"" + graph.getId() + "\">");
        if (graph.getTerminals() != null && graph.getTerminals().size() > 0) {
            this.output.println("<terminals>");
            for (Terminal terminal : graph.getTerminals()) {
                this.saveTerminal(terminal);
            }
            this.output.println("</terminals>");
        }
        if (graph.getNonTerminals() != null && graph.getNonTerminals().size() > 0) {
            this.output.println("<nonterminals>");
            for (NonTerminal nonTerminal : graph.getNonTerminals()) {
                this.saveNonTerminal(nonTerminal);
            }
            this.output.println("</nonterminals>");
        }
        this.output.println("</graph>");
    }

    protected void saveTerminal(Terminal terminal) {
        if (terminal != null) {
            this.output.print("<t xml:id=\"" + terminal.getId() + "\"");
            this.output.print(" tiger2:word=\"" + StringEscapeUtils.escapeXml((String)terminal.getWord()) + "\"");
            if (terminal.getType() != null) {
                this.output.print(" tiger2:type=\"" + terminal.getType() + "\"");
            }
            this.saveAnnotations(terminal.getAnnotations());
            if (terminal.getGraph().getOutgoingEdges(terminal.getId()) != null) {
                this.output.println(">");
                for (Edge edge : terminal.getGraph().getOutgoingEdges(terminal.getId())) {
                    this.saveEdge(edge);
                }
                this.output.println("</t>");
            } else {
                this.output.println("/>");
            }
        }
    }

    protected void saveNonTerminal(NonTerminal nonTerminal) {
        if (nonTerminal != null) {
            this.output.print("<nt xml:id=\"" + nonTerminal.getId() + "\"");
            if (nonTerminal.getType() != null) {
                this.output.print(" tiger2:type=\"" + nonTerminal.getType() + "\"");
            }
            this.saveAnnotations(nonTerminal.getAnnotations());
            if (nonTerminal.getGraph().getOutgoingEdges(nonTerminal.getId()) != null) {
                this.output.println(">");
                for (Edge edge : nonTerminal.getGraph().getOutgoingEdges(nonTerminal.getId())) {
                    this.saveEdge(edge);
                }
                this.output.println("</nt>");
            } else {
                this.output.println("/>");
            }
        }
    }

    protected void saveAnnotations(EList<Annotation> annotations) {
        if (annotations != null && annotations.size() > 0) {
            for (Annotation annotation : annotations) {
                this.output.print(" " + annotation.getName() + "=\"" + StringEscapeUtils.escapeXml((String)annotation.getValue()) + "\"");
            }
        }
    }

    protected void saveEdge(Edge edge) {
        if (edge == null) {
            throw new TigerInvalidModelException("Cannot save edge, because it is empty.");
        }
        if (edge.getSource() == null) {
            throw new TigerInvalidModelException("Cannot save edge '" + edge + "', because its source is empty.");
        }
        if (edge.getTarget() == null) {
            throw new TigerInvalidModelException("Cannot save edge '" + edge + "', because its target is empty.");
        }
        this.output.print("<edge xml:id=\"" + edge.getId() + "\"");
        if (edge.getType() != null) {
            this.output.print(" tiger2:type=\"" + edge.getType() + "\"");
        }
        this.output.print(" tiger2:target=\"#" + edge.getTarget().getId() + "\"");
        this.saveAnnotations(edge.getAnnotations());
        this.output.println("/>");
    }
}

