/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205;

import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205.Tiger2Reader;
import de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205.Tiger2Writer;
import de.hu_berlin.german.korpling.tiger2.resources.util.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;

public class Tiger2Resource
extends ResourceImpl {
    public void save(Map<?, ?> options) throws IOException {
        Tiger2Writer writer = new Tiger2Writer();
        writer.setOutputURI(this.getURI());
        writer.setCorpus((Corpus)this.getContents().get(0));
        writer.save();
    }

    public void load(Map<?, ?> options) throws IOException {
        if (this.getURI() == null) {
            throw new TigerResourceException("Cannot load any resource, because no uri is given.");
        }
        File tiger2File = new File(this.getURI().toFileString());
        if (!tiger2File.exists()) {
            throw new TigerResourceException("Cannot load resource, because the file does not exists: " + tiger2File);
        }
        if (!tiger2File.canRead()) {
            throw new TigerResourceException("Cannot load resource, because the file can not be read: " + tiger2File);
        }
        Corpus corpus = null;
        corpus = Tiger2Factory.eINSTANCE.createCorpus();
        this.getContents().add((Object)corpus);
        Tiger2Reader tiger2Reader = new Tiger2Reader();
        tiger2Reader.setRootCorpus(corpus);
        tiger2Reader.setInputURI(URI.createFileURI((String)tiger2File.getAbsolutePath()));
        XMLHelper.readXml(tiger2File, tiger2Reader);
    }
}

