/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.SyntacticNode;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerImplausibleContentException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInvalidModelException;
import de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205.AnnotationReader;
import de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205.MetaReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class Tiger2Reader
extends DefaultHandler2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tiger2Reader.class);
    private Corpus rootCorpus = null;
    private URI inputURI = null;
    private Stack<String> elementStack = null;
    private Segment currentSegment = null;
    private Graph currentGraph = null;
    private MetaReader metaReader = null;
    private AnnotationReader annotationReader = null;
    private SyntacticNode currentSyntacticNode = null;
    private Corpus currentCorpus = null;
    private Map<String, SyntacticNode> id2synNode = null;
    private Map<Edge, String> notTargetedEdges = null;
    private boolean pushElement = true;
    private int edgeCounter = 0;
    boolean edgesWithNoIds = false;
    boolean terminalsWithNoIds = false;
    boolean nonTerminalsWithNoIds = false;

    public void setRootCorpus(Corpus corpus) {
        this.rootCorpus = corpus;
        this.currentCorpus = corpus;
    }

    public Corpus getRootCorpus() {
        return this.rootCorpus;
    }

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public Tiger2Reader() {
        this.init();
    }

    public void init() {
        this.elementStack = new Stack();
        this.id2synNode = Collections.synchronizedMap(new HashMap());
        this.notTargetedEdges = Collections.synchronizedMap(new HashMap());
        this.currentSegment = null;
        this.currentGraph = null;
        this.currentSyntacticNode = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementStack != null && "meta".equals(this.elementStack.peek())) {
            if (this.metaReader == null) {
                throw new TigerInternalException("No reader for meta-data is set.");
            }
            this.metaReader.characters(ch, start, length);
        } else if (this.elementStack != null && "annotation".equals(this.elementStack.peek())) {
            if (this.annotationReader == null) {
                throw new TigerInternalException("No reader for annotation-data is set.");
            }
            this.annotationReader.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!"corpus".equals(qName)) {
            if ("subcorpus".equals(qName)) {
                Corpus subCorpus = Tiger2Factory.eINSTANCE.createCorpus();
                this.currentCorpus.getSubCorpora().add((Object)subCorpus);
                this.currentCorpus = subCorpus;
            } else if ("meta".equals(qName)) {
                Meta meta = Tiger2Factory.eINSTANCE.createMeta();
                this.metaReader = new MetaReader();
                this.metaReader.setInputURI(this.getInputURI());
                this.metaReader.setMeta(meta);
                this.currentCorpus.setMeta(meta);
                this.elementStack.push(qName);
                this.pushElement = false;
            } else if (this.elementStack != null && "meta".equals(this.elementStack.peek())) {
                if (this.metaReader == null) {
                    throw new TigerInternalException("No reader for meta-data is set.");
                }
                this.metaReader.startElement(uri, localName, qName, attributes);
            } else if ("annotation".equals(qName)) {
                this.annotationReader = new AnnotationReader();
                this.annotationReader.setInputURI(this.getInputURI());
                this.annotationReader.setCorpus(this.currentCorpus);
                this.annotationReader.startElement(uri, localName, qName, attributes);
                this.elementStack.push(qName);
                this.pushElement = false;
            } else if (this.elementStack != null && "annotation".equals(this.elementStack.peek())) {
                if (this.annotationReader == null) {
                    throw new TigerInternalException("No reader for meta-data is set.");
                }
                this.annotationReader.startElement(uri, localName, qName, attributes);
            } else if ("s".equals(qName)) {
                Segment segment;
                this.currentSegment = segment = Tiger2Factory.eINSTANCE.createSegment();
                String id = attributes.getValue("xml:id");
                if (id != null) {
                    segment.setId(id);
                }
                this.currentCorpus.getSegments().add((Object)segment);
            } else if ("graph".equals(qName)) {
                Graph graph;
                this.currentGraph = graph = Tiger2Factory.eINSTANCE.createGraph();
                String id = attributes.getValue("xml:id");
                if (id != null) {
                    graph.setId(id);
                }
                if (this.currentSegment == null) {
                    throw new TigerInternalException("The variable 'currentSegment' of Tiger2Reader was empty when reding a graph element.");
                }
                this.currentSegment.getGraphs().add((Object)graph);
            } else if ("t".equals(qName)) {
                Terminal terminal = Tiger2Factory.eINSTANCE.createTerminal();
                String id = attributes.getValue("xml:id");
                if (id == null) {
                    this.terminalsWithNoIds = true;
                    id = "synNode_" + this.currentGraph.getSyntacticNodes().size() + 1;
                } else if (this.currentGraph.findNode(id) != null) {
                    id = id + "_" + this.currentGraph.getSyntacticNodes().size() + 1;
                }
                terminal.setId(id);
                this.id2synNode.put(id, terminal);
                String type = attributes.getValue("type");
                if (type != null) {
                    terminal.setType(type);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Annotation annotation;
                    String attName = attributes.getLocalName(i);
                    String attValue = attributes.getValue(i);
                    if ("xml:id".equals(attributes.getQName(i))) continue;
                    if ("word".equals(attName) || "word".equals(attName) && attributes.getURI(i).equals("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/")) {
                        terminal.setWord(attValue);
                        continue;
                    }
                    if ("corresp".equals(attName) && attributes.getURI(i).equals("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/") || "type".equals(attName) && attributes.getURI(i).equals("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/") || (annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.T, attValue)) == null) continue;
                    terminal.getAnnotations().add((Object)annotation);
                }
                this.currentGraph.getSyntacticNodes().add((Object)terminal);
                this.currentSyntacticNode = terminal;
            } else if ("nt".equals(qName)) {
                NonTerminal nonTerminal = Tiger2Factory.eINSTANCE.createNonTerminal();
                String id = attributes.getValue("xml:id");
                if (id == null) {
                    this.nonTerminalsWithNoIds = true;
                    id = "synNode_" + this.currentGraph.getSyntacticNodes().size() + 1;
                } else if (this.currentGraph.findNode(id) != null) {
                    id = id + "_" + this.currentGraph.getSyntacticNodes().size() + 1;
                }
                nonTerminal.setId(id);
                this.id2synNode.put(id, nonTerminal);
                String type = attributes.getValue("type");
                if (type != null) {
                    nonTerminal.setType(type);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Annotation annotation;
                    String attName = attributes.getLocalName(i);
                    String attValue = attributes.getValue(i);
                    if ("xml:id".equals(attributes.getQName(i)) || "type".equals(attName) && attributes.getURI(i).equals("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/") || (annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.NT, type, attValue)) == null) continue;
                    nonTerminal.getAnnotations().add((Object)annotation);
                }
                this.currentGraph.getSyntacticNodes().add((Object)nonTerminal);
                this.currentSyntacticNode = nonTerminal;
            } else if ("edge".equals(qName)) {
                Edge edge = Tiger2Factory.eINSTANCE.createEdge();
                String id = attributes.getValue("xml:id");
                if (id == null) {
                    this.edgesWithNoIds = true;
                    id = "edge_" + this.edgeCounter;
                    ++this.edgeCounter;
                } else if (this.currentGraph.findEdge(id) != null) {
                    id = id + "_" + this.edgeCounter;
                    ++this.edgeCounter;
                }
                edge.setId(id);
                String type = attributes.getValue("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/", "type");
                if (type == null) {
                    type = attributes.getValue("type");
                }
                if (type != null) {
                    edge.setType(type);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getLocalName(i);
                    String attValue = attributes.getValue(i);
                    if ("xml:id".equals(attributes.getQName(i))) continue;
                    if ("target".equals(attName) && attributes.getURI(i).equals("http://korpling.german.hu-berlin.de/tiger2/V2.0.5/")) {
                        SyntacticNode synNode;
                        if (attName == null || attName.isEmpty()) {
                            throw new TigerImplausibleContentException("An edge was found with an empty 'target' value.");
                        }
                        if (attValue.startsWith("#")) {
                            attValue = attValue.replace("#", "");
                        }
                        if ((synNode = this.id2synNode.get(attValue)) != null) {
                            edge.setTarget(synNode);
                            this.currentGraph.getEdges().add((Object)edge);
                            continue;
                        }
                        this.notTargetedEdges.put(edge, attValue);
                        continue;
                    }
                    if ("type".equals(attName)) continue;
                    Annotation annotation = null;
                    try {
                        annotation = this.currentCorpus.createAnnotation(attName, DOMAIN.EDGE, type, attValue);
                    }
                    catch (TigerInvalidModelException e) {
                        throw new TigerImplausibleContentException("An exception occurs in edge '" + edge.getId() + "' ", e);
                    }
                    if (annotation == null) continue;
                    edge.getAnnotations().add((Object)annotation);
                }
                edge.setSource(this.currentSyntacticNode);
            }
        }
        if (this.pushElement) {
            this.elementStack.push(qName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        boolean popElement = true;
        if ("graph".equals(qName)) {
            this.processNotTargetedEdges();
            this.currentGraph = null;
        } else if (this.elementStack != null && "meta".equals(this.elementStack.peek())) {
            if ("meta".equals(qName)) {
                this.pushElement = true;
            } else {
                if (this.metaReader == null) {
                    throw new TigerInternalException("No reader for meta-data is set.");
                }
                popElement = false;
            }
            this.metaReader.endElement(namespaceURI, localName, qName);
        } else if (this.elementStack != null && "annotation".equals(this.elementStack.peek())) {
            if ("annotation".equals(qName)) {
                this.pushElement = true;
            } else {
                if (this.annotationReader == null) {
                    throw new TigerInternalException("No reader for annotation-data is set.");
                }
                popElement = false;
            }
            this.annotationReader.endElement(namespaceURI, localName, qName);
        }
        if (popElement) {
            this.elementStack.pop();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.edgesWithNoIds) {
            LOGGER.warn("One or more edge elements have no id in file '" + this.inputURI + "'. ");
        }
        if (this.nonTerminalsWithNoIds) {
            LOGGER.warn("One or more syntactic node (non-terminal) elements have no id in file '" + this.inputURI + "'. ");
        }
        if (this.terminalsWithNoIds) {
            LOGGER.warn("One or more syntactic node (terminal) elements have no id in file '" + this.inputURI + "'. ");
        }
    }

    private void processNotTargetedEdges() {
        if (this.notTargetedEdges != null && this.notTargetedEdges.size() > 0) {
            Set<Edge> edges = this.notTargetedEdges.keySet();
            for (Edge edge : edges) {
                String targetId = this.notTargetedEdges.get(edge);
                if (targetId == null) {
                    throw new TigerInternalException("An edge was found in 'NotTargetedEdges', that has no corresponding target node id.");
                }
                SyntacticNode target = this.id2synNode.get(targetId);
                if (target == null) {
                    throw new TigerImplausibleContentException("The referred target of an edge ( id of target is '" + targetId + "') in the document '" + this.getInputURI() + "' cannot be found. The reason might be, that the node is not contained in document.");
                }
                edge.setTarget(target);
                this.currentGraph.getEdges().add((Object)edge);
            }
            this.notTargetedEdges = Collections.synchronizedMap(new HashMap());
        }
    }
}

