/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205;

import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerImplausibleContentException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.resources.util.XMLHelper;
import java.io.File;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class MetaReader
extends DefaultHandler2 {
    private URI inputURI = null;
    private Meta meta = null;
    private Stack<String> elementStack = new Stack();

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Meta getMeta() {
        return this.meta;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer text = new StringBuffer();
        for (int i = start; i < start + length; ++i) {
            text.append(ch[i]);
        }
        if (this.elementStack.size() > 0) {
            if ("name".equals(this.elementStack.peek())) {
                this.getMeta().setName(text.toString());
            } else if ("author".equals(this.elementStack.peek())) {
                this.getMeta().setAuthor(text.toString());
            } else if ("date".equals(this.elementStack.peek())) {
                this.getMeta().setDate(text.toString());
            } else if ("description".equals(this.elementStack.peek())) {
                this.getMeta().setDescription(text.toString());
            } else if ("format".equals(this.elementStack.peek())) {
                this.getMeta().setFormat(text.toString());
            } else if ("history".equals(this.elementStack.peek())) {
                this.getMeta().setHistory(text.toString());
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("external".equals(qName)) {
            String correspFileName = null;
            correspFileName = attributes.getValue("corresp");
            if (correspFileName == null) {
                throw new TigerImplausibleContentException("Cannot read meta-data, because of the element 'external' is used, but its value 'corresp' isn't set.");
            }
            if (this.getInputURI() == null) {
                throw new TigerInternalException("Cannot read external meta-data file, because the input uir was not set.");
            }
            File correspFile = new File(new File(this.getInputURI().toFileString()).getParent() + "/" + correspFileName);
            if (!correspFile.exists()) {
                throw new TigerImplausibleContentException("Cannot read meta-data, because the specified file '" + correspFile.getAbsolutePath() + "' does not exist.");
            }
            MetaReader externalMetaReader = new MetaReader();
            externalMetaReader.setInputURI(URI.createFileURI((String)correspFile.getAbsolutePath()));
            externalMetaReader.setMeta(this.getMeta());
            XMLHelper.readXml(correspFile, externalMetaReader);
        }
        this.elementStack.push(qName);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.elementStack.size() > 0) {
            this.elementStack.pop();
        }
    }
}

