/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205;

import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerImplausibleContentException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInternalException;
import de.hu_berlin.german.korpling.tiger2.resources.util.XMLHelper;
import java.io.File;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class AnnotationReader
extends DefaultHandler2 {
    private URI inputURI = null;
    private Corpus corpus = null;
    private Feature currentFeature = null;
    private FeatureValue currentFeatureValue = null;
    private Stack<String> elementStack = new Stack();

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer text = new StringBuffer();
        for (int i = start; i < start + length; ++i) {
            text.append(ch[i]);
        }
        if (this.elementStack.size() > 0 && "value".equals(this.elementStack.peek())) {
            this.currentFeatureValue.setDescription(text.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("feature".equals(qName)) {
            if (!"annotation".toString().equals(this.elementStack.peek())) throw new TigerImplausibleContentException("An element of type 'feature' was found, which is not nedted in a 'annotation' element");
            this.currentFeature = Tiger2Factory.eINSTANCE.createFeature();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getLocalName(i);
                String attValue = attributes.getValue(i);
                if ("xml:id".equals(attName)) {
                    this.currentFeature.setId(attValue);
                    continue;
                }
                if ("type".equals(attName)) {
                    this.currentFeature.setType(attValue);
                    continue;
                }
                if ("name".equals(attName)) {
                    this.currentFeature.setName(attValue);
                    continue;
                }
                if ("domain".equals(attName)) {
                    DOMAIN domain = DOMAIN.get(attValue);
                    if (domain == null) {
                        throw new TigerImplausibleContentException("The domain value for a Feature can only be one of the following: '" + DOMAIN.T.toString() + "', '" + DOMAIN.NT.toString() + "' or '" + DOMAIN.EDGE.toString() + "'.");
                    }
                    this.currentFeature.setDomain(domain);
                    continue;
                }
                if (!"datcat".equals(attName) || attValue == null || attValue.isEmpty()) continue;
                java.net.URI datCatUri = java.net.URI.create(attValue);
                this.currentFeature.setDcrReference(datCatUri);
            }
            this.getCorpus().getFeatures().add((Object)this.currentFeature);
        } else if ("value".equals(qName)) {
            if (!"feature".toString().equals(this.elementStack.peek())) throw new TigerImplausibleContentException("An element of type 'value' was found, which is not nedted in a 'feature' element");
            this.currentFeatureValue = Tiger2Factory.eINSTANCE.createFeatureValue();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getLocalName(i);
                String attValue = attributes.getValue(i);
                if ("xml:id".equals(attName)) {
                    this.currentFeatureValue.setId(attValue);
                    continue;
                }
                if ("name".equals(attName)) {
                    this.currentFeatureValue.setValue(attValue);
                    continue;
                }
                if (!"datcat".equals(attName) || attValue == null || attValue.isEmpty()) continue;
                java.net.URI datCatUri = java.net.URI.create(attValue);
                this.currentFeatureValue.setDcrReference(datCatUri);
            }
            this.currentFeature.getFeatureValues().add((Object)this.currentFeatureValue);
        } else if ("external".equals(qName)) {
            String correspFileName = null;
            correspFileName = attributes.getValue("corresp");
            if (correspFileName == null) {
                throw new TigerImplausibleContentException("Cannot read annotation-data, because of the element 'external' is used, but its value 'corresp' isn't set.");
            }
            if (this.getInputURI() == null) {
                throw new TigerInternalException("Cannot read external annotation-data file, because the input uir was not set.");
            }
            File correspFile = new File(new File(this.getInputURI().toFileString()).getParent() + "/" + correspFileName);
            if (!correspFile.exists()) {
                throw new TigerImplausibleContentException("Cannot read annotation-data, because the specified file '" + correspFile.getAbsolutePath() + "' does not exist.");
            }
            AnnotationReader externalAnnotationReader = new AnnotationReader();
            externalAnnotationReader.setInputURI(URI.createFileURI((String)correspFile.getAbsolutePath()));
            externalAnnotationReader.setCorpus(this.getCorpus());
            XMLHelper.readXml(correspFile, externalAnnotationReader);
        }
        this.elementStack.push(qName);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.elementStack.size() > 0) {
            this.elementStack.pop();
        }
    }
}

