/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.resources;

import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import de.hu_berlin.german.korpling.tiger2.resources.tiger2.v205.Tiger2Resource;
import de.hu_berlin.german.korpling.tiger2.resources.tigerXML.TigerXMLResource;
import de.hu_berlin.german.korpling.tiger2.resources.util.Tiger2ContentChecker;
import de.hu_berlin.german.korpling.tiger2.resources.util.XMLHelper;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;

public class TigerResourceFactory
extends ResourceFactoryImpl {
    public static final String FILE_ENDING_TIGER2 = "tiger2";
    public static final String FILE_ENDING_TIGER2_2 = "tig2";
    public static final String FILE_ENDING_TIGERXML = "xml";
    public static final String FILE_ENDING_TIGERXML_2 = "tiger";

    public Resource createResource(URI uri) {
        ResourceImpl resource = null;
        if (FILE_ENDING_TIGER2.equalsIgnoreCase(uri.fileExtension())) {
            resource = new Tiger2Resource();
            resource.setURI(uri);
        } else if (FILE_ENDING_TIGERXML.equalsIgnoreCase(uri.fileExtension())) {
            resource = new TigerXMLResource();
            resource.setURI(uri);
        }
        return resource;
    }

    public static TIGER2_FILE_TYPES checkFileType(URI uri) {
        if (uri == null) {
            throw new TigerResourceException("Cannot check type of file located via given uri, because the given uri is null.");
        }
        Tiger2ContentChecker reader = new Tiger2ContentChecker();
        if (uri.toFileString() == null) {
            throw new TigerResourceException("Cannot check type of file located via given uri, because the given uri '" + uri + "' is convertable to a file.");
        }
        File xmlFile = new File(uri.toFileString());
        if (!xmlFile.exists()) {
            throw new TigerResourceException("Cannot check type of file located via given uri, because the given uri '" + uri + "' points to a non existing file '" + xmlFile.getAbsolutePath() + "'.");
        }
        XMLHelper.readXml(xmlFile, reader);
        return reader.getTiger2Type();
    }

    public static enum TIGER2_FILE_TYPES {
        TIGER2,
        TIGER2_SUBCORPUS,
        TIGER2_ANNOTATION,
        TIGER2_METADATA;

    }
}

