/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.main;

import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerException;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerResourceException;
import de.hu_berlin.german.korpling.tiger2.resources.TigerResourceFactory;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class Tiger2Converter {
    private ResourceSet resourceSet = new ResourceSetImpl();

    public Tiger2Converter() {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tiger2", new TigerResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tig2", new TigerResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new TigerResourceFactory());
    }

    public void convert(File inputFile, File outputFile, PARAMETERS convertMode) {
        if (inputFile == null) {
            throw new TigerException("Cannot convert files, because given inputFile is empty.");
        }
        if (outputFile == null) {
            throw new TigerException("Cannot convert files, because given inputFile is empty.");
        }
        if (!outputFile.isDirectory()) {
            throw new TigerException("Cannot convert files, because given outputFile is not a directory.");
        }
        this.convertRec(inputFile, outputFile, convertMode);
    }

    public void convertRec(File inputFile, File outputFile, PARAMETERS convertMode) {
        for (File subInputFile : inputFile.listFiles()) {
            if (subInputFile.isDirectory()) {
                File subOutFolder = new File(outputFile.getAbsolutePath() + "/" + subInputFile.getName());
                subOutFolder.mkdirs();
                this.convertRec(subInputFile, subOutFolder, convertMode);
                continue;
            }
            this.convertFiles(subInputFile, outputFile, convertMode);
        }
    }

    public void convertFiles(File inputFile, File outputFile, PARAMETERS convertMode) {
        if (inputFile == null) {
            throw new TigerException("Cannot convert files, because given inputFile is empty.");
        }
        if (outputFile == null) {
            throw new TigerException("Cannot convert files, because given inputFile is empty.");
        }
        if (inputFile.isDirectory()) {
            throw new TigerException("Cannot convert files, because given inputFile is a directory, please call methos convert(..) instead.");
        }
        if (!outputFile.exists()) {
            outputFile.mkdirs();
        }
        if (!outputFile.isDirectory()) {
            throw new TigerException("Cannot convert files, because given outputFile is not a directory.");
        }
        Corpus corpus = null;
        try {
            URI inputURI = URI.createFileURI((String)inputFile.toString());
            Resource resourceIn = this.resourceSet.createResource(inputURI);
            if (resourceIn == null) {
                throw new TigerException("No resource found for file '" + inputFile.getAbsolutePath() + "'.");
            }
            resourceIn.load(null);
            if (resourceIn.getContents() == null) {
                throw new TigerResourceException("Cannot load 'Corpus' object from uri '" + inputFile.getAbsolutePath() + "'.");
            }
            if (resourceIn.getContents().size() == 0) {
                throw new TigerResourceException("Cannot load 'Corpus' object from uri '" + inputFile.getAbsolutePath() + "'.");
            }
            Object corpObj = resourceIn.getContents().get(0);
            if (!(corpObj instanceof Corpus)) {
                throw new TigerResourceException("Cannot load 'Corpus' object from uri '" + inputFile.getAbsolutePath() + "', beacuse the file does not contain a <tiger2/> conform 'Corpus' object.");
            }
            corpus = (Corpus)corpObj;
        }
        catch (IOException e) {
            throw new TigerResourceException("Cannot load 'Corpus' object from uri '" + inputFile.getAbsolutePath() + "', beacuse of a nested exception.", e);
        }
        try {
            URI outputURI = null;
            if (convertMode.equals((Object)PARAMETERS.t_t2) || convertMode.equals((Object)PARAMETERS.t2_t2)) {
                outputURI = URI.createFileURI((String)(outputFile.getAbsolutePath() + "/" + inputFile.getName() + "." + "tiger2"));
            } else if (convertMode.equals((Object)PARAMETERS.t_t) || convertMode.equals((Object)PARAMETERS.t2_t)) {
                outputURI = URI.createFileURI((String)(outputFile.getAbsolutePath() + "/" + inputFile.getName() + "." + "xml"));
            } else {
                throw new TigerException("No matching convertMode was given.");
            }
            Resource resourceOut = this.resourceSet.createResource(outputURI);
            if (resourceOut == null) {
                throw new TigerException("No resource found for file '" + outputFile.getAbsolutePath() + "'.");
            }
            resourceOut.getContents().add((Object)corpus);
            resourceOut.save(null);
        }
        catch (IOException e) {
            throw new TigerResourceException("Cannot save 'Corpus' object from uri '" + inputFile.getAbsolutePath() + "', beacuse of a nested exception.", e);
        }
    }

    private static String sayHello() {
        StringBuffer buf = new StringBuffer();
        buf.append("**********************************************************************************\n");
        buf.append("***                          Welcome to <tiger2/> api                          ***\n");
        buf.append("**********************************************************************************\n");
        return buf.toString();
    }

    private static String getHelp() {
        StringBuffer buf = new StringBuffer();
        buf.append("Synopsis: -i INPUT_FILE -o OUTPUT_FILE [direction]\n");
        buf.append("\t INPUT_FILE determines an input file or folder\n");
        buf.append("\t OUTPUT_FOLDER determines the output folder\n");
        buf.append("direction:\n");
        buf.append("\t -t2_t transforms tigerXML data into <tiger2/> data\n");
        buf.append("\t -t_t2 transforms <tiger2/> data into tigerXML data\n");
        buf.append("\t -t_t transforms tigerXML data into tigerXML data\n");
        buf.append("\t -t2_t2 transforms <tiger2/> data into <tiger2/> data");
        return buf.toString();
    }

    private static String sayBye() {
        StringBuffer buf = new StringBuffer();
        buf.append("**********************************************************************************\n");
        buf.append("***                        good bye from <tiger2/> api                         ***\n");
        buf.append("**********************************************************************************\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println(Tiger2Converter.sayHello());
        try {
            if (args == null || args.length == 0) {
                System.out.println(Tiger2Converter.getHelp());
            }
            File inputFile = null;
            File outputFolder = null;
            PARAMETERS convertDirection = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.o))) {
                    outputFolder = new File(args[i + 1]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.i))) {
                    inputFile = new File(args[i + 1]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.t2_t))) {
                    convertDirection = PARAMETERS.t2_t;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.t_t2))) {
                    convertDirection = PARAMETERS.t_t2;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.t_t))) {
                    convertDirection = PARAMETERS.t_t;
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-" + (Object)((Object)PARAMETERS.t2_t2))) continue;
                convertDirection = PARAMETERS.t2_t2;
            }
            if (inputFile == null) {
                throw new IOException("No file or folder for tiger2 was given");
            }
            if (outputFolder == null) {
                throw new IOException("No file or folder for tigerXML was given");
            }
            if (convertDirection == null) {
                throw new NullPointerException("No convert direction is given.");
            }
            Tiger2Converter converter = new Tiger2Converter();
            if (inputFile.isDirectory()) {
                converter.convert(inputFile, outputFolder, convertDirection);
            } else {
                converter.convertFiles(inputFile, outputFolder, convertDirection);
            }
        }
        finally {
            System.out.println(Tiger2Converter.sayBye());
        }
    }

    static enum PARAMETERS {
        i,
        o,
        t2_t,
        t_t2,
        t_t,
        t2_t2;

    }
}

