/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.impl;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DEFAULT_TYPE;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.Tiger2Package;
import de.hu_berlin.german.korpling.tiger2.impl.AnnotationImpl;
import de.hu_berlin.german.korpling.tiger2.impl.CorpusImpl;
import de.hu_berlin.german.korpling.tiger2.impl.EdgeImpl;
import de.hu_berlin.german.korpling.tiger2.impl.FeatureImpl;
import de.hu_berlin.german.korpling.tiger2.impl.FeatureValueImpl;
import de.hu_berlin.german.korpling.tiger2.impl.GraphImpl;
import de.hu_berlin.german.korpling.tiger2.impl.MetaImpl;
import de.hu_berlin.german.korpling.tiger2.impl.NonTerminalImpl;
import de.hu_berlin.german.korpling.tiger2.impl.SegmentImpl;
import de.hu_berlin.german.korpling.tiger2.impl.TerminalImpl;
import java.net.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class Tiger2FactoryImpl
extends EFactoryImpl
implements Tiger2Factory {
    public static Tiger2Factory init() {
        try {
            Tiger2Factory theTiger2Factory = (Tiger2Factory)EPackage.Registry.INSTANCE.getEFactory("http://korpling.german.hu-berlin.de/tiger2/");
            if (theTiger2Factory != null) {
                return theTiger2Factory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new Tiger2FactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createGraph();
            }
            case 2: {
                return this.createNonTerminal();
            }
            case 3: {
                return this.createTerminal();
            }
            case 4: {
                return this.createEdge();
            }
            case 5: {
                return this.createSegment();
            }
            case 6: {
                return this.createCorpus();
            }
            case 7: {
                return this.createMeta();
            }
            case 9: {
                return this.createAnnotation();
            }
            case 10: {
                return this.createFeature();
            }
            case 11: {
                return this.createFeatureValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createDOMAINFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createDEFAULT_TYPEFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertDOMAINToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertDEFAULT_TYPEToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Graph createGraph() {
        GraphImpl graph = new GraphImpl();
        return graph;
    }

    @Override
    public NonTerminal createNonTerminal() {
        NonTerminalImpl nonTerminal = new NonTerminalImpl();
        return nonTerminal;
    }

    @Override
    public Terminal createTerminal() {
        TerminalImpl terminal = new TerminalImpl();
        return terminal;
    }

    @Override
    public Edge createEdge() {
        EdgeImpl edge = new EdgeImpl();
        return edge;
    }

    @Override
    public Segment createSegment() {
        SegmentImpl segment = new SegmentImpl();
        return segment;
    }

    @Override
    public Corpus createCorpus() {
        CorpusImpl corpus = new CorpusImpl();
        return corpus;
    }

    @Override
    public Meta createMeta() {
        MetaImpl meta = new MetaImpl();
        return meta;
    }

    @Override
    public Annotation createAnnotation() {
        AnnotationImpl annotation = new AnnotationImpl();
        return annotation;
    }

    @Override
    public Feature createFeature() {
        FeatureImpl feature = new FeatureImpl();
        return feature;
    }

    @Override
    public FeatureValue createFeatureValue() {
        FeatureValueImpl featureValue = new FeatureValueImpl();
        return featureValue;
    }

    public DOMAIN createDOMAINFromString(EDataType eDataType, String initialValue) {
        DOMAIN result = DOMAIN.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDOMAINToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DEFAULT_TYPE createDEFAULT_TYPEFromString(EDataType eDataType, String initialValue) {
        DEFAULT_TYPE result = DEFAULT_TYPE.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDEFAULT_TYPEToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return (URI)super.createFromString(eDataType, initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public Tiger2Package getTiger2Package() {
        return (Tiger2Package)this.getEPackage();
    }

    @Deprecated
    public static Tiger2Package getPackage() {
        return Tiger2Package.eINSTANCE;
    }
}

