/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.impl;

import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.SyntacticNode;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import de.hu_berlin.german.korpling.tiger2.Tiger2Package;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class GraphImpl
extends EObjectImpl
implements Graph {
    protected EList<Edge> edges;
    protected EList<SyntacticNode> syntacticNodes;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;

    protected GraphImpl() {
    }

    protected EClass eStaticClass() {
        return Tiger2Package.Literals.GRAPH;
    }

    @Override
    public EList<Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EObjectContainmentWithInverseEList(Edge.class, (InternalEObject)this, 0, 3);
        }
        return this.edges;
    }

    @Override
    public EList<SyntacticNode> getSyntacticNodes() {
        if (this.syntacticNodes == null) {
            this.syntacticNodes = new EObjectContainmentWithInverseEList(SyntacticNode.class, (InternalEObject)this, 1, 1);
        }
        return this.syntacticNodes;
    }

    @Override
    public EList<NonTerminal> getNonTerminals() {
        BasicEList retVal = new BasicEList();
        for (SyntacticNode synNode : this.getSyntacticNodes()) {
            if (!(synNode instanceof NonTerminal)) continue;
            retVal.add((Object)((NonTerminal)synNode));
        }
        return retVal;
    }

    @Override
    public EList<Terminal> getTerminals() {
        BasicEList retVal = new BasicEList();
        for (SyntacticNode synNode : this.getSyntacticNodes()) {
            if (!(synNode instanceof Terminal)) continue;
            retVal.add((Object)((Terminal)synNode));
        }
        return retVal;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public Segment getSegment() {
        if (this.eContainerFeatureID() != 5) {
            return null;
        }
        return (Segment)this.eContainer();
    }

    public NotificationChain basicSetSegment(Segment newSegment, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newSegment, 5, msgs);
        return msgs;
    }

    @Override
    public void setSegment(Segment newSegment) {
        if (newSegment != this.eInternalContainer() || this.eContainerFeatureID() != 5 && newSegment != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newSegment)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newSegment != null) {
                msgs = ((InternalEObject)newSegment).eInverseAdd((InternalEObject)this, 0, Segment.class, msgs);
            }
            if ((msgs = this.basicSetSegment(newSegment, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newSegment, (Object)newSegment));
        }
    }

    @Override
    public EList<Edge> getIncomingEdges(String nodeId) {
        BasicEList retVal = new BasicEList();
        for (Edge edge : this.getEdges()) {
            if (!edge.getTarget().getId().equals(nodeId)) continue;
            retVal.add((Object)edge);
        }
        if (retVal.size() == 0) {
            return null;
        }
        return retVal;
    }

    @Override
    public EList<Edge> getOutgoingEdges(String nodeId) {
        BasicEList retVal = new BasicEList();
        for (Edge edge : this.getEdges()) {
            if (!edge.getSource().getId().equals(nodeId)) continue;
            retVal.add((Object)edge);
        }
        if (retVal.size() == 0) {
            return null;
        }
        return retVal;
    }

    @Override
    public SyntacticNode findNode(String nodeId) {
        SyntacticNode retVal = null;
        if (nodeId != null && !nodeId.isEmpty()) {
            for (SyntacticNode synNode : this.getSyntacticNodes()) {
                if (!nodeId.equals(synNode.getId())) continue;
                retVal = synNode;
                break;
            }
        }
        return retVal;
    }

    @Override
    public Edge findEdge(String edgeId) {
        Edge retVal = null;
        if (edgeId != null && !edgeId.isEmpty()) {
            for (Edge edge : this.getEdges()) {
                if (!edgeId.equals(edge.getId())) continue;
                retVal = edge;
                break;
            }
        }
        return retVal;
    }

    @Override
    public EList<SyntacticNode> findRoots() {
        BasicEList retVal = null;
        HashSet<String> nonRoots = new HashSet<String>();
        for (Edge edge : this.getEdges()) {
            nonRoots.add(edge.getSource().getId());
        }
        for (SyntacticNode synNode : this.getSyntacticNodes()) {
            if (nonRoots.contains(synNode.getId())) continue;
            if (retVal == null) {
                retVal = new BasicEList();
            }
            retVal.add((Object)synNode);
        }
        return retVal;
    }

    @Override
    public SyntacticNode findRoot() {
        SyntacticNode retVal = null;
        EList<SyntacticNode> roots = this.findRoots();
        if (roots != null && roots.size() > 0) {
            retVal = (SyntacticNode)roots.get(0);
        }
        return retVal;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEdges()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getSyntacticNodes()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetSegment((Segment)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEdges()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getSyntacticNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.basicSetSegment(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 5: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 0, Segment.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEdges();
            }
            case 1: {
                return this.getSyntacticNodes();
            }
            case 2: {
                return this.getNonTerminals();
            }
            case 3: {
                return this.getTerminals();
            }
            case 4: {
                return this.getId();
            }
            case 5: {
                return this.getSegment();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEdges().clear();
                this.getEdges().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getSyntacticNodes().clear();
                this.getSyntacticNodes().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setId((String)newValue);
                return;
            }
            case 5: {
                this.setSegment((Segment)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEdges().clear();
                return;
            }
            case 1: {
                this.getSyntacticNodes().clear();
                return;
            }
            case 4: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 5: {
                this.setSegment(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 1: {
                return this.syntacticNodes != null && !this.syntacticNodes.isEmpty();
            }
            case 2: {
                return !this.getNonTerminals().isEmpty();
            }
            case 3: {
                return !this.getTerminals().isEmpty();
            }
            case 4: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 5: {
                return this.getSegment() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(')');
        return result.toString();
    }
}

