/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.tiger2.impl;

import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.DOMAIN;
import de.hu_berlin.german.korpling.tiger2.Feature;
import de.hu_berlin.german.korpling.tiger2.FeatureValue;
import de.hu_berlin.german.korpling.tiger2.Meta;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.Tiger2Factory;
import de.hu_berlin.german.korpling.tiger2.Tiger2Package;
import de.hu_berlin.german.korpling.tiger2.exceptions.TigerInvalidModelException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class CorpusImpl
extends EObjectImpl
implements Corpus {
    protected EList<Segment> segments;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected EList<Corpus> subCorpora;
    protected Meta meta;
    protected EList<Feature> features;
    private ConcurrentHashMap<String, Feature> featureNameDomain2FeatureMap = null;
    protected static final String FEATURE_SEPARATOR = "#";

    protected CorpusImpl() {
        this.init();
    }

    protected EClass eStaticClass() {
        return Tiger2Package.Literals.CORPUS;
    }

    protected void init() {
        this.featureNameDomain2FeatureMap = new ConcurrentHashMap();
    }

    public boolean eNotificationRequired() {
        return true;
    }

    public void eNotify(Notification notification) {
        super.eNotify(notification);
        if (notification.getFeature() instanceof EReference) {
            EReference ref = (EReference)notification.getFeature();
            if (ref.equals(Tiger2Package.Literals.CORPUS__FEATURES)) {
                Object newValue = notification.getNewValue();
                switch (notification.getEventType()) {
                    case 3: {
                        if (!(newValue instanceof Feature)) break;
                        Feature newFeature = (Feature)newValue;
                        String key = newFeature.getName() + FEATURE_SEPARATOR + (Object)((Object)newFeature.getDomain());
                        if (newFeature.getType() != null) {
                            key = key + FEATURE_SEPARATOR + newFeature.getType();
                        }
                        this.featureNameDomain2FeatureMap.put(key, newFeature);
                        break;
                    }
                    case 5: {
                        throw new UnsupportedOperationException("Adding more than one Feature object is not supported yet.");
                    }
                    case 4: {
                        if (!(notification.getOldValue() instanceof Feature) || !(newValue instanceof Feature)) break;
                        Feature newFeature = (Feature)newValue;
                        this.featureNameDomain2FeatureMap.remove(newFeature);
                        break;
                    }
                    case 6: {
                        throw new UnsupportedOperationException("Removing more than one Feature object is not supported yet.");
                    }
                }
            } else if (ref.equals(Tiger2Package.Literals.CORPUS__SEGMENTS)) {
                Object newValue = notification.getNewValue();
                switch (notification.getEventType()) {
                    case 3: {
                        Segment segment;
                        if (!(newValue instanceof Segment) || (segment = (Segment)newValue).getId() != null) break;
                        segment.setId("seg_" + (this.getSegments().size() + 1));
                    }
                }
            }
        }
    }

    @Override
    public EList<Segment> getSegments() {
        if (this.segments == null) {
            this.segments = new EObjectContainmentWithInverseEList(Segment.class, (InternalEObject)this, 0, 1);
        }
        return this.segments;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public EList<Corpus> getSubCorpora() {
        if (this.subCorpora == null) {
            this.subCorpora = new EObjectContainmentWithInverseEList(Corpus.class, (InternalEObject)this, 2, 3);
        }
        return this.subCorpora;
    }

    @Override
    public Corpus getSuperCorpus() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (Corpus)this.eContainer();
    }

    public NotificationChain basicSetSuperCorpus(Corpus newSuperCorpus, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newSuperCorpus, 3, msgs);
        return msgs;
    }

    @Override
    public void setSuperCorpus(Corpus newSuperCorpus) {
        if (newSuperCorpus != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newSuperCorpus != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newSuperCorpus)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newSuperCorpus != null) {
                msgs = ((InternalEObject)newSuperCorpus).eInverseAdd((InternalEObject)this, 2, Corpus.class, msgs);
            }
            if ((msgs = this.basicSetSuperCorpus(newSuperCorpus, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newSuperCorpus, (Object)newSuperCorpus));
        }
    }

    @Override
    public Meta getMeta() {
        return this.meta;
    }

    public NotificationChain basicSetMeta(Meta newMeta, NotificationChain msgs) {
        Meta oldMeta = this.meta;
        this.meta = newMeta;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldMeta, (Object)newMeta);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setMeta(Meta newMeta) {
        if (newMeta != this.meta) {
            NotificationChain msgs = null;
            if (this.meta != null) {
                msgs = ((InternalEObject)this.meta).eInverseRemove((InternalEObject)this, 7, Meta.class, msgs);
            }
            if (newMeta != null) {
                msgs = ((InternalEObject)newMeta).eInverseAdd((InternalEObject)this, 7, Meta.class, msgs);
            }
            if ((msgs = this.basicSetMeta(newMeta, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newMeta, (Object)newMeta));
        }
    }

    @Override
    public EList<Feature> getFeatures() {
        if (this.features == null) {
            this.features = new EObjectContainmentWithInverseEList(Feature.class, (InternalEObject)this, 5, 1);
        }
        return this.features;
    }

    @Override
    public Annotation createAnnotation(String name, DOMAIN domain, String value) {
        return this.createAnnotation(name, domain, null, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Annotation createAnnotation(String featureName, DOMAIN domain, String type, String featureValue) {
        Annotation retVal = null;
        if (featureName == null || featureName.isEmpty() || domain == null) return retVal;
        Feature feature = this.findFeature(featureName, domain, type);
        if (feature == null) {
            feature = this.findFeature(featureName, domain);
        }
        if (feature == null) throw new TigerInvalidModelException("Cannot create an annotation for feature '" + featureName + "' in domain '" + (Object)((Object)domain) + "' with value '" + featureValue + "', because there is no matching feature defined. Supported features are: " + this.featureNameDomain2FeatureMap);
        retVal = Tiger2Factory.eINSTANCE.createAnnotation();
        retVal.setFeatureRef(feature);
        FeatureValue featureValue1 = this.findFeatureValue(featureName, domain, type, featureValue);
        if (featureValue1 == null) {
            featureValue1 = this.findFeatureValue(featureName, domain, featureValue);
        }
        if (featureValue1 != null) {
            retVal.setFeatureValueRef(featureValue1);
            return retVal;
        } else if (featureValue1 == null && feature.getFeatureValues().size() == 0) {
            retVal.setValue(featureValue);
            return retVal;
        } else {
            BasicEList features = new BasicEList();
            Feature feature2 = this.findFeature(featureName, domain);
            if (feature2 == null || feature2.getFeatureValues() == null || feature2.getFeatureValues().size() <= 0) throw new TigerInvalidModelException("Cannot create an annotation for feature '" + featureName + "' in domain '" + (Object)((Object)domain) + "' and type '" + type + "' with value '" + featureValue + "', because there is no featureValue defined for such an annotation value. Known values are: " + features);
            for (FeatureValue featureValue2 : feature2.getFeatureValues()) {
                features.add((Object)featureValue2.getValue());
            }
            throw new TigerInvalidModelException("Cannot create an annotation for feature '" + featureName + "' in domain '" + (Object)((Object)domain) + "' and type '" + type + "' with value '" + featureValue + "', because there is no featureValue defined for such an annotation value. Known values are: " + features);
        }
    }

    @Override
    public FeatureValue findFeatureValue(String featureName, DOMAIN featureDomain, String featureValueValue) {
        return this.findFeatureValue(featureName, featureDomain, null, featureValueValue);
    }

    @Override
    public FeatureValue findFeatureValue(String featureName, DOMAIN featureDomain, String type, String featureValueValue) {
        Feature feature = this.findFeature(featureName, featureDomain, type);
        if (feature != null) {
            return feature.findFeatureValue(featureValueValue);
        }
        return null;
    }

    @Override
    public Feature findFeature(String featureName, DOMAIN domain) {
        return this.findFeature(featureName, domain, null);
    }

    @Override
    public Feature findFeature(String featureName, DOMAIN domain, String type) {
        String key = featureName + FEATURE_SEPARATOR + (Object)((Object)domain);
        if (type != null) {
            key = key + FEATURE_SEPARATOR + type;
        }
        return this.featureNameDomain2FeatureMap.get(key);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSegments()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSubCorpora()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetSuperCorpus((Corpus)otherEnd, msgs);
            }
            case 4: {
                if (this.meta != null) {
                    msgs = ((InternalEObject)this.meta).eInverseRemove((InternalEObject)this, -5, null, msgs);
                }
                return this.basicSetMeta((Meta)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getFeatures()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSegments()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSubCorpora()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetSuperCorpus(null, msgs);
            }
            case 4: {
                return this.basicSetMeta(null, msgs);
            }
            case 5: {
                return ((InternalEList)this.getFeatures()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, Corpus.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSegments();
            }
            case 1: {
                return this.getId();
            }
            case 2: {
                return this.getSubCorpora();
            }
            case 3: {
                return this.getSuperCorpus();
            }
            case 4: {
                return this.getMeta();
            }
            case 5: {
                return this.getFeatures();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getSegments().clear();
                this.getSegments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setId((String)newValue);
                return;
            }
            case 2: {
                this.getSubCorpora().clear();
                this.getSubCorpora().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setSuperCorpus((Corpus)newValue);
                return;
            }
            case 4: {
                this.setMeta((Meta)newValue);
                return;
            }
            case 5: {
                this.getFeatures().clear();
                this.getFeatures().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getSegments().clear();
                return;
            }
            case 1: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 2: {
                this.getSubCorpora().clear();
                return;
            }
            case 3: {
                this.setSuperCorpus(null);
                return;
            }
            case 4: {
                this.setMeta(null);
                return;
            }
            case 5: {
                this.getFeatures().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.segments != null && !this.segments.isEmpty();
            }
            case 1: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 2: {
                return this.subCorpora != null && !this.subCorpora.isEmpty();
            }
            case 3: {
                return this.getSuperCorpus() != null;
            }
            case 4: {
                return this.meta != null;
            }
            case 5: {
                return this.features != null && !this.features.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(')');
        return result.toString();
    }
}

