/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.corpus_tools.peppermodules.rstModules.models.AbstractNode;
import org.corpus_tools.peppermodules.rstModules.models.Group;
import org.corpus_tools.peppermodules.rstModules.models.RSTDocument;
import org.corpus_tools.peppermodules.rstModules.models.RSTException;
import org.corpus_tools.peppermodules.rstModules.models.Relation;
import org.corpus_tools.peppermodules.rstModules.models.SecondaryEdge;
import org.corpus_tools.peppermodules.rstModules.models.Segment;
import org.corpus_tools.peppermodules.rstModules.models.Signal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class RSTReader
extends DefaultHandler2 {
    private File rstFile = null;
    private RSTDocument rstDocument = null;
    private Stack<RSTElements> rstElementStack = null;
    private StringBuffer currentText = null;
    private HashMap<String, String> relNameType = null;
    private HashMap<String, Set<String>> signalTypes = null;
    private HashMap<String, AbstractNode> idAbstractNodeTable = null;
    private HashMap<String, Vector<Relation>> idRelationTable = null;
    private Segment currentSegment = null;

    public RSTReader() {
        this.init();
    }

    private void init() {
        this.idAbstractNodeTable = new HashMap();
        this.idRelationTable = new HashMap();
        this.rstElementStack = new Stack();
        this.relNameType = new HashMap();
        this.signalTypes = new HashMap();
    }

    public void setRstFile(File rstFile) {
        this.rstFile = rstFile;
    }

    public File getRstFile() {
        return this.rstFile;
    }

    public void setRSTDocument(RSTDocument rstDocument) {
        this.rstDocument = rstDocument;
    }

    public RSTDocument getRSTDocument() {
        return this.rstDocument;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.rstElementStack.peek().equals((Object)RSTElements.SEGMENT)) {
            if (this.currentSegment == null) {
                throw new RSTException("Cannot add the found text node in file '" + this.getRstFile().getAbsolutePath() + "', because it is not contained in a <segment>-element.");
            }
            if (this.currentText == null) {
                this.currentText = new StringBuffer();
            }
            for (int i = start; i < start + length; ++i) {
                if (ch[i] == '\n') continue;
                this.currentText.append(ch[i]);
            }
        }
    }

    private void addRelation2Table(String id, Relation relation) {
        Vector<Relation> slot = this.idRelationTable.get(id);
        if (slot == null) {
            slot = new Vector();
            this.idRelationTable.put(id, slot);
        }
        slot.add(relation);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rst")) {
            this.rstElementStack.push(RSTElements.RST);
        } else if (qName.equals("header")) {
            this.rstElementStack.push(RSTElements.HEADER);
        } else if (qName.equals("encoding")) {
            this.rstElementStack.push(RSTElements.ENCODING);
        } else if (qName.equals("relations")) {
            this.rstElementStack.push(RSTElements.RELATIONS);
        } else if (qName.equals("sigtypes")) {
            this.rstElementStack.push(RSTElements.SIGNAL_TYPES);
        } else if (qName.equals("sig")) {
            this.rstElementStack.push(RSTElements.SIGNAL_TYPE);
            String type = attributes.getValue("type");
            String[] subtypes = attributes.getValue("subtypes").split(";");
            this.signalTypes.put(type, new HashSet<String>(Arrays.asList(subtypes)));
        } else if (qName.equals("rel")) {
            this.rstElementStack.push(RSTElements.REL);
            String relName = attributes.getValue("name");
            String relType = attributes.getValue("type");
            this.relNameType.put(relName, relType);
        } else if (qName.equals("body")) {
            this.rstElementStack.push(RSTElements.BODY);
        } else if (qName.equals("segment")) {
            this.rstElementStack.push(RSTElements.SEGMENT);
            Segment segment = new Segment();
            segment.setId(attributes.getValue("id"));
            this.getRSTDocument().getSegments().add(segment);
            if (attributes.getValue("type") != null) {
                segment.setType(attributes.getValue("type"));
            }
            this.idAbstractNodeTable.put(attributes.getValue("id"), segment);
            this.currentSegment = segment;
            Vector<Relation> slot = this.idRelationTable.get(attributes.getValue("id"));
            if (slot != null) {
                for (Relation relation : slot) {
                    relation.setParent(segment);
                }
            }
            if (attributes.getValue("parent") != null) {
                AbstractNode parent;
                Relation relation = new Relation();
                relation.setChild(segment);
                this.getRSTDocument().getRelations().add(relation);
                if (attributes.getValue("relname") != null) {
                    String relname = attributes.getValue("relname");
                    relation.setName(relname);
                    if (this.relNameType.containsKey(relname)) {
                        relation.setType(this.relNameType.get(relname));
                    }
                }
                if ((parent = this.idAbstractNodeTable.get(attributes.getValue("parent"))) == null) {
                    this.addRelation2Table(attributes.getValue("parent"), relation);
                } else {
                    relation.setParent(parent);
                }
            }
        } else if (qName.equals("group")) {
            Object parent;
            this.rstElementStack.push(RSTElements.GROUP);
            Group group = new Group();
            group.setId(attributes.getValue("id"));
            this.getRSTDocument().getGroups().add(group);
            if (attributes.getValue("type") != null) {
                group.setType(attributes.getValue("type"));
            }
            this.idAbstractNodeTable.put(attributes.getValue("id"), group);
            Vector<Relation> slot = this.idRelationTable.get(attributes.getValue("id"));
            if (slot != null) {
                parent = slot.iterator();
                while (parent.hasNext()) {
                    Relation relation = parent.next();
                    relation.setParent(group);
                }
            }
            if (attributes.getValue("parent") != null) {
                Relation relation = new Relation();
                this.getRSTDocument().getRelations().add(relation);
                relation.setChild(group);
                if (attributes.getValue("relname") != null) {
                    String relname = attributes.getValue("relname");
                    relation.setName(relname);
                    if (this.relNameType.containsKey(relname)) {
                        relation.setType(this.relNameType.get(relname));
                    }
                }
                if ((parent = this.idAbstractNodeTable.get(attributes.getValue("parent"))) == null) {
                    this.addRelation2Table(attributes.getValue("parent"), relation);
                } else {
                    relation.setParent((AbstractNode)parent);
                }
            }
        } else if (qName.equals("signals")) {
            this.rstElementStack.push(RSTElements.SIGNALS);
        } else if (qName.equals("signal")) {
            this.rstElementStack.push(RSTElements.SIGNAL);
            Signal signal = new Signal();
            signal.setType(attributes.getValue("type"));
            signal.setSubtype(attributes.getValue("subtype"));
            ArrayList<Integer> tokenIds = new ArrayList<Integer>();
            String ids = attributes.getValue("tokens");
            if (ids.length() > 0) {
                for (String tokenId : ids.split(",")) {
                    tokenIds.add(Integer.parseInt(tokenId));
                }
                signal.setTokenIds(tokenIds);
            }
            AbstractNode sourceNode = this.idAbstractNodeTable.get(attributes.getValue("source"));
            signal.setSource(sourceNode);
            this.getRSTDocument().getSignals().add(signal);
        } else if (qName.equals("secedges")) {
            this.rstElementStack.push(RSTElements.SECONDARY_EDGES);
        } else if (qName.equals("secedge")) {
            this.rstElementStack.push(RSTElements.SECONDARY_EDGE);
            SecondaryEdge e = new SecondaryEdge();
            e.setId(attributes.getValue("id"));
            e.setRelationName(attributes.getValue("relname"));
            AbstractNode source = this.idAbstractNodeTable.get(attributes.getValue("source"));
            if (source == null) {
                throw new RSTException("Secondary edge references a source node that doesn't exist!");
            }
            e.setSource(source);
            AbstractNode target = this.idAbstractNodeTable.get(attributes.getValue("target"));
            if (target == null) {
                throw new RSTException("Secondary edge references a target node that doesn't exist!");
            }
            e.setTarget(target);
            this.idAbstractNodeTable.put(e.getId(), e);
            this.getRSTDocument().getSecondaryEdges().add(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.rstElementStack.pop();
        if (!qName.equals("body")) {
            if (qName.equals("segment")) {
                if (this.currentText != null) {
                    this.currentSegment.setText(this.currentText.toString());
                }
                this.currentText = null;
                this.currentSegment = null;
            } else if (qName.equals("group")) {
                // empty if block
            }
        }
    }

    public static enum RSTElements {
        RST,
        HEADER,
        ENCODING,
        RELATIONS,
        REL,
        BODY,
        SEGMENT,
        GROUP,
        SIGNAL_TYPES,
        SIGNAL_TYPE,
        SIGNALS,
        SIGNAL,
        SECONDARY_EDGES,
        SECONDARY_EDGE;

    }
}

