/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules;

import java.util.List;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class RSTImporterProperties
extends PepperModuleProperties {
    public static final String PREFIX = "rstImporter.";
    public static final String PROP_TOKENIZE = "rstImporter.tokenize";
    public static final String PROP_SIMPLE_TOKENIZE = "simpleTokenize";
    public static final String PROP_NODE_KIND_NAME = "rstImporter.nodeKindName";
    public static final String PROP_NODE_TYPE_NAME = "rstImporter.nodeTypeName";
    public static final String PROP_RELATION_NAME = "rstImporter.relationTypeName";
    public static final String PROP_SEGMENT_SEPARATOR = "rstImporter.segmentSeparator";
    public static final String PROP_MARK_IS_SIGNALED = "rstImporter.markIsSignaled";
    private Boolean isToTokenize = null;
    private List<Character> simpleTokSeparators = null;

    public RSTImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TOKENIZE, String.class, "Determines if the rst data have to be tokenized during import. Possible values are 'yes' and 'no'.", (Object)"yes", false));
        this.addProperty(new PepperModuleProperty(PROP_SIMPLE_TOKENIZE, String.class, "Switches on a very simple tokenization. With this property you can pass a list of characters, which should be used as separators to find the borders of tokens e.g. \"' ','.'\" to use a blank and a dot. Note that using this property will overwrite the default TreeTagger tokenizer. This property needs simpleTokenize to be set to true. ", false));
        this.addProperty(new PepperModuleProperty(PROP_NODE_KIND_NAME, String.class, "Specifies the sName of the SAnnotation to which the kind of a node (segment or group) is mapped to.", (Object)"kind", false));
        this.addProperty(new PepperModuleProperty(PROP_NODE_TYPE_NAME, String.class, "Specifies the sName of the SAnnotation to which the type attribute of a node is mapped to.", (Object)"type", false));
        this.addProperty(new PepperModuleProperty(PROP_RELATION_NAME, String.class, "Specifies the sName of the SAnnotation to which the name attribute of a relation is mapped to.", (Object)"relname", false));
        this.addProperty(new PepperModuleProperty(PROP_SEGMENT_SEPARATOR, String.class, "A property to add a a separator like a blank between the text of segments, when it is concatenated to the primary text in STextualDS.For instance the segment text 'Is' of segment1 and the segment text 'this' of segment2 will be concatenated to an sText value 'is'SEPARATOR'this'.", (Object)" ", false));
        this.addProperty(new PepperModuleProperty(PROP_MARK_IS_SIGNALED, String.class, "When set to 'yes', adds a new annotation 'is_signaled' to each edge indicating whether there is at least one signal associated with it.", (Object)"no", false));
    }

    public Boolean isToTokenize() {
        if (this.isToTokenize == null) {
            String tokenize = null;
            tokenize = (String)this.getProperty(PROP_TOKENIZE).getValue();
            if (tokenize != null) {
                if ("yes".equalsIgnoreCase(tokenize)) {
                    this.isToTokenize = true;
                } else if ("no".equalsIgnoreCase(tokenize)) {
                    this.isToTokenize = false;
                }
            } else {
                this.isToTokenize = true;
            }
        }
        return this.isToTokenize;
    }

    public List<Character> getSimpleTokenizationSeparators() {
        String seps;
        if (this.simpleTokSeparators == null && (seps = (String)this.getProperty(PROP_SIMPLE_TOKENIZE).getValue()) != null) {
            this.simpleTokSeparators = this.stringToCharList(seps);
        }
        return this.simpleTokSeparators;
    }

    public String getNodeKindName() {
        String kind = (String)this.getProperty(PROP_NODE_KIND_NAME).getValue();
        return kind;
    }

    public String getNodeTypeName() {
        String type = (String)this.getProperty(PROP_NODE_TYPE_NAME).getValue();
        return type;
    }

    public String getRelationName() {
        String relname = (String)this.getProperty(PROP_RELATION_NAME).getValue();
        return relname;
    }

    public String getSegmentSeparator() {
        String sep = (String)this.getProperty(PROP_SEGMENT_SEPARATOR).getValue();
        return sep;
    }

    public boolean getMarkIsSignaled() {
        String markIsSignaled = (String)this.getProperty(PROP_MARK_IS_SIGNALED).getValue();
        return markIsSignaled.equalsIgnoreCase("yes");
    }
}

