/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.rstModules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.rstModules.RSTImporterProperties;
import org.corpus_tools.peppermodules.rstModules.models.Group;
import org.corpus_tools.peppermodules.rstModules.models.RSTDocument;
import org.corpus_tools.peppermodules.rstModules.models.Relation;
import org.corpus_tools.peppermodules.rstModules.models.SecondaryEdge;
import org.corpus_tools.peppermodules.rstModules.models.Segment;
import org.corpus_tools.peppermodules.rstModules.models.Signal;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.SimpleTokenizer;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Node;

public class RST2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private RSTDocument currentRSTDocument = null;
    private Hashtable<String, SStructure> rstId2SStructure = null;
    private Tokenizer tokenizer = null;
    private Map<String, UUID> rstId2UUID = null;
    private Hashtable<String, SDominanceRelation> primaryEdgeIndex = null;
    public static final String NODE_KIND_SEGMENT = "segment";
    public static final String NODE_KIND_GROUP = "group";

    public RST2SaltMapper() {
        this.init();
    }

    private void init() {
        this.tokenizer = new Tokenizer();
        this.rstId2SStructure = new Hashtable();
        this.rstId2UUID = new Hashtable<String, UUID>();
        this.primaryEdgeIndex = new Hashtable();
    }

    public void setCurrentRSTDocument(RSTDocument currentRSTDocument) {
        this.rstId2SStructure = new Hashtable();
        this.rstId2UUID = new Hashtable<String, UUID>();
        this.primaryEdgeIndex = new Hashtable();
        this.currentRSTDocument = currentRSTDocument;
    }

    public RSTDocument getCurrentRSTDocument() {
        return this.currentRSTDocument;
    }

    public DOCUMENT_STATUS mapSDocument() {
        RSTDocument rstDocument = new RSTDocument(this.getResourceURI());
        this.rstId2SStructure = new Hashtable();
        this.rstId2UUID = new Hashtable<String, UUID>();
        this.primaryEdgeIndex = new Hashtable();
        this.mapSDocument(rstDocument);
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapSDocument(RSTDocument rstDocument) {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.setCurrentRSTDocument(rstDocument);
        if (this.getCurrentRSTDocument().getSegments().size() > 0) {
            if (((RSTImporterProperties)this.getProperties()).isToTokenize().booleanValue()) {
                this.mapSegmentsWithTokenize(this.getCurrentRSTDocument().getSegments());
            } else {
                this.mapSegmentsWithoutTokenize(this.getCurrentRSTDocument().getSegments());
            }
        }
        for (Group group : this.getCurrentRSTDocument().getGroups()) {
            this.mapGroup2SStructure(group);
        }
        for (Relation relation : this.getCurrentRSTDocument().getRelations()) {
            this.mapRelation(relation);
        }
        this.markTokens();
        this.markSecondaryEdges();
        this.markSignals();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void mapSegmentsWithTokenize(List<Segment> segments) {
        STextualDS sText = null;
        List<Character> simpleTokenizationSeparators = ((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators();
        int seenTokens = 0;
        Character[] seps = null;
        if (((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators() != null) {
            seps = ((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators().toArray(new Character[simpleTokenizationSeparators.size()]);
        }
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            for (Segment segment : segments) {
                SimpleTokenizer tokenizer;
                List tokens = null;
                int start = 0;
                if (sText.getText() != null) {
                    start = sText.getText().length();
                    String segmentSeparator = ((RSTImporterProperties)this.getProperties()).getSegmentSeparator();
                    sText.setText(sText.getText() + segmentSeparator + segment.getText());
                } else {
                    sText.setText(segment.getText());
                }
                int end = sText.getText().length();
                if (((RSTImporterProperties)this.getProperties()).getSimpleTokenizationSeparators() != null) {
                    tokenizer = new SimpleTokenizer();
                    seenTokens = this.getDocument().getDocumentGraph().getTokens().size() - 1;
                    tokenizer.setDocumentGraph(this.getDocument().getDocumentGraph());
                    tokenizer.tokenize(sText, Integer.valueOf(start), Integer.valueOf(end), seps);
                    tokens = this.getDocument().getDocumentGraph().getTokens().subList(seenTokens + 1, this.getDocument().getDocumentGraph().getTokens().size());
                } else {
                    tokenizer = this.getDocument().getDocumentGraph().createTokenizer();
                    tokens = tokenizer.tokenize(sText, null, Integer.valueOf(start), Integer.valueOf(end));
                }
                if (tokens == null || tokens.size() <= 0) continue;
                SStructure sStruct = SaltFactory.createSStructure();
                sStruct.setName(segment.getId());
                String nodeKindKey = ((RSTImporterProperties)this.getProperties()).getNodeKindName();
                String nodeTypeKey = ((RSTImporterProperties)this.getProperties()).getNodeTypeName();
                sStruct.createAnnotation(null, nodeKindKey, (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, nodeTypeKey, (Object)segment.getType());
                }
                this.rstId2SStructure.put(segment.getId(), sStruct);
                UUID uuid = UUID.randomUUID();
                sStruct.createAnnotation("TEMP", "uuid", (Object)uuid);
                this.rstId2UUID.put(segment.getId(), uuid);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                for (SToken sToken : tokens) {
                    SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                    sDomRel.setSource((Node)sStruct);
                    sDomRel.setTarget((Node)sToken);
                    this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
                }
            }
        }
    }

    private void mapSegmentsWithoutTokenize(List<Segment> segments) {
        STextualDS sText = null;
        if (segments != null && segments.size() > 0) {
            sText = SaltFactory.createSTextualDS();
            this.getDocument().getDocumentGraph().addNode((Node)sText);
            StringBuffer strBuffer = new StringBuffer();
            int i = 0;
            for (Segment segment : segments) {
                ++i;
                SStructure sStruct = SaltFactory.createSStructure();
                String nodeKindKey = ((RSTImporterProperties)this.getProperties()).getNodeKindName();
                String nodeTypeKey = ((RSTImporterProperties)this.getProperties()).getNodeTypeName();
                sStruct.createAnnotation(null, nodeKindKey, (Object)NODE_KIND_SEGMENT);
                if (segment.getType() != null) {
                    sStruct.createAnnotation(null, nodeTypeKey, (Object)segment.getType());
                }
                sStruct.setName(segment.getId());
                this.rstId2SStructure.put(segment.getId(), sStruct);
                UUID uuid = UUID.randomUUID();
                sStruct.createAnnotation("TEMP", "uuid", (Object)uuid);
                this.rstId2UUID.put(segment.getId(), uuid);
                this.getDocument().getDocumentGraph().addNode((Node)sStruct);
                SToken sToken = SaltFactory.createSToken();
                this.getDocument().getDocumentGraph().addNode((Node)sToken);
                STextualRelation sTextRel = SaltFactory.createSTextualRelation();
                sTextRel.setTarget((Node)sText);
                sTextRel.setSource((Node)sToken);
                sTextRel.setStart((Number)strBuffer.length());
                sTextRel.setEnd((Number)(strBuffer.length() + segment.getText().length()));
                this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sTextRel);
                SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                sDomRel.setSource((Node)sStruct);
                sDomRel.setTarget((Node)sToken);
                this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
                if (i != 0) {
                    strBuffer.append(((RSTImporterProperties)this.getProperties()).getSegmentSeparator());
                }
                strBuffer.append(segment.getText());
            }
            sText.setText(strBuffer.toString());
        }
    }

    private SStructure mapGroup2SStructure(Group group) {
        SStructure sStructure = null;
        if (group != null) {
            sStructure = SaltFactory.createSStructure();
            sStructure.setName(group.getId());
            String nodeNameKey = ((RSTImporterProperties)this.getProperties()).getNodeTypeName();
            if (group.getType() != null) {
                sStructure.createAnnotation(null, nodeNameKey, (Object)group.getType());
            }
            this.rstId2SStructure.put(group.getId(), sStructure);
            UUID uuid = UUID.randomUUID();
            sStructure.createAnnotation("TEMP", "uuid", (Object)uuid);
            this.rstId2UUID.put(group.getId(), uuid);
            SAnnotation sAnno = SaltFactory.createSAnnotation();
            sAnno.setName(((RSTImporterProperties)this.getProperties()).getNodeKindName());
            sAnno.setValue((Object)NODE_KIND_GROUP);
            sStructure.addAnnotation(sAnno);
            this.getDocument().getDocumentGraph().addNode((Node)sStructure);
        }
        return sStructure;
    }

    private void mapRelation(Relation relation) {
        if (relation != null) {
            if (relation.getParent() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation is empty.");
            }
            if (relation.getChild() == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the child of a relation is empty.");
            }
            SStructure sSource = this.rstId2SStructure.get(relation.getParent().getId());
            SStructure sTarget = this.rstId2SStructure.get(relation.getChild().getId());
            if (sSource == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation points to a non existing node with id '" + relation.getChild().getId() + "'.");
            }
            if (sTarget == null) {
                throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the parent of a relation belongs to a non existing node with id '" + relation.getParent().getId() + "'.");
            }
            SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
            if (relation.getType() != null) {
                sDomRel.setType(relation.getType());
            }
            sDomRel.setSource((Node)sSource);
            sDomRel.setTarget((Node)sTarget);
            this.getDocument().getDocumentGraph().addRelation((org.corpus_tools.salt.graph.Relation)sDomRel);
            this.primaryEdgeIndex.put(relation.getChild().getId(), sDomRel);
            if (relation.getName() != null) {
                String relationNameKey = ((RSTImporterProperties)this.getProperties()).getRelationName();
                sDomRel.createAnnotation(null, relationNameKey, (Object)relation.getName());
            }
        }
    }

    private void markSignals() {
        List<Signal> signals = this.getCurrentRSTDocument().getSignals();
        if (signals != null && signals.size() > 0) {
            for (Signal signal : this.getCurrentRSTDocument().getSignals()) {
                this.markSignal(signal);
            }
        }
    }

    private void markSignal(Signal signal) {
        if (signal == null) {
            return;
        }
        if (signal.getSource() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the source of a signal is empty.");
        }
        String sourceId = signal.getSource().getId();
        sourceId = sourceId.contains("-") ? sourceId.split("-")[0] : sourceId;
        SNode n = (SNode)this.rstId2SStructure.get(sourceId);
        if (n.getAnnotation("TEMP", "signals") == null) {
            n.createAnnotation("TEMP", "signals", new ArrayList());
        }
        List signalList = (List)n.getAnnotation("TEMP", "signals").getValue();
        HashMap<String, Object> signalMap = new HashMap<String, Object>();
        ArrayList<UUID> tokenIds = new ArrayList<UUID>();
        if (signal.getTokenIds() != null) {
            for (Integer tid : signal.getTokenIds()) {
                tokenIds.add(this.rstId2UUID.get("token" + tid));
            }
        }
        signalMap.put("signal:type", signal.getType());
        signalMap.put("signal:subtype", signal.getSubtype());
        signalMap.put("signal:tokens", tokenIds);
        ArrayList<UUID> source = new ArrayList<UUID>();
        if (signal.getSource().getId().contains("-")) {
            String part1 = signal.getSource().getId().split("-")[0];
            String part2 = signal.getSource().getId().split("-")[1];
            source.add(this.rstId2UUID.get(part1));
            source.add(this.rstId2UUID.get(part2));
        } else {
            source.add(this.rstId2UUID.get(signal.getSource().getId()));
        }
        signalMap.put("signal:source", source);
        signalList.add(signalMap);
    }

    private void markSecondaryEdges() {
        List<SecondaryEdge> secondaryEdges = this.getCurrentRSTDocument().getSecondaryEdges();
        if (secondaryEdges != null && secondaryEdges.size() > 0) {
            for (SecondaryEdge e : this.getCurrentRSTDocument().getSecondaryEdges()) {
                this.markSecondaryEdge(e);
            }
        }
    }

    private void markSecondaryEdge(SecondaryEdge e) {
        if (e == null) {
            return;
        }
        if (e.getSource() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file '" + this.getResourceURI() + "', because the source of a secondary edge is empty.");
        }
        if (e.getTarget() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file '" + this.getResourceURI() + "', because the target of a secondary edge is empty.");
        }
        SStructure sSource = this.rstId2SStructure.get(e.getSource().getId());
        SStructure sTarget = this.rstId2SStructure.get(e.getTarget().getId());
        if (sSource == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the source of a secondary edge points to a non existing node with id '" + e.getSource().getId() + "'.");
        }
        if (sTarget == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the rst-model of file'" + this.getResourceURI() + "', because the target of a secondary edgepoints to a non existing node with id '" + e.getTarget().getId() + "'.");
        }
        if (sSource.getAnnotation("TEMP", "secedges") == null) {
            sSource.createAnnotation("TEMP", "secedges", new ArrayList());
        }
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        sMap.put("edgeSource", this.rstId2UUID.get(e.getId().split("-")[0]));
        sMap.put("edgeTarget", this.rstId2UUID.get(e.getId().split("-")[1]));
        sMap.put("relationName", e.getRelationName());
        ((List)sSource.getAnnotation("TEMP", "secedges").getValue()).add(sMap);
    }

    private void markTokens() {
        int i = 1;
        for (SToken t : this.getDocument().getDocumentGraph().getTokens()) {
            UUID uuid = UUID.randomUUID();
            t.createAnnotation("TEMP", "uuid", (Object)uuid);
            this.rstId2UUID.put("token" + i++, uuid);
        }
        SNode n = (SNode)this.getDocument().getDocumentGraph().getNodes().get(0);
        if (n != null) {
            n.createAnnotation("TEMP", "rstid2uuid", this.rstId2UUID);
        }
    }
}

