/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tuebadzModules;

import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

public class Rearanger
extends PepperMapperImpl
implements GraphTraverseHandler {
    protected String[] topologicalAnnotations = new String[]{"VF", "LK", "MF", "VC", "C", "NF", "LV"};
    protected HashSet<String> topologicalAnnosHash = null;
    public static final String topoLayerName = "topo";
    public static final String topoAnnoName = "field";
    public static final String syntaxLayerName = "syntax";
    public static final String syntaxAnnoName = "phrase";
    public static final String hybridLayerName = "hybrid";
    public static final String hybridAnnoName = "node";
    protected SLayer topoLayer = null;
    protected SLayer syntaxLayer = null;
    protected SLayer hybridLayer = null;
    protected Stack<SStructure> topoPath = null;
    protected Stack<SStructure> syntaxPath = null;
    protected Stack<SStructure> hybridPath = null;
    protected SStructure topoRoot = null;
    protected SStructure syntaxRoot = null;
    protected SStructure hybridRoot = null;
    protected Vector<SStructure> topoStructsWithoutSToken = new Vector();
    protected Vector<SStructure> syntaxStructsWithoutSToken = new Vector();

    public Rearanger() {
        this.init();
    }

    protected void init() {
        this.topologicalAnnosHash = new HashSet();
        for (String topAnno : this.topologicalAnnotations) {
            this.topologicalAnnosHash.add(topAnno);
        }
    }

    protected void initLayers() {
        this.topoLayer = SaltFactory.createSLayer();
        this.topoLayer.setName(topoLayerName);
        this.syntaxLayer = SaltFactory.createSLayer();
        this.syntaxLayer.setName(syntaxLayerName);
        this.getDocument().getDocumentGraph().addLayer((Layer)this.syntaxLayer);
        this.getDocument().getDocumentGraph().addLayer((Layer)this.topoLayer);
    }

    protected void newSentence() {
        this.topoPath = new Stack();
        this.topoRoot = null;
        this.syntaxPath = new Stack();
        this.syntaxRoot = null;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        List roots = this.getDocument().getDocumentGraph().getRoots();
        this.getDocument().getDocumentGraph().traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "any", (GraphTraverseHandler)this);
        return DOCUMENT_STATUS.COMPLETED;
    }

    protected boolean isTopoNode(SStructure sStructure) {
        for (SAnnotation sAnno : sStructure.getAnnotations()) {
            if (!this.topologicalAnnosHash.contains(sAnno.getValue())) continue;
            return true;
        }
        return false;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        if (currNode instanceof SStructure) {
            SStructure sStructure = (SStructure)currNode;
            boolean belongsToToDuplicatingLayer = false;
            for (SLayer sLayer : sStructure.getLayers()) {
                if (!"tiger".equalsIgnoreCase(sLayer.getName())) continue;
                belongsToToDuplicatingLayer = true;
                break;
            }
            if (belongsToToDuplicatingLayer) {
                SDocumentGraph sDocGraph = sStructure.getGraph();
                SDominanceRelation sDRel = null;
                if (relation != null && relation instanceof SDominanceRelation) {
                    sDRel = (SDominanceRelation)relation;
                }
                if (this.hybridLayer == null) {
                    this.hybridLayer = SaltFactory.createSLayer();
                    this.hybridLayer.setName(hybridLayerName);
                    this.getDocument().getDocumentGraph().addLayer((Layer)this.hybridLayer);
                    sStructure.addLayer((Layer)this.hybridLayer);
                    if (sDRel != null) {
                        sDRel.addLayer((Layer)this.hybridLayer);
                    }
                }
                if (this.isTopoNode(sStructure)) {
                    SStructure father;
                    if (this.topoRoot == null) {
                        this.topoRoot = SaltFactory.createSStructure();
                        this.topoRoot.addLayer((Layer)this.topoLayer);
                        this.topoRoot.createAnnotation(null, topoAnnoName, (Object)"TOP");
                        this.getDocument().getDocumentGraph().addNode((Node)this.topoRoot);
                        this.topoPath.push(this.topoRoot);
                    }
                    SStructure topoNode = SaltFactory.createSStructure();
                    sDocGraph.addNode((Node)topoNode);
                    this.topoLayer.getNodes().add(topoNode);
                    if (sStructure.getAnnotations() != null) {
                        for (SAnnotation sAnno : sStructure.getAnnotations()) {
                            if (sAnno.getName().equalsIgnoreCase("cat")) {
                                topoNode.createAnnotation(topoLayerName, topoAnnoName, (Object)sAnno.getValue_STEXT());
                                continue;
                            }
                            topoNode.createAnnotation(sAnno.getNamespace(), sAnno.getName(), (Object)sAnno.getValue_STEXT());
                        }
                    }
                    if ((father = this.topoPath.peek()) != null) {
                        SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                        sDomRel.setSource((Node)father);
                        sDomRel.setTarget((Node)topoNode);
                        sDocGraph.addRelation((Relation)sDomRel);
                        sDomRel.addLayer((Layer)this.topoLayer);
                        if (sDRel != null && sDRel.getAnnotations() != null) {
                            for (SAnnotation sAnno : sDRel.getAnnotations()) {
                                sDomRel.createAnnotation(topoLayerName, topoAnnoName, (Object)sAnno.getValue_STEXT());
                            }
                        }
                    }
                    if (this.topoStructsWithoutSToken.contains(father)) {
                        this.topoStructsWithoutSToken.remove(father);
                    }
                    this.topoStructsWithoutSToken.add(topoNode);
                    this.topoPath.push(topoNode);
                } else {
                    SStructure syntaxNode = SaltFactory.createSStructure();
                    sDocGraph.addNode((Node)syntaxNode);
                    this.syntaxLayer.getNodes().add(syntaxNode);
                    if (this.syntaxRoot == null) {
                        this.syntaxRoot = syntaxNode;
                    }
                    if (sStructure.getAnnotations() != null) {
                        for (SAnnotation sAnno : sStructure.getAnnotations()) {
                            if (sAnno.getName().equalsIgnoreCase("cat")) {
                                syntaxNode.createAnnotation(syntaxLayerName, syntaxAnnoName, (Object)sAnno.getValue_STEXT());
                                continue;
                            }
                            syntaxNode.createAnnotation(sAnno.getNamespace(), sAnno.getName(), (Object)sAnno.getValue_STEXT());
                        }
                    }
                    SStructure father = null;
                    if (!this.syntaxPath.isEmpty()) {
                        father = this.syntaxPath.peek();
                    }
                    if (father != null) {
                        SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                        sDomRel.setSource((Node)father);
                        sDomRel.setTarget((Node)syntaxNode);
                        sDocGraph.addRelation((Relation)sDomRel);
                        if (sDRel != null && sDRel.getAnnotations() != null) {
                            for (SAnnotation sAnno : sDRel.getAnnotations()) {
                                sDomRel.createAnnotation(syntaxLayerName, sAnno.getName(), (Object)sAnno.getValue_STEXT());
                            }
                        }
                        sDomRel.addLayer((Layer)this.syntaxLayer);
                    }
                    if (this.syntaxStructsWithoutSToken.contains(father)) {
                        this.syntaxStructsWithoutSToken.remove(father);
                    }
                    this.syntaxStructsWithoutSToken.add(syntaxNode);
                    this.syntaxPath.push(syntaxNode);
                }
            }
        }
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
        if (currNode instanceof SStructure) {
            SStructure sStructure = (SStructure)currNode;
            if (this.isTopoNode(sStructure)) {
                if (this.topoPath.size() > 0) {
                    this.topoPath.pop();
                }
            } else if (this.syntaxPath.size() > 0) {
                this.syntaxPath.pop();
            }
        }
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        if (currNode instanceof SStructure) {
            return relation == null || relation instanceof SDominanceRelation;
        }
        if (currNode instanceof SToken) {
            if (relation instanceof SDominanceRelation) {
                SDominanceRelation sDomRel_new;
                if (this.topoPath != null && this.topoPath.size() > 0) {
                    sDomRel_new = this.connectStructWithStoken(this.topoPath.peek(), (SToken)currNode, (SDominanceRelation)relation);
                    sDomRel_new.setSource((Node)this.topoPath.peek());
                    sDomRel_new.addLayer((Layer)this.topoLayer);
                    if (sDomRel_new.getAnnotations() != null) {
                        for (SAnnotation sAnno : sDomRel_new.getAnnotations()) {
                            sDomRel_new.createAnnotation(topoLayerName, topoAnnoName, (Object)sAnno.getValue_STEXT());
                        }
                    }
                }
                if (this.syntaxPath != null && this.syntaxPath.size() > 0) {
                    sDomRel_new = this.connectStructWithStoken(this.syntaxPath.peek(), (SToken)currNode, (SDominanceRelation)relation);
                    sDomRel_new.setSource((Node)this.syntaxPath.peek());
                    sDomRel_new.addLayer((Layer)this.syntaxLayer);
                    if (sDomRel_new.getAnnotations() != null) {
                        for (SAnnotation sAnno : sDomRel_new.getAnnotations()) {
                            sDomRel_new.createAnnotation(syntaxLayerName, syntaxAnnoName, (Object)sAnno.getValue_STEXT());
                        }
                    }
                }
            }
            return false;
        }
        return false;
    }

    protected SDominanceRelation connectStructWithStoken(SStructure sStruct, SToken sToken, SDominanceRelation sDomRel) {
        SDocumentGraph sDocGraph = sStruct.getGraph();
        SDominanceRelation sDomRel_new = SaltFactory.createSDominanceRelation();
        sDomRel_new.setTarget((Node)sToken);
        sDocGraph.addRelation((Relation)sDomRel_new);
        return sDomRel_new;
    }
}

