/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_MoverModule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="MoverModuleManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class MoverModuleManipulator
extends PepperManipulatorImpl {
    public MoverModuleManipulator() {
        this.setName("Mover");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This manipulator moves annotations between objects, such as from edges to nodes");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        MoverModuleMapper mapper = new MoverModuleMapper();
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return true;
    }

    public static class MoverModuleMapper
    extends PepperMapperImpl
    implements GraphTraverseHandler {
        public DOCUMENT_STATUS mapSCorpus() {
            return DOCUMENT_STATUS.COMPLETED;
        }

        public DOCUMENT_STATUS mapSDocument() {
            String srcLayer = this.getProperties().getProperties().getProperty("Mover.sourceLayer", null);
            String srcAnnoName = this.getProperties().getProperties().getProperty("Mover.sourceAnno", null);
            String srcAnnoVal = this.getProperties().getProperties().getProperty("Mover.sourceAnnoValue", null);
            String srcAnnoNS = this.getProperties().getProperties().getProperty("Mover.sourceAnnoNamespace", null);
            String srcType = this.getProperties().getProperties().getProperty("Mover.sourceType", "edge");
            String srcName = this.getProperties().getProperties().getProperty("Mover.sourceName", null);
            String trgAnno = this.getProperties().getProperties().getProperty("Mover.targetAnno", null);
            String trgAnnoVal = this.getProperties().getProperties().getProperty("Mover.targetAnnoVal", null);
            String trgNS = this.getProperties().getProperties().getProperty("Mover.targetNamespace", null);
            String trgLayer = this.getProperties().getProperties().getProperty("Mover.targetLayer", null);
            String trgName = this.getProperties().getProperties().getProperty("Mover.targetName", null);
            String trgObj = this.getProperties().getProperties().getProperty("Mover.targetObject", "target");
            boolean removeOrig = Boolean.valueOf(this.getProperties().getProperties().getProperty("Mover.removeOrig"));
            SLayer trgNodeLayer = null;
            if (trgLayer != null) {
                trgNodeLayer = SaltFactory.createSLayer();
                trgNodeLayer.setName(trgLayer);
                this.getDocument().getDocumentGraph().addLayer((Layer)trgNodeLayer);
            }
            if (trgAnno == null) {
                trgAnno = srcAnnoName != null ? srcAnnoName : srcName;
            }
            if ("tok2node".equals(srcType)) {
                List toks = this.getDocument().getDocumentGraph().getTokens();
                for (SToken tok : toks) {
                    Set annos = tok.getAnnotations();
                    HashSet<SAnnotation> hashSet = new HashSet<SAnnotation>();
                    for (SAnnotation anno : annos) {
                        SDominanceRelation r;
                        SStructure n;
                        if (srcAnnoName != null && !srcAnnoName.equals(anno.getName()) || srcAnnoNS != null && !srcAnnoNS.equals(anno.getNamespace())) continue;
                        if ("struct".equals(trgObj)) {
                            n = SaltFactory.createSStructure();
                            r = SaltFactory.createSDominanceRelation();
                            if (trgNodeLayer != null) {
                                r.addLayer((Layer)trgNodeLayer);
                            }
                        } else {
                            n = SaltFactory.createSSpan();
                            r = SaltFactory.createSSpanningRelation();
                        }
                        if (trgNodeLayer != null) {
                            n.addLayer((Layer)trgNodeLayer);
                        }
                        String ns = trgNS;
                        String ann = trgAnno;
                        String val = trgAnnoVal;
                        if (trgNS == null) {
                            ns = anno.getNamespace();
                        }
                        if (trgAnno == null) {
                            ann = anno.getName();
                        }
                        if (trgAnnoVal == null) {
                            val = anno.getValue_STEXT();
                        }
                        n.createAnnotation(ns, ann, (Object)val);
                        r.setSource((Node)n);
                        r.setTarget((Node)tok);
                        this.getDocument().getDocumentGraph().addNode((Node)n);
                        this.getDocument().getDocumentGraph().addRelation((Relation)r);
                        if (!removeOrig) continue;
                        hashSet.add(anno);
                    }
                    for (SAnnotation anno : hashSet) {
                        tok.removeLabel(anno.getNamespace(), anno.getName());
                    }
                }
            } else {
                List rels = this.getDocument().getDocumentGraph().getRelations(SALT_TYPE.SPOINTING_RELATION);
                HashSet<SRelation> relsToRemove = new HashSet<SRelation>();
                HashSet<SPointingRelation> relsToAdd = new HashSet<SPointingRelation>();
                for (SRelation sRelation : rels) {
                    SNode target;
                    SNode source;
                    if (srcLayer != null) {
                        boolean found = false;
                        Set layers = sRelation.getLayers();
                        for (SLayer layer : layers) {
                            if (!layer.getName().equals(srcLayer)) continue;
                            found = true;
                        }
                        if (!found) continue;
                    }
                    if (srcName != null && (sRelation.getType() == null || !sRelation.getType().equals(srcName))) continue;
                    String annoVal = "";
                    if (srcAnnoName != null) {
                        if ("edge".equals(srcType)) {
                            SAnnotation srcAnno = sRelation.getAnnotation(srcAnnoNS, srcAnnoName);
                            if (srcAnno == null) continue;
                            annoVal = srcAnno.getValue_STEXT();
                        } else if ("source2target".equals(srcType)) {
                            if (srcAnnoName.equals("tok")) {
                                if (!(sRelation.getSource() instanceof SToken)) continue;
                                annoVal = this.getDocument().getDocumentGraph().getText((SNode)sRelation.getSource());
                            } else if (srcAnnoNS != null) {
                                SAnnotation srcAnno = ((SNode)sRelation.getSource()).getAnnotation(srcAnnoNS, srcAnnoName);
                                if (srcAnno == null) continue;
                                annoVal = srcAnno.getValue_STEXT();
                                if (removeOrig) {
                                    ((SNode)sRelation.getSource()).removeLabel(srcAnnoNS, srcAnnoName);
                                }
                            } else {
                                boolean found = false;
                                Set annos = ((SNode)sRelation.getSource()).getAnnotations();
                                for (SAnnotation a : annos) {
                                    if (!a.getName().equals(srcAnnoName)) continue;
                                    annoVal = a.getValue_STEXT();
                                    found = true;
                                }
                                if (!found) continue;
                            }
                            if (srcAnnoVal != null) {
                                // empty if block
                            }
                        } else if (!"edge2edge".equals(srcType)) {
                            throw new PepperModuleDataException((PepperMapper)this, "Unknown move type: " + srcType + ". Move type should be one of: edge, source2target");
                        }
                    } else if (trgAnnoVal != null) {
                        annoVal = trgAnnoVal;
                    } else {
                        throw new PepperModuleDataException((PepperMapper)this, "No source annotation or fixed target annotation set - cannot assign null annotation");
                    }
                    if ("target".equals(trgObj)) {
                        source = (SNode)sRelation.getSource();
                        target = (SNode)sRelation.getTarget();
                    } else {
                        source = (SNode)sRelation.getTarget();
                        target = (SNode)sRelation.getSource();
                    }
                    if ("edge2edge".equals(srcType)) {
                        boolean found = srcAnnoName == null;
                        Set annos = sRelation.getAnnotations();
                        for (SAnnotation a : annos) {
                            if (!a.getName().equals(srcAnnoName)) continue;
                            annoVal = a.getValue_STEXT();
                            found = true;
                        }
                        if (!found) continue;
                        if (srcAnnoVal != null) {
                            found = false;
                            for (SAnnotation a : annos) {
                                if (!a.getValue_STEXT().matches(srcAnnoVal)) continue;
                                found = true;
                            }
                            if (!found) continue;
                        }
                        SPointingRelation newRel = SaltFactory.createSPointingRelation();
                        newRel.setSource((Node)((SStructuredNode)source));
                        newRel.setTarget((Node)((SStructuredNode)target));
                        newRel.setType(trgName);
                        for (SAnnotation ann : sRelation.getAnnotations()) {
                            String annNS = trgNS == null ? ann.getNamespace() : trgNS;
                            String annName = trgAnno == null ? ann.getName() : trgAnno;
                            String annVal = trgAnnoVal == null ? ann.getValue_STEXT() : trgAnnoVal;
                            newRel.createAnnotation(annNS, annName, (Object)annVal);
                        }
                        relsToAdd.add(newRel);
                        if (!removeOrig) continue;
                        relsToRemove.add(sRelation);
                        continue;
                    }
                    SAnnotation anno = SaltFactory.createSAnnotation();
                    anno.setName(trgAnno);
                    anno.setNamespace(trgNS);
                    anno.setValue((Object)annoVal);
                    target.addAnnotation(anno);
                }
                for (SRelation sRelation : relsToRemove) {
                    this.getDocument().getDocumentGraph().removeRelation((Relation)sRelation);
                }
                for (SRelation sRelation : relsToAdd) {
                    if (trgNodeLayer != null) {
                        sRelation.addLayer((Layer)trgNodeLayer);
                    }
                    this.getDocument().getDocumentGraph().addRelation((Relation)sRelation);
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
            return !(currNode instanceof STextualDS);
        }
    }
}

