/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tigerModules.mappers;

import de.hu_berlin.german.korpling.tiger2.AnnotatableElement;
import de.hu_berlin.german.korpling.tiger2.Annotation;
import de.hu_berlin.german.korpling.tiger2.Corpus;
import de.hu_berlin.german.korpling.tiger2.Edge;
import de.hu_berlin.german.korpling.tiger2.Graph;
import de.hu_berlin.german.korpling.tiger2.NonTerminal;
import de.hu_berlin.german.korpling.tiger2.Segment;
import de.hu_berlin.german.korpling.tiger2.SyntacticNode;
import de.hu_berlin.german.korpling.tiger2.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.tigerModules.Tiger2ImporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SNamedElement;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tiger22SaltMapper
extends PepperMapperImpl {
    private final Logger log = LoggerFactory.getLogger(Tiger22SaltMapper.class);
    protected Corpus corpus = null;
    protected Map<SyntacticNode, SNode> synNode2sNode = null;
    protected Map<Edge, SRelation> edge2sRelation = null;
    private StringBuffer entireTextBuffer = new StringBuffer();

    public Corpus getTigerCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Tiger2ImporterProperties getProps() {
        return (Tiger2ImporterProperties)this.getProperties();
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.synNode2sNode = Collections.synchronizedMap(new Hashtable());
        this.edge2sRelation = Collections.synchronizedMap(new Hashtable());
        this.mapMetaAnnotations(this.corpus, (SAnnotationContainer)this.getDocument());
        this.entireTextBuffer = new StringBuffer();
        STextualDS sTextualDs = SaltFactory.createSTextualDS();
        this.getDocument().getDocumentGraph().addNode((Node)sTextualDs);
        if (this.getTigerCorpus().getSegments() != null) {
            for (Segment segment : this.getTigerCorpus().getSegments()) {
                if (segment == null) continue;
                List<SToken> sTokens = null;
                if (segment.getGraphs().size() > 1) {
                    sTokens = new ArrayList<SToken>();
                }
                if (segment.getGraphs() != null) {
                    for (Graph graph : segment.getGraphs()) {
                        if (graph == null) continue;
                        if (sTokens == null) {
                            sTokens = this.mapTerminals((List<Terminal>)graph.getTerminals(), sTextualDs);
                        } else {
                            sTokens.addAll(this.mapTerminals((List<Terminal>)graph.getTerminals(), sTextualDs));
                        }
                        this.mapNonTerminals((List<NonTerminal>)graph.getNonTerminals());
                        this.mapRelations((List<Edge>)graph.getEdges());
                    }
                }
                if (this.getProps() == null || !this.getProps().propCreateSSpan4Segment()) continue;
                this.getDocument().getDocumentGraph().createSpan(sTokens);
            }
        }
        sTextualDs.setText(this.entireTextBuffer.toString());
        return DOCUMENT_STATUS.COMPLETED;
    }

    protected List<SToken> mapTerminals(List<Terminal> terminals, STextualDS sTextualDs) {
        ArrayList<SToken> sTokens = null;
        if (terminals == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map terminals, because the given list is empty.");
        }
        if (terminals.size() > 0) {
            sTokens = new ArrayList<SToken>();
            for (Terminal terminal : terminals) {
                sTokens.add(this.mapTerminal(terminal, sTextualDs));
            }
        }
        return sTokens;
    }

    protected SToken mapTerminal(Terminal terminal, STextualDS sTextualDs) {
        if (terminal == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map a terminal to salt, because the terminal is empty.");
        }
        if (sTextualDs == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map the terminal '" + terminal + "' to salt, because the given sTextualDs is empty.");
        }
        int startPos = 0;
        int endPos = 0;
        if (this.entireTextBuffer.length() != 0) {
            this.entireTextBuffer.append(this.getProps().getSeparator());
        }
        if (this.entireTextBuffer != null && this.entireTextBuffer.length() != 0) {
            startPos = this.entireTextBuffer.length();
        }
        this.entireTextBuffer.append(terminal.getWord());
        if (this.entireTextBuffer != null && this.entireTextBuffer.length() != 0) {
            endPos = this.entireTextBuffer.length();
        }
        SToken sToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)sTextualDs, Integer.valueOf(startPos), Integer.valueOf(endPos));
        this.synNode2sNode.put((SyntacticNode)terminal, (SNode)sToken);
        this.mapAnnotations((AnnotatableElement)terminal, (SAnnotationContainer)sToken);
        return sToken;
    }

    protected void mapRelations(List<Edge> edges) {
        if (edges != null) {
            for (Edge edge : edges) {
                SNode tmpNode;
                if (edge == null) continue;
                Object sRelation = null;
                if (edge.getSource() == null) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot map the edge '" + edge + "', because its source is empty");
                }
                SNode sourceSNode = this.synNode2sNode.get(edge.getSource());
                if (sourceSNode == null) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot map the edge '" + edge + "', because its source '" + edge.getSource() + "' has no corresponding SNode object.");
                }
                if (edge.getTarget() == null) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot map the edge '" + edge + "', because its target is empty");
                }
                SNode targetNode = this.synNode2sNode.get(edge.getTarget());
                if (targetNode == null) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot map the edge '" + edge + "', because its source '" + edge.getTarget() + "' has no corresponding SNode object.");
                }
                SALT_TYPE saltType = null;
                if (this.getProps() != null && edge.getType() != null) {
                    Map<String, SALT_TYPE> saltTypes = this.getProps().getPropRelation2SRelation();
                    saltType = saltTypes.get(edge.getType());
                }
                if (this.getProps() != null && this.getProps().getRelationReversed().contains(edge.getType())) {
                    tmpNode = sourceSNode;
                    sourceSNode = targetNode;
                    targetNode = tmpNode;
                }
                if (sourceSNode instanceof SToken) {
                    if (saltType != null && SALT_TYPE.SDOMINANCE_RELATION.equals(saltType)) {
                        this.log.warn("Had to reverse the order of the edge between {} and {} since the source node can't be a token.", (Object)sourceSNode.getId(), (Object)targetNode.getId());
                        sRelation = SaltFactory.createSDominanceRelation();
                        tmpNode = sourceSNode;
                        sourceSNode = targetNode;
                        targetNode = tmpNode;
                    } else {
                        sRelation = SaltFactory.createSPointingRelation();
                    }
                } else {
                    sRelation = sourceSNode instanceof SSpan && targetNode instanceof SToken ? (saltType != null && SALT_TYPE.SPOINTING_RELATION.equals((Object)saltType) ? SaltFactory.createSPointingRelation() : SaltFactory.createSSpanningRelation()) : (sourceSNode instanceof SStructure ? (saltType != null && SALT_TYPE.SPOINTING_RELATION.equals((Object)saltType) ? SaltFactory.createSPointingRelation() : SaltFactory.createSDominanceRelation()) : SaltFactory.createSPointingRelation());
                }
                if (edge.getType() != null && !edge.getType().isEmpty()) {
                    String newType = null;
                    if (this.getProps().getRenamingMap_RelationType() != null) {
                        newType = this.getProps().getRenamingMap_RelationType().get(edge.getType());
                    }
                    if (newType != null) {
                        sRelation.setType(newType);
                    } else {
                        sRelation.setType(edge.getType());
                    }
                }
                sRelation.setSource((Node)sourceSNode);
                sRelation.setTarget((Node)targetNode);
                this.mapAnnotations((AnnotatableElement)edge, (SAnnotationContainer)sRelation);
                this.getDocument().getDocumentGraph().addRelation((Relation)sRelation);
                this.edge2sRelation.put(edge, (SRelation)sRelation);
            }
        }
    }

    protected void mapNonTerminals(List<NonTerminal> nonTerminals) {
        if (nonTerminals != null) {
            for (NonTerminal nonTerminal : nonTerminals) {
                if (nonTerminal == null) continue;
                SStructure sStructure = SaltFactory.createSStructure();
                this.mapAnnotations((AnnotatableElement)nonTerminal, (SAnnotationContainer)sStructure);
                this.getDocument().getDocumentGraph().addNode((Node)sStructure);
                this.synNode2sNode.put((SyntacticNode)nonTerminal, (SNode)sStructure);
            }
        }
    }

    protected void mapAnnotations(AnnotatableElement annotatableElement, SAnnotationContainer sAnnotatableElement) {
        if (annotatableElement == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map annotations, because the source element is empty.");
        }
        if (sAnnotatableElement == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map annotations, because the target element is empty.");
        }
        for (Annotation annotation : annotatableElement.getAnnotations()) {
            String newName = null;
            String annoName = "";
            if (this.getProps().getRenamingMap_AnnotationName() != null) {
                newName = this.getProps().getRenamingMap_AnnotationName().get(annotation.getName());
            }
            annoName = newName != null ? newName : annotation.getName();
            sAnnotatableElement.createAnnotation(null, annoName, (Object)annotation.getValue());
        }
    }

    protected void mapMetaAnnotations(Corpus corpus, SAnnotationContainer sMetaAnnotatableElement) {
        if (corpus == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map annotations, because the source element is empty.");
        }
        if (sMetaAnnotatableElement == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot map annotations, because the target element is empty.");
        }
        if (corpus.getMeta() != null) {
            if (corpus.getMeta().getAuthor() != null) {
                sMetaAnnotatableElement.createMetaAnnotation(null, "author", (Object)corpus.getMeta().getAuthor());
            }
            if (corpus.getMeta().getDate() != null) {
                sMetaAnnotatableElement.createMetaAnnotation(null, "date", (Object)corpus.getMeta().getDate());
            }
            if (corpus.getMeta().getDescription() != null) {
                sMetaAnnotatableElement.createMetaAnnotation(null, "description", (Object)corpus.getMeta().getDescription());
            }
            if (corpus.getMeta().getFormat() != null) {
                sMetaAnnotatableElement.createMetaAnnotation(null, "format", (Object)corpus.getMeta().getFormat());
            }
            if (corpus.getMeta().getHistory() != null) {
                sMetaAnnotatableElement.createMetaAnnotation(null, "history", (Object)corpus.getMeta().getHistory());
            }
            if (sMetaAnnotatableElement instanceof SNamedElement) {
                ((SNamedElement)sMetaAnnotatableElement).setName(corpus.getMeta().getName());
            }
        }
    }
}

