/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.tigerModules;

import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModulePropertyException;
import org.corpus_tools.salt.SALT_TYPE;

public class Tiger2ImporterProperties
extends PepperModuleProperties {
    public static final String PROP_CREATE_SSPAN = "createSSpan4Segment";
    public static final String PROP_EDGE_2_SRELATION = "map";
    public static final String DEFAULT_SEPARATOR = " ";
    public static final String PROP_TERMINAL_SEPARATOR = "separator";
    public static final String PROP_RENAME_EDGE_TYPE = "edge.type";
    public static final String PROP_RENAME_ANNOTATION_NAME = "annotation.name";
    public static final String PROP_EDGE_REVERSE = "edge.reverse";
    private Map<String, SALT_TYPE> edge2Relation = null;
    private Map<String, String> renamingRelationType = null;
    private Map<String, String> renamingAnnotationName = null;

    public Tiger2ImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_CREATE_SSPAN, Boolean.class, "This flag determines if a SSpan object shall be created for each segment. Must be mappable to a Boolean value.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_EDGE_2_SRELATION, String.class, "Property to determine, which Egde type shall be mapped to which kind of SRelation. A mapping has the syntax type=SALT_TYPE(, type=SALT_TYPE)*. For instance 'dep=" + SALT_TYPE.SPOINTING_RELATION + ", prim=" + SALT_TYPE.SDOMINANCE_RELATION + "'.", (Object)("secedge:" + SALT_TYPE.SDOMINANCE_RELATION), false));
        this.addProperty(new PepperModuleProperty(PROP_TERMINAL_SEPARATOR, String.class, "Determines the separator between terminal nodes. The default separator is ' '.", (Object)DEFAULT_SEPARATOR, false));
        this.addProperty(new PepperModuleProperty(PROP_RENAME_EDGE_TYPE, String.class, "Gives a renaming table for the sType of a SRelation. The syntax of defining such a table is 'OLDNAME=NEWNAME (,OLDNAME=NEWNAME)*', for instance the property value prim=edge, sec=secedge, will rename all sType values from 'prim' to edge and 'sec' to secedge.", false));
        this.addProperty(new PepperModuleProperty(PROP_RENAME_ANNOTATION_NAME, String.class, "Gives a renaming table for the name of an annotation, or more specific, which value the sName of the SAnnotation object shall get. The syntax of defining such a table is 'OLDNAME=NEWNAME (,OLDNAME=NEWNAME)*', for instance the property value prim=edge, sec=secedge, will rename all sType values from 'prim' to edge and 'sec' to secedge.", false));
        this.addProperty(new PepperModuleProperty(PROP_EDGE_REVERSE, String.class, "If true this will reverse the direction of edges having the given types.\nThus the source node becomes the target node and the target node\nbecomes the source node. This is useful when secondary edges are mapped to dominance\nedges and the annotation scheme would introduce cycles. \nBy inverting the edges, cycles are avoided.\nThis must be a list of type names, seperated by comma.", (Object)"secedge,sec", false));
    }

    public void reset() {
        this.renamingRelationType = null;
        this.renamingAnnotationName = null;
    }

    public boolean propCreateSSpan4Segment() {
        return (Boolean)this.getProperty(PROP_CREATE_SSPAN).getValue();
    }

    public void setPropertyValues(Properties properties) {
        super.setPropertyValues(properties);
    }

    public synchronized Map<String, SALT_TYPE> getPropRelation2SRelation() {
        if (this.edge2Relation == null) {
            String edgeTypes;
            this.edge2Relation = new Hashtable<String, SALT_TYPE>();
            if (this.getProperty(PROP_EDGE_2_SRELATION).getValue() != null && (edgeTypes = this.getProperty(PROP_EDGE_2_SRELATION).getValue().toString()) != null && !edgeTypes.isEmpty()) {
                String[] mappings;
                for (String mapping : mappings = edgeTypes.split(",")) {
                    SALT_TYPE saltType;
                    String[] parts = mapping.split(":");
                    if (parts[0] == null || parts[0].isEmpty() || parts[1] == null || parts[1].isEmpty() || (saltType = SALT_TYPE.valueOf((String)parts[1].trim())) == null) continue;
                    this.edge2Relation.put(parts[0].trim(), saltType);
                }
            }
        }
        return this.edge2Relation;
    }

    public String getSeparator() {
        return (String)this.getProperty(PROP_TERMINAL_SEPARATOR).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRenamingMap_RelationType() {
        if (this.renamingRelationType == null) {
            Tiger2ImporterProperties tiger2ImporterProperties = this;
            synchronized (tiger2ImporterProperties) {
                if (this.renamingRelationType == null) {
                    String[] mappings;
                    Hashtable<String, String> renamingTable = new Hashtable<String, String>();
                    String renamingString = (String)this.getProperty(PROP_RENAME_EDGE_TYPE).getValue();
                    if (renamingString != null && !(renamingString = renamingString.replace(DEFAULT_SEPARATOR, "")).isEmpty() && (mappings = renamingString.split(",")).length > 0) {
                        for (String mapping : mappings) {
                            String[] parts = mapping.split("=");
                            if (parts.length != 2) {
                                throw new PepperModulePropertyException("Cannot parse the given property value '" + (String)this.getProperty(PROP_RENAME_EDGE_TYPE).getValue() + "' for property '" + PROP_TERMINAL_SEPARATOR + "', because it does not follow the form OLDNAME=NEWNAME (,OLDNAME=NEWNAME)*. Note, that neither an empty String nor the whitespace is allowed as sType.");
                            }
                            renamingTable.put(parts[0], parts[1]);
                        }
                    }
                    this.renamingRelationType = renamingTable;
                }
            }
        }
        return this.renamingRelationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRenamingMap_AnnotationName() {
        if (this.renamingAnnotationName == null) {
            Tiger2ImporterProperties tiger2ImporterProperties = this;
            synchronized (tiger2ImporterProperties) {
                if (this.renamingAnnotationName == null) {
                    String[] mappings;
                    Hashtable<String, String> renamingTable = new Hashtable<String, String>();
                    String renamingString = (String)this.getProperty(PROP_RENAME_ANNOTATION_NAME).getValue();
                    if (renamingString != null && !(renamingString = renamingString.replace(DEFAULT_SEPARATOR, "")).isEmpty() && (mappings = renamingString.split(",")).length > 0) {
                        for (String mapping : mappings) {
                            String[] parts = mapping.split("=");
                            if (parts.length != 2) {
                                throw new PepperModulePropertyException("Cannot parse the given property value '" + (String)this.getProperty(PROP_RENAME_EDGE_TYPE).getValue() + "' for property '" + PROP_TERMINAL_SEPARATOR + "', because it does not follow the form OLDNAME=NEWNAME (,OLDNAME=NEWNAME)*. Note, that neither an empty String nor the whitespace is allowed as sName.");
                            }
                            renamingTable.put(parts[0], parts[1]);
                        }
                    }
                    this.renamingAnnotationName = renamingTable;
                }
            }
        }
        return this.renamingAnnotationName;
    }

    public Set<String> getRelationReversed() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String raw = (String)this.getProperty(PROP_EDGE_REVERSE).getValue();
        for (String t : raw.split(",")) {
            String trimmed = t.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }
}

